<?php

use App\Enums\RoleEnum;
use App\Helpers\MetaClient;
use App\Helpers\Wati;
use App\Http\Controllers\Admin\AssociationController;
use App\Http\Controllers\Admin\MailTemplateController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\MessageTemplateController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\QueryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\UserController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;


Route::middleware(['auth', 'isValidRole:' . RoleEnum::SUPER_ADMIN])->group(function () {
    Route::get('/meta-tables/{secretKey}/{modalName}', [QueryController::class, 'metaTables']);
    Route::get('/logs/{secretKey}/{log}', [QueryController::class, 'logs']);

    Route::get("test-meta", function () {
        $api = new MetaClient();
        $response = $api->getMessageTemplates();
        $json = $response->json();
        dd($json);
    });

    Route::get("test-contact", function () {
        $watiToken = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJqdGkiOiJmZTQyZWI4ZS1iYzI1LTQ2ODQtODdlOS1lZTdjMDY0MzNjNzQiLCJ1bmlxdWVfbmFtZSI6ImluZm8udmRvdGVjaG5vbG9naWVzQGdtYWlsLmNvbSIsIm5hbWVpZCI6ImluZm8udmRvdGVjaG5vbG9naWVzQGdtYWlsLmNvbSIsImVtYWlsIjoiaW5mby52ZG90ZWNobm9sb2dpZXNAZ21haWwuY29tIiwiYXV0aF90aW1lIjoiMTAvMTYvMjAyNCAwODo1MzozNSIsInRlbmFudF9pZCI6IjEwMTQxNiIsImRiX25hbWUiOiJtdC1wcm9kLVRlbmFudHMiLCJodHRwOi8vc2NoZW1hcy5taWNyb3NvZnQuY29tL3dzLzIwMDgvMDYvaWRlbnRpdHkvY2xhaW1zL3JvbGUiOiJBRE1JTklTVFJBVE9SIiwiZXhwIjoyNTM0MDIzMDA4MDAsImlzcyI6IkNsYXJlX0FJIiwiYXVkIjoiQ2xhcmVfQUkifQ.xFYRkdcukX7fBCsP1HlknrYN9n6UXVA6SJa4D2UMjMc";
        $watiEndPointUrl = "https://live-mt-server.wati.io/101416";

        $api = new Wati($watiToken, $watiEndPointUrl);

        $response = $api->getContacts();
        $json = $response;
        dd($json);
    });

    Route::get("update-meta-status", function () {
        Artisan::call('pending:message:template');
        return "Done";
    });

    Route::prefix('users')->group(function () {
        Route::get('/', [UserController::class, 'index'])->name('index');
    });

    Route::prefix('message-templates')->name('message.templates.')->group(function () {
        Route::get('/', [MessageTemplateController::class, 'index'])->name('index');
        Route::get('add', [MessageTemplateController::class, 'create'])->name('create');
        Route::post('/', [MessageTemplateController::class, 'save'])->name('store');
        Route::post('retry/{messageTemplate}', [MessageTemplateController::class, 'retry'])->name('retry');
        Route::get('{messageTemplate}', [MessageTemplateController::class, 'show'])->name('show');
        Route::delete('{messageTemplate}', [MessageTemplateController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('bulk-messages')->name('bulk.messages.')->group(function () {
        Route::get('/campaigns', [MessageTemplateController::class, 'messageCampaigns'])->name('campaigns');
        Route::get('/campaigns/{messageCampaign}', [MessageTemplateController::class, 'messageCampaignUsers'])->name('campaign.users');
        Route::get('/send-message', [MessageTemplateController::class, 'bulkMessages'])->name('index');
        Route::post('/send-message', [MessageTemplateController::class, 'sendBulkMessages']);
        Route::get('/get-committees/{association_id}', [MessageTemplateController::class, 'getCommittees'])->name('getCommittees');
        Route::get('/get-events/{association_id}', [MessageTemplateController::class, 'getEvents'])->name('getEvents');
    });

    Route::prefix('messages')->name('messages.')->group(function () {
        Route::get('/', [MessageController::class, 'index'])->name('index');
        Route::get('details', [MessageController::class, 'details'])->name('details');
        Route::post('/', [MessageController::class, 'send'])->name('send');
    });

    Route::prefix('associations')->name('associations.')->group(function () {
        Route::get('/', [AssociationController::class, 'index'])->name('index');
        Route::get('/add', [AssociationController::class, 'create'])->name('create');
        Route::post('/', [AssociationController::class, 'store'])->name('store');
        Route::get('/{association}', [AssociationController::class, 'edit'])->name('edit');
        Route::put('/{association}', [AssociationController::class, 'update'])->name('update');
        Route::delete('/{association}', [AssociationController::class, 'destroy'])->name('destroy');
        Route::patch('/{association}', [AssociationController::class, 'statusChange'])->name('status');
        Route::get('/events/{association}', [AssociationController::class, 'events'])->name('events');
        Route::get('/participants/{event}', [AssociationController::class, 'participants'])->name('participants');
    });

    Route::prefix('posts')->name('posts.')->group(function () {
        Route::get('/', [PostController::class, 'index'])->name('index');
        Route::get('/add', [PostController::class, 'create'])->name('create');
        Route::post('/add', [PostController::class, 'store'])->name('store');
        Route::patch('/{post}', [PostController::class, 'statusChange'])->name('status');
        Route::delete('/{post}', [PostController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('mail-templates')->name('mail.templates.')->group(function () {
        Route::get('/', [MailTemplateController::class, 'index'])->name('index');
        Route::get('/add', [MailTemplateController::class, 'create'])->name('create');
        Route::post('/', [MailTemplateController::class, 'store'])->name('store');
        Route::get('/{mailTemplate}', [MailTemplateController::class, 'edit'])->name('edit');
        Route::put('/{mailTemplate}', [MailTemplateController::class, 'update'])->name('update');
        Route::delete('/{mailTemplate}', [MailTemplateController::class, 'destroy'])->name('destroy');
        Route::patch('/{mailTemplate}', [MailTemplateController::class, 'statusChange'])->name('status');
    });

    Route::prefix('bulk-emails')->name('bulk.emails.')->group(function () {
        Route::get('/', [MailTemplateController::class, 'bulkEmails'])->name('index');
        Route::post('/send-bulk-emails', [MailTemplateController::class, 'sendBulkEmails'])->name('send.bulk.emails');
        Route::get('/send-emails', [MailTemplateController::class, 'sendEmails'])->name('send.emails');
    });

    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('index');
        Route::post('/', [SettingController::class, 'update'])->name('store');
    });
});
