<?php

use App\Http\Controllers\Frontend\EventController;
use App\Http\Controllers\Frontend\EventRegisterController;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Support\Facades\Route;

Route::name('frontend.')->group(function () {

    Route::get('{event:code}/session-schedule', [EventController::class, 'index'])->name('event.index');

    Route::get('{event:code}', [EventRegisterController::class, 'registrationForm'])->name('dynamic.events');
    Route::post('{event:code}', [EventRegisterController::class, 'register'])->name('dynamic.events.register');
    Route::post('/thanks/{orderRef?}', [EventRegisterController::class, 'thanks'])->withoutMiddleware([VerifyCsrfToken::class]);
    Route::get('/thanks/{orderRef?}', [EventRegisterController::class, 'thanks'])->name('thanks');

    Route::get('/get-total-amount/{event}', [EventRegisterController::class, 'getTotalAmount'])->name('get.total.amount');
    Route::get('get-states/{countryId}', [EventRegisterController::class, 'getStates'])->name('get.states');
    Route::get('get-cities/{stateId}', [EventRegisterController::class, 'getCities'])->name('get.cities');
    Route::get('/check-mail-exists/{event}', [EventRegisterController::class, 'checkMailExists'])->name('check.mail.exists');
    Route::get('/check-transaction-exists/{event}', [EventRegisterController::class, 'checkTransactionExists'])->name('check.transaction.exists');
});
