<?php

use App\Enums\AdminLevel;
use App\Http\Controllers\Event\EventCoordinator\EventCoordinatorLoginController;
use App\Http\Controllers\Event\EventCoordinator\EventForm\ConfirmRegistrationController;
use App\Http\Controllers\Event\EventCoordinator\EventForm\PendingRegistrationController;
use Illuminate\Support\Facades\Route;

Route::prefix('{events:code}')->name('event.coordinator.')->group(function () {

    Route::get('/login', [EventCoordinatorLoginController::class, 'eventCoordinatorLogin'])->name('login');
    Route::post('/login', [EventCoordinatorLoginController::class, 'eventCoordinatorLoginStore']);
    Route::post('/logout', [EventCoordinatorLoginController::class, 'logout'])->name('logout');

    Route::middleware(['auth:admin', 'isValidRole:' . AdminLevel::EVENT_COORDINATOR])->group(function () {
        Route::get('/home', [EventCoordinatorLoginController::class, 'home'])->name('home');
    });
});

Route::name('event.coordinator.')->group(function () {

    Route::middleware(['auth:admin', 'isValidRole:' . AdminLevel::EVENT_COORDINATOR])->group(function () {

        Route::prefix('forms')->name('forms.')->group(function () {

            Route::prefix('pending-registrations')->name('pending.registrations.')->group(function () {
                Route::get('/', [PendingRegistrationController::class, 'index'])->name('index');
                Route::post('/{paymentOrder}', [PendingRegistrationController::class, 'confirmationRegistration'])->name('confirmation');
            });

            Route::prefix('confirm-registrations')->name('confirm.registrations.')->group(function () {
                Route::get('/', [ConfirmRegistrationController::class, 'index'])->name('index');
                Route::delete('/{eventRegistration}/registrations', [ConfirmRegistrationController::class, 'destroy'])->name('destroy');
            });

            Route::prefix('registrations')->name('registrations.')->group(function () {
                Route::post('/get-data/{eventRegistration}', [ConfirmRegistrationController::class, 'getData'])->name('get.data');
                Route::get('/get-user-data/{user}', [ConfirmRegistrationController::class, 'getUserData'])->name('get.user.data');
                Route::post('/update-user-data', [ConfirmRegistrationController::class, 'updateUserData'])->name('updateUserData');
                Route::post('/update-field-value', [ConfirmRegistrationController::class, 'updateFieldValue'])->name('updateFieldValue');
            });

        });

    });
});

?>