<?php

use App\Enums\AdminLevel;
use App\Enums\RoleEnum;
use App\Http\Controllers\Association\MemberController;
use App\Http\Controllers\Event\AboutCityController;
use App\Http\Controllers\Event\AboutUsController;
use App\Http\Controllers\Event\AdminEventLoginController;
use App\Http\Controllers\Event\EventActivityController;
use App\Http\Controllers\Event\EventAppHomeButtonController;
use App\Http\Controllers\Event\EventAppSponsorLinkController;
use App\Http\Controllers\Event\EventBankDetailController;
use App\Http\Controllers\Event\EventBannerController;
use App\Http\Controllers\Event\EventDesignationController;
use App\Http\Controllers\Event\EventDayController;
use App\Http\Controllers\Event\EventEposterCategoryController;
use App\Http\Controllers\Event\EventExhibitorCategoryController;
use App\Http\Controllers\Event\EventImportantDateController;
use App\Http\Controllers\Event\EventNotificationController;
use App\Http\Controllers\Event\EventSettingController;
use App\Http\Controllers\Event\SpeakerController;
use App\Http\Controllers\Event\VenueController;
use App\Http\Controllers\Event\EventButtonController;
use App\Http\Controllers\Event\EventCommitteeController;
use App\Http\Controllers\Event\EventConfigController;
use App\Http\Controllers\Event\EventContactUsController;
use App\Http\Controllers\Event\EventContactUsTypeController;
use App\Http\Controllers\Event\EventCoordinatorController;
use App\Http\Controllers\Event\EventDashboardSponsorLinkController;
use App\Http\Controllers\Event\EventDocumentListController;
use App\Http\Controllers\Event\EventEPosterController;
use App\Http\Controllers\Event\EventExhibitorController;
use App\Http\Controllers\Event\EventFacultyController;
use App\Http\Controllers\Event\EventForm\CategoryController;
use App\Http\Controllers\Event\EventForm\ConfirmRegistrationController;
use App\Http\Controllers\Event\EventForm\FormController;
use App\Http\Controllers\Event\EventForm\PendingRegistrationController;
use App\Http\Controllers\Event\EventForm\SlabController;
use App\Http\Controllers\Event\EventForm\UpiDetailController;
use App\Http\Controllers\Event\EventForm\WorkshopController;
use App\Http\Controllers\Event\EventLocationController;
use App\Http\Controllers\Event\EventMemberRoleController;
use App\Http\Controllers\Event\EventHallController;
use App\Http\Controllers\Event\EventImportantLinkController;
use App\Http\Controllers\Event\EventMailTemplateController;
use App\Http\Controllers\Event\EventNoticeController;
use App\Http\Controllers\Event\EventPaymentModeController;
use App\Http\Controllers\Event\EventSessionController;
use App\Http\Controllers\Event\EventSpeakerTypeController;
use App\Http\Controllers\Event\ScrollableImagesController;
use Illuminate\Support\Facades\Route;


Route::prefix('event')->name('event.')->group(function () {

    Route::get('/', [AdminEventLoginController::class, 'eventLogin'])->name('login');
    Route::post('/login', [AdminEventLoginController::class, 'eventLoginStore'])->name('login.attempt');
    Route::post('/logout', [AdminEventLoginController::class, 'logout'])->name('logout');

    Route::middleware(['auth:admin', 'isValidRole:' . AdminLevel::EVENT_MANAGER])->group(function () {
        Route::get('/home', [AdminEventLoginController::class, 'home'])->name('home');

        Route::prefix('about-us')->name('aboutus.')->group(function () {
            Route::get('/', [AboutUsController::class, 'index'])->name('index');
            Route::post('/{eventId}', [AboutUsController::class, 'update'])->name('store');
            Route::delete('media/{media}', [AboutUsController::class, 'mediaDelete'])->name('media.delete');

            Route::prefix('button')->name('button.')->group(function () {
                Route::get('/add', [EventButtonController::class, 'create'])->name('create');
                Route::post('/add/{event}', [EventButtonController::class, 'store'])->name('store');
                Route::get('/{button}', [EventButtonController::class, 'edit'])->name('edit');
                Route::put('/{button}', [EventButtonController::class, 'update'])->name('update');
                Route::delete('/{button}', [EventButtonController::class, 'destroy'])->name('destroy');
            });
        });

        Route::prefix('about-city')->name('aboutCity.')->group(function () {
            Route::get('/', [AboutCityController::class, 'index'])->name('index');
            Route::post('/{eventId}', [AboutCityController::class, 'update'])->name('store');
            Route::delete('media/{media}', [AboutCityController::class, 'mediaDelete'])->name('media.delete');

            Route::prefix('location')->name('location.')->group(function () {
                Route::get('/add', [EventLocationController::class, 'create'])->name('create');
                Route::post('/add/{event}', [EventLocationController::class, 'store'])->name('store');
                Route::get('/{location}', [EventLocationController::class, 'edit'])->name('edit');
                Route::put('/{location}', [EventLocationController::class, 'update'])->name('update');
                Route::delete('/{location}', [EventLocationController::class, 'destroy'])->name('destroy');
                Route::delete('media/{media}', [EventLocationController::class, 'mediaDelete'])->name('media.delete');
            });
        });

        Route::prefix('member-roles')->name('member.roles.')->group(function () {
            Route::get('/', [EventMemberRoleController::class, 'index'])->name('index');
            Route::get('/add', [EventMemberRoleController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventMemberRoleController::class, 'store'])->name('store');
            Route::get('/{memberRole}', [EventMemberRoleController::class, 'edit'])->name('edit');
            Route::put('/{memberRole}', [EventMemberRoleController::class, 'update'])->name('update');
            Route::delete('/{memberRole}', [EventMemberRoleController::class, 'destroy'])->name('destroy');
            Route::patch('/{memberRole}', [EventMemberRoleController::class, 'statusChange'])->name('status');
        });

        Route::prefix('committees')->name('committees.')->group(function () {
            Route::get('/', [EventCommitteeController::class, 'index'])->name('index');
            Route::get('/add', [EventCommitteeController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventCommitteeController::class, 'store'])->name('store');
            Route::get('/{committee}', [EventCommitteeController::class, 'edit'])->name('edit');
            Route::put('/{committee}', [EventCommitteeController::class, 'update'])->name('update');
            Route::delete('/{committee}', [EventCommitteeController::class, 'destroy'])->name('destroy');
            Route::patch('/{committee}', [EventCommitteeController::class, 'statusChange'])->name('status');
            Route::post('/update/{committee}', [EventCommitteeController::class, 'updateCommitteeIndex'])->name('update.index');

            Route::get('/{committee}/view', [EventCommitteeController::class, 'view'])->name('view');
            Route::prefix('members')->name('members.')->group(function () {
                Route::get('/{committee}', [EventCommitteeController::class, 'createMember'])->name('create');
                Route::post('/{committee}', [EventCommitteeController::class, 'addMember'])->name('store');
                Route::delete('/{committeeMember}', [EventCommitteeController::class, 'destroyMember'])->name('destroy');
                Route::post('/update/{committeeMember}', [EventCommitteeController::class, 'updateIndex'])->name('update.index');
                Route::post('/update/role/{committeeMember}', [EventCommitteeController::class, 'updateRole'])->name('update.role');
            });
        });

        Route::prefix('speakers')->name('speakers.')->group(function () {
            Route::get('/', [SpeakerController::class, 'index'])->name('index');
            Route::get('/add', [SpeakerController::class, 'create'])->name('create');
            Route::post('/add/{event}', [SpeakerController::class, 'store'])->name('store');
            Route::get('/{speaker}', [SpeakerController::class, 'edit'])->name('edit');
            Route::put('/{speaker}', [SpeakerController::class, 'update'])->name('update');
            Route::delete('/{speaker}', [SpeakerController::class, 'destroy'])->name('destroy');
            Route::patch('/{speaker}', [SpeakerController::class, 'statusChange'])->name('status');
            Route::patch('/index/{speaker}', [SpeakerController::class, 'updateIndex'])->name('update.index');
            Route::post('/import/{eventId}', [SpeakerController::class, 'import'])->name('import');

            Route::prefix('type')->name('type.')->group(function () {
                Route::get('/lists', [EventSpeakerTypeController::class, 'index'])->name('index');
                Route::post('/add/{event}', [EventSpeakerTypeController::class, 'store'])->name('store');
                Route::put('/{eventSpeakerType}', [EventSpeakerTypeController::class, 'update'])->name('update');
                Route::delete('/{eventSpeakerType}', [EventSpeakerTypeController::class, 'destroy'])->name('destroy');
            });
        });

        Route::prefix('days')->name('days.')->group(function () {
            Route::get('/', [EventDayController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventDayController::class, 'store'])->name('store');
            Route::put('/{eventDay}', [EventDayController::class, 'update'])->name('update');
            Route::delete('/{eventDay}', [EventDayController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('important-dates')->name('important.dates.')->group(function () {
            Route::get('/', [EventImportantDateController::class, 'index'])->name('index');
            Route::get('/add', [EventImportantDateController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventImportantDateController::class, 'store'])->name('store');
            Route::get('/{eventImportantDate}', [EventImportantDateController::class, 'edit'])->name('edit');
            Route::put('/{eventImportantDate}', [EventImportantDateController::class, 'update'])->name('update');
            Route::delete('/{eventImportantDate}', [EventImportantDateController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventImportantDate}', [EventImportantDateController::class, 'statusChange'])->name('status');
        });

        Route::prefix('important-links')->name('important.links.')->group(function () {
            Route::get('/', [EventImportantLinkController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventImportantLinkController::class, 'store'])->name('store');
            Route::put('/{eventImportantLink}', [EventImportantLinkController::class, 'update'])->name('update');
            Route::delete('/{eventImportantLink}', [EventImportantLinkController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventImportantLink}', [EventImportantLinkController::class, 'statusChange'])->name('status');
            Route::patch('/index/{eventImportantLink}', [EventImportantLinkController::class, 'updateIndex'])->name('update.index');
        });

        Route::prefix('document-lists')->name('document.lists.')->group(function () {
            Route::get('/', [EventDocumentListController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventDocumentListController::class, 'store'])->name('store');
            Route::put('/{eventDocumentList}', [EventDocumentListController::class, 'update'])->name('update');
            Route::delete('/{eventDocumentList}', [EventDocumentListController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventDocumentList}', [EventDocumentListController::class, 'statusChange'])->name('status');
            Route::patch('/index/{eventDocumentList}', [EventImportantLinkController::class, 'updateIndex'])->name('update.index');
        });

        Route::prefix('venues')->name('venues.')->group(function () {
            Route::get('/{eventDay}', [VenueController::class, 'index'])->name('index');
            Route::get('/add/{eventDay}', [VenueController::class, 'create'])->name('create');
            Route::post('/add/{eventDay}', [VenueController::class, 'store'])->name('store');
            Route::get('/edit/{eventVenue}', [VenueController::class, 'edit'])->name('edit');
            Route::put('update/{eventVenue}', [VenueController::class, 'update'])->name('update');
            Route::delete('delete/{eventVenue}', [VenueController::class, 'destroy'])->name('destroy');
            Route::patch('/index/{eventVenue}', [VenueController::class, 'updateIndex'])->name('update.index');

            Route::prefix('images')->name('images.')->group(function () {
                Route::get('{eventVenue}', [VenueController::class, 'imagesIndex'])->name('index');
                Route::get('add/{eventVenue}', [VenueController::class, 'imageAdd'])->name('add');
                Route::post('add/{eventVenue}', [VenueController::class, 'imagestore'])->name('store');
            });
        });

        Route::prefix('banners')->name('banners.')->group(function () {
            Route::get('/', [EventBannerController::class, 'imagesIndex'])->name('index');
            Route::get('/add', [EventBannerController::class, 'imageAdd'])->name('add');
            Route::post('/', [EventBannerController::class, 'imagestore'])->name('store');
        });

        Route::prefix('e-poster-category')->name('eposter.category.')->group(function () {
            Route::get('/', [EventEposterCategoryController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventEposterCategoryController::class, 'store'])->name('store');
            Route::put('/{eventEPosterCategory}', [EventEposterCategoryController::class, 'update'])->name('update');
            Route::delete('/{eventEPosterCategory}', [EventEposterCategoryController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventEPosterCategory}', [EventEposterCategoryController::class, 'statusChange'])->name('status');
        });

        Route::prefix('e-poster')->name('eposter.')->group(function () {
            Route::get('/', [EventEPosterController::class, 'index'])->name('index');
            Route::get('/add', [EventEPosterController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventEPosterController::class, 'store'])->name('store');
            Route::get('/{eventEPoster}', [EventEPosterController::class, 'edit'])->name('edit');
            Route::put('/{eventEPoster}', [EventEPosterController::class, 'update'])->name('update');
            Route::delete('/{eventEPoster}', [EventEPosterController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventEPoster}', [EventEPosterController::class, 'statusChange'])->name('status');
            Route::patch('/index/{eventEPoster}', [EventEPosterController::class, 'updateIndex'])->name('update.index');

            //test route
            // Route::get('/insert-data', [EventEPosterController::class, 'SampleData'])->name('SampleData');
        });

        Route::prefix('scrollables')->name('scrollables.')->group(function () {
            Route::patch('change-status/{image}', [ScrollableImagesController::class, 'imagestatusChange'])->name('status');
            Route::patch('/update-index/{image}', [ScrollableImagesController::class, 'imageUpdateIndex'])->name('update.index');
            Route::delete('/{image}', [ScrollableImagesController::class, 'imagedestroy'])->name('destroy');
        });

        Route::prefix('halls')->name('halls.')->group(function () {
            Route::get('/', [EventHallController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventHallController::class, 'store'])->name('store');
            Route::put('/{eventHall}', [EventHallController::class, 'update'])->name('update');
            Route::delete('/{eventHall}', [EventHallController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventHall}', [EventHallController::class, 'statusChange'])->name('status');
        });

        Route::prefix('sessions')->name('sessions.')->group(function () {
            Route::get('/', [EventSessionController::class, 'index'])->name('index');
            Route::get('/add', [EventSessionController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventSessionController::class, 'store'])->name('store');
            Route::get('/{eventSession}', [EventSessionController::class, 'edit'])->name('edit');
            Route::put('/{eventSession}', [EventSessionController::class, 'update'])->name('update');
            Route::delete('/{eventSession}', [EventSessionController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventSession}', [EventSessionController::class, 'statusChange'])->name('status');
            Route::post('/faculty/{event}/{eventSession?}', [EventSessionController::class, 'checkSpeakerUser'])->name('check.speaker.user');
            Route::post('/{event}/{eventSession?}', [EventSessionController::class, 'checkSessionUser'])->name('check.session.user');

        });

        Route::prefix('sub-sessions')->name('sub.sessions.')->group(function () {
            Route::get('/{eventSession}', [EventSessionController::class, 'subSesssionIndex'])->name('index');
            Route::get('/add/{eventSession}', [EventSessionController::class, 'eventSessionCreate'])->name('create');
            Route::post('/add/{eventSession}', [EventSessionController::class, 'subSessionStore'])->name('store');
            Route::get('edit/{eventSession}', [EventSessionController::class, 'subSessionEdit'])->name('edit');
            Route::put('update/{eventSession}', [EventSessionController::class, 'subSessionUpdate'])->name('update');
        });

        Route::prefix('faculty')->name('faculty.')->group(function () {
            Route::get('/', [EventFacultyController::class, 'index'])->name('index');
            Route::get('/add', [EventFacultyController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventFacultyController::class, 'store'])->name('store');
            Route::get('/{faculty}', [EventFacultyController::class, 'edit'])->name('edit');
            Route::put('/{faculty}', [EventFacultyController::class, 'update'])->name('update');
            Route::delete('/{faculty}', [EventFacultyController::class, 'destroy'])->name('destroy');
            Route::patch('/{faculty}', [EventFacultyController::class, 'statusChange'])->name('status');
            Route::post('/import/{eventId}', [EventFacultyController::class, 'import'])->name('import');
        });

        Route::prefix('designations')->name('designations.')->group(function () {
            Route::get('/', [EventDesignationController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventDesignationController::class, 'store'])->name('store');
            Route::put('/{eventDesignation}', [EventDesignationController::class, 'update'])->name('update');
            Route::delete('/{eventDesignation}', [EventDesignationController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('exhibitors')->name('exhibitors.')->group(function () {
            Route::get('/', [EventExhibitorController::class, 'index'])->name('index');
            Route::get('/add', [EventExhibitorController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventExhibitorController::class, 'store'])->name('store');
            Route::get('/{eventExhibitor}', [EventExhibitorController::class, 'edit'])->name('edit');
            Route::put('/{eventExhibitor}', [EventExhibitorController::class, 'update'])->name('update');
            Route::delete('/{eventExhibitor}', [EventExhibitorController::class, 'destroy'])->name('destroy');

            Route::prefix('images')->name('images.')->group(function () {
                Route::get('{eventExhibitor}', [EventExhibitorController::class, 'imagesIndex'])->name('index');
                Route::get('add/{eventExhibitor}', [EventExhibitorController::class, 'imageAdd'])->name('add');
                Route::post('add/{eventExhibitor}', [EventExhibitorController::class, 'imagestore'])->name('store');
            });

            Route::prefix('categories')->name('categories.')->group(function () {
                Route::get('/lists', [EventExhibitorCategoryController::class, 'index'])->name('index');
                Route::post('/add/{event}', [EventExhibitorCategoryController::class, 'store'])->name('store');
                Route::put('/{eventExhibitorCategory}', [EventExhibitorCategoryController::class, 'update'])->name('update');
                Route::delete('/{eventExhibitorCategory}', [EventExhibitorCategoryController::class, 'destroy'])->name('destroy');
            });
        });

        Route::prefix('notices')->name('notices.')->group(function () {
            Route::get('/', [EventNoticeController::class, 'imagesIndex'])->name('index');
            Route::get('/add', [EventNoticeController::class, 'imageAdd'])->name('add');
            Route::post('/', [EventNoticeController::class, 'imagestore'])->name('store');
        });

        Route::prefix('activities')->name('activities.')->group(function () {
            Route::get('/', [EventActivityController::class, 'index'])->name('index');
            Route::get('/add', [EventActivityController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventActivityController::class, 'store'])->name('store');
            Route::get('/{eventActivity}', [EventActivityController::class, 'edit'])->name('edit');
            Route::put('/{eventActivity}', [EventActivityController::class, 'update'])->name('update');
            Route::delete('/{eventActivity}', [EventActivityController::class, 'destroy'])->name('destroy');
            Route::patch('/{eventActivity}', [EventActivityController::class, 'statusChange'])->name('status');
            Route::patch('/index/{eventActivity}', [EventActivityController::class, 'updateIndex'])->name('update.index');
            Route::delete('media/{media}/{eventActivity}', [EventActivityController::class, 'mediaDelete'])->name('media.delete');
        });

        Route::prefix('settings')->name('settings.')->group(function () {
            Route::get('/', [EventSettingController::class, 'index'])->name('index');
            Route::post('/add/{event}', [EventSettingController::class, 'update'])->name('update');
        });

        Route::prefix('contact-us')->name('contact.us.')->group(function () {
            Route::get('/', [EventContactUsController::class, 'index'])->name('index');
            Route::get('/add', [EventContactUsController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventContactUsController::class, 'store'])->name('store');
            Route::get('/{eventContactUs}', [EventContactUsController::class, 'edit'])->name('edit');
            Route::put('/{eventContactUs}', [EventContactUsController::class, 'update'])->name('update');
            Route::delete('/{eventContactUs}', [EventContactUsController::class, 'destroy'])->name('destroy');

            Route::prefix('type')->name('type.')->group(function () {
                Route::get('/lists', [EventContactUsTypeController::class, 'index'])->name('index');
                Route::post('/add/{event}', [EventContactUsTypeController::class, 'store'])->name('store');
                Route::put('/{eventContactUsType}', [EventContactUsTypeController::class, 'update'])->name('update');
                Route::delete('/{eventContactUsType}', [EventContactUsTypeController::class, 'destroy'])->name('destroy');
            });
        });

        Route::prefix('notifications')->name('notifications.')->group(function () {
            Route::get('/', [EventNotificationController::class, 'index'])->name('index');
            Route::get('/add', [EventNotificationController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventNotificationController::class, 'store'])->name('store');
            Route::delete('/{notification}', [EventNotificationController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('app')->name('app.')->group(function () {

            Route::prefix('home-buttons')->name('home.buttons.')->group(function () {
                Route::get('/', [EventAppHomeButtonController::class, 'index'])->name('index');
                Route::get('/add', [EventAppHomeButtonController::class, 'create'])->name('create');
                Route::post('/add/{event}', [EventAppHomeButtonController::class, 'store'])->name('store');
                Route::get('/{homeButton}', [EventAppHomeButtonController::class, 'edit'])->name('edit');
                Route::put('/{homeButton}', [EventAppHomeButtonController::class, 'update'])->name('update');
                Route::delete('/{homeButton}', [EventAppHomeButtonController::class, 'destroy'])->name('destroy');
                Route::patch('/{homeButton}', [EventAppHomeButtonController::class, 'statusChange'])->name('status');
                Route::patch('/index/{homeButton}', [EventAppHomeButtonController::class, 'updateIndex'])->name('update.index');
            });

            Route::prefix('sponsor-links')->name('sponsor.links.')->group(function () {
                Route::get('/', [EventAppSponsorLinkController::class, 'index'])->name('index');
                Route::post('/add/{event}', [EventAppSponsorLinkController::class, 'store'])->name('store');
                Route::put('/{eventSponsorLink}', [EventAppSponsorLinkController::class, 'update'])->name('update');
                Route::delete('/{eventSponsorLink}', [EventAppSponsorLinkController::class, 'destroy'])->name('destroy');
            });

            Route::prefix('dashboard-sponsor-links')->name('dashboard.sponsor.links.')->group(function () {
                Route::get('/', [EventDashboardSponsorLinkController::class, 'index'])->name('index');
                Route::get('/add', [EventDashboardSponsorLinkController::class, 'create'])->name('create');
                Route::post('/add/{event}', [EventDashboardSponsorLinkController::class, 'store'])->name('store');
                Route::get('/{eventDashboardSponsorLink}', [EventDashboardSponsorLinkController::class, 'edit'])->name('edit');
                Route::put('/{eventDashboardSponsorLink}', [EventDashboardSponsorLinkController::class, 'update'])->name('update');
                Route::delete('/{eventDashboardSponsorLink}', [EventDashboardSponsorLinkController::class, 'destroy'])->name('destroy');
                Route::patch('/{eventDashboardSponsorLink}', [EventDashboardSponsorLinkController::class, 'statusChange'])->name('status');
                Route::patch('/index/{eventDashboardSponsorLink}', [EventDashboardSponsorLinkController::class, 'updateIndex'])->name('update.index');
            });
        });

        Route::prefix('forms')->name('forms.')->group(function () {
            Route::prefix('categories')->name('categories.')->group(function () {
                Route::get('/', [CategoryController::class, 'index'])->name('index');
                Route::post('/add/{event}', [CategoryController::class, 'store'])->name('store');
                Route::put('/{eventFormCategory}', [CategoryController::class, 'update'])->name('update');
                Route::delete('/{eventFormCategory}', [CategoryController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('slabs')->name('slabs.')->group(function () {
                Route::get('/', [SlabController::class, 'index'])->name('index');
                Route::get('/add', [SlabController::class, 'create'])->name('create');
                Route::post('/add/{event}', [SlabController::class, 'store'])->name('store');
                Route::get('/{eventFormSlab}', [SlabController::class, 'edit'])->name('edit');
                Route::put('/{eventFormSlab}', [SlabController::class, 'update'])->name('update');
                Route::delete('/{eventFormSlab}', [SlabController::class, 'destroy'])->name('destroy');
                Route::patch('/{eventFormSlab}', [SlabController::class, 'statusChange'])->name('status');
            });

            Route::prefix('workshops')->name('workshops.')->group(function () {
                Route::get('/', [WorkshopController::class, 'index'])->name('index');
                Route::get('/add', [WorkshopController::class, 'create'])->name('create');
                Route::post('/add/{event}', [WorkshopController::class, 'store'])->name('store');
                Route::get('/{eventFormWorkshop}', [WorkshopController::class, 'edit'])->name('edit');
                Route::put('/{eventFormWorkshop}', [WorkshopController::class, 'update'])->name('update');
                Route::delete('/{eventFormWorkshop}', [WorkshopController::class, 'destroy'])->name('destroy');
                Route::patch('/{eventFormWorkshop}', [WorkshopController::class, 'statusChange'])->name('status');
            });

            Route::prefix('fields')->name('fields.')->group(function () {
                Route::get('/add', [FormController::class, 'index'])->name('index');
                Route::put('/add/{event}', [FormController::class, 'store'])->name('store');
                Route::get('/field/{eventFormInputField}', [FormController::class, 'edit'])->name('edit');
                Route::put('/field/{eventFormInputField}', [FormController::class, 'update'])->name('update');
                Route::delete('/field/{eventFormInputField}', [FormController::class, 'destroy'])->name('destroy');
                Route::get('/add-static-field', [FormController::class, 'addStaticField'])->name('addStaticField');
            });
            Route::prefix('upi-details')->name('upi.details.')->group(function () {
                Route::get('/', [UpiDetailController::class, 'index'])->name('index');
                Route::post('/add', [UpiDetailController::class, 'update'])->name('update');
            });
            Route::prefix('pending-registrations')->name('pending.registrations.')->group(function () {
                Route::get('/', [PendingRegistrationController::class, 'index'])->name('index');
                Route::post('/{paymentOrder}', [PendingRegistrationController::class, 'confirmationRegistration'])->name('confirmation');
            });
            Route::prefix('confirm-registrations')->name('confirm.registrations.')->group(function () {
                Route::get('/', [ConfirmRegistrationController::class, 'index'])->name('index');
                Route::delete('/{eventRegistration}/registrations', [ConfirmRegistrationController::class, 'destroy'])->name('destroy');
            });
            Route::prefix('registrations')->name('registrations.')->group(function () {
                Route::post('/get-data/{eventRegistration}', [ConfirmRegistrationController::class, 'getData'])->name('get.data');
                Route::get('/get-user-data/{user}', [ConfirmRegistrationController::class, 'getUserData'])->name('get.user.data');
                Route::post('/update-user-data', [ConfirmRegistrationController::class, 'updateUserData'])->name('updateUserData');
                Route::post('/update-field-value', [ConfirmRegistrationController::class, 'updateFieldValue'])->name('updateFieldValue');

            });
        });

        Route::prefix('config')->name('config.')->group(function () {
            Route::get('/', [EventConfigController::class, 'index'])->name('index');
            Route::post('/add', [EventConfigController::class, 'update'])->name('update');
        });

        Route::prefix('payment-modes')->name('payment.modes.')->group(function () {
            Route::get('/', [EventPaymentModeController::class, 'index'])->name('index');
            Route::post('/add', [EventPaymentModeController::class, 'update'])->name('update');
        });

        Route::prefix('bank-details')->name('bank.details.')->group(function () {
            Route::get('/', [EventBankDetailController::class, 'index'])->name('index');
            Route::post('/add', [EventBankDetailController::class, 'update'])->name('update');
        });

        Route::prefix('mail-templates')->name('mail.templates.')->group(function () {
            Route::get('/', [EventMailTemplateController::class, 'index'])->name('index');
            Route::get('/add', [EventMailTemplateController::class, 'create'])->name('create');
            Route::post('/add/{event}', [EventMailTemplateController::class, 'store'])->name('store');
            Route::get('/{mailTemplate}', [EventMailTemplateController::class, 'edit'])->name('edit');
            Route::put('/{mailTemplate}', [EventMailTemplateController::class, 'update'])->name('update');
            Route::delete('/{mailTemplate}', [EventMailTemplateController::class, 'destroy'])->name('destroy');
            Route::patch('/{mailTemplate}', [EventMailTemplateController::class, 'statusChange'])->name('status');
        });

        Route::prefix('coordinators')->name('coordinators.')->group(function () {
            Route::get('/', [EventCoordinatorController::class, 'index'])->name('index');
            Route::get('/add', [EventCoordinatorController::class, 'create'])->name('create');
            Route::post('/add', [EventCoordinatorController::class, 'store'])->name('store');
            Route::get('/{eventCoordinator}', [EventCoordinatorController::class, 'edit'])->name('edit');
            Route::put('/{eventCoordinator}', [EventCoordinatorController::class, 'update'])->name('update');
            Route::delete('/{eventCoordinator}', [EventCoordinatorController::class, 'destroy'])->name('destroy');
        });

    });

});
Route::get('/search', [MemberController::class, 'search'])->name('members.search');
