<?php

use App\Enums\RoleEnum;
use App\Http\Controllers\API\AssociationDetailController;
use App\Http\Controllers\API\BannerController;
use App\Http\Controllers\API\CalenderController;
use App\Http\Controllers\API\CommitteeController;
use App\Http\Controllers\API\Event\DaysController;
use App\Http\Controllers\API\Event\EventAboutCityController;
use App\Http\Controllers\API\Event\EventAboutUsController;
use App\Http\Controllers\API\Event\EventActivityController;
use App\Http\Controllers\API\Event\EventAppHomeButtonController;
use App\Http\Controllers\API\Event\EventAppSponsorLinkController;
use App\Http\Controllers\API\Event\EventBannerController;
use App\Http\Controllers\API\Event\EventDocumentListController;
use App\Http\Controllers\API\Event\EventImportantDateController;
use App\Http\Controllers\API\Event\EventImportantLinkController;
use App\Http\Controllers\API\Event\EventNoticeController;
use App\Http\Controllers\API\Event\EventCommitteeController;
use App\Http\Controllers\API\Event\EventContactUsController;
use App\Http\Controllers\API\Event\EventDashboardSponsorLinkController;
use App\Http\Controllers\API\Event\EventEPosterController;
use App\Http\Controllers\API\Event\EventExhibitorController;
use App\Http\Controllers\API\Event\EventFormController;
use App\Http\Controllers\API\Event\EventSessionController;
use App\Http\Controllers\API\Event\EventSessionQuestionController;
use App\Http\Controllers\API\Event\EventSettingController;
use App\Http\Controllers\API\Event\EventSlabController;
use App\Http\Controllers\API\Event\EventWorkshopController;
use App\Http\Controllers\API\Event\NotificationController;
use App\Http\Controllers\API\Event\SpeakerController;
use App\Http\Controllers\API\Event\VenueController;
use App\Http\Controllers\API\EventController;
use App\Http\Controllers\API\EventRegistrationController;
use App\Http\Controllers\API\InternationalAffiliationController;
use App\Http\Controllers\API\LoginController;
use App\Http\Controllers\API\MemberController;
use App\Http\Controllers\API\MembershipFormController;
use App\Http\Controllers\API\NoticeController;
use App\Http\Controllers\API\NotificationController as APINotificationController;
use App\Http\Controllers\API\PostCommentController;
use App\Http\Controllers\API\PostController;
use App\Http\Controllers\API\ProfileController;
use App\Http\Controllers\API\SliderController;
use App\Http\Controllers\API\PastOfficeBearerController;
use App\Http\Controllers\API\PollController;
use App\Http\Controllers\WebhookController;
use App\Models\PastOfficeBearer;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

// whatsapp meta webhook Apis response
Route::get('webhook', [WebhookController::class, 'whatsappWebhookUrlGet']);
Route::post('webhook', [WebhookController::class, 'whatsappWebhookUrlPost']);

Route::post('/login', [LoginController::class, 'login']);
Route::post('/verify-otp', [LoginController::class, 'verifyOTP']);
Route::post('/base-login', [LoginController::class, 'baseLogin']);
Route::post('/user-account-delete', [MemberController::class, 'userAccountDelete']);

Route::middleware(['checkAuthCode'])->group(function () {
    Route::middleware(['auth:api'])->group(function () {
        Route::get('/profile', [LoginController::class, 'profile']);
        Route::post('/profile', [LoginController::class, 'updateProfile']);
        Route::post('/logout', [LoginController::class, 'logout']);
        Route::post('/store-fcm-token', [LoginController::class, 'storeAssociationFcmToken']);
        Route::get('/notification-list', [APINotificationController::class, 'index']);
        Route::post('/verify-member-id', [MemberController::class, 'checkMemberId']);
    });
    Route::get('/membership-form', [MembershipFormController::class, 'index']);
    Route::prefix('committees')->group(function () {
        Route::get('/', [CommitteeController::class, 'index']);
        Route::get('/standing', [CommitteeController::class, 'standingMembers']);
        Route::get('/executive', [CommitteeController::class, 'executiveMembers']);

        Route::get('member/{committee}', [CommitteeController::class, 'committeeMembers']);
    });
    Route::prefix('members')->group(function () {
        Route::get('/', [MemberController::class, 'index']);
        Route::get('/upcoming-birthdays', [MemberController::class, 'upcomingBirthday']);
    });
    Route::get('/message', [MemberController::class, 'message']);
    Route::get('/sliders', [SliderController::class, 'index']);
    Route::get('/banners', [BannerController::class, 'index']);
    Route::get('/notices', [NoticeController::class, 'index']);
    Route::get('/settings', [AssociationDetailController::class, 'index']);
    Route::get('/events', [EventController::class, 'index']);
    Route::get('/calenders', [CalenderController::class, 'index']);
    Route::get('/past-office-bearers', [PastOfficeBearerController::class, 'index']);
    Route::get('/international-affiliations', [InternationalAffiliationController::class, 'index']);

    Route::prefix('polls')->group(function () {
        Route::get('/', [PollController::class, 'index']);
        Route::middleware(['auth:api'])->group(function () {
            Route::post('{pollOption}/vote', [PollController::class, 'addVote']);
        });
    });


    Route::prefix('posts')->group(function () {
        Route::get('/', [PostController::class, 'index']);
        Route::middleware(['auth:api'])->group(function () {
            Route::post('/', [PostController::class, 'store']);
            Route::delete('{post}', [PostController::class, 'delete']);
            Route::post('/{post}', [PostController::class, 'update']);
            Route::delete('{post}', [PostController::class, 'delete']);
            Route::get('{post}/likes', [PostController::class, 'getLikes']);
            Route::post('{post}/like', [PostController::class, 'like']);
            Route::post('{post}/save', [PostController::class, 'save']);

            Route::post('{post}/bookmark', [PostController::class, 'bookmark']);
            Route::get('/my-bookmarked', [PostController::class, 'userBookmarkedPost']);

            Route::prefix('{post}/comments')->group(function () {
                Route::get('/', [PostCommentController::class, 'index']);
                Route::post('/', [PostCommentController::class, 'store']);
            });

            Route::post('/comments/{comment}', [PostCommentController::class, 'update']);
            Route::delete('/comments/{comment}', [PostCommentController::class, 'delete']);
        });
    });
});

Route::middleware(['checkEvent'])->group(function () {
    Route::prefix('events')->group(function () {
        Route::get('/speakers', [SpeakerController::class, 'index']);
        Route::get('/speakers/{eventSpeaker}', [SpeakerController::class, 'details']);
        Route::get('/speaker-type', [SpeakerController::class, 'type']);
        Route::get('/days', [DaysController::class, 'index']);
        Route::get('/important-dates', [EventImportantDateController::class, 'index']);
        Route::get('/important-links', [EventImportantLinkController::class, 'index']);
        Route::get('/document-list', [EventDocumentListController::class, 'index']);
        Route::get('/venues', [VenueController::class, 'list']);
        Route::get('/venues/{eventDay}', [VenueController::class, 'index']);
        Route::get('/about-us', [EventAboutUsController::class, 'index']);
        Route::get('/about-city', [EventAboutCityController::class, 'index']);
        Route::get('/banners', [EventBannerController::class, 'index']);
        Route::get('/notices', [EventNoticeController::class, 'index']);
        Route::get('/activities', [EventActivityController::class, 'index']);
        Route::get('/e-posters', [EventEPosterController::class, 'index']);
        Route::get('/settings', [EventSettingController::class, 'index']);
        Route::get('/contact-us', [EventContactUsController::class, 'index']);
        Route::get('/notification-list', [NotificationController::class, 'index']);

        Route::prefix('app')->group(function () {
            Route::get('/home-buttons', [EventAppHomeButtonController::class, 'index']);
            Route::get('/youtube-links', [EventAppHomeButtonController::class, 'youtubeLink']);
            Route::get('/sponsor-links', [EventAppSponsorLinkController::class, 'index']);
            Route::get('/dashboard-sponsor-links', [EventDashboardSponsorLinkController::class, 'index']);
        });

        Route::prefix('exhibitors')->group(function () {
            Route::get('/', [EventExhibitorController::class, 'index']);
            Route::get('/{eventExhibitor}', [EventExhibitorController::class, 'details']);
            Route::get('get/categories', [EventExhibitorController::class, 'categories']);
        });

        Route::prefix('committees')->group(function () {
            Route::get('/', [EventCommitteeController::class, 'index']);
            Route::get('members/{committee}', [EventCommitteeController::class, 'committeeMembers']);
        });

        Route::prefix('sessions')->group(function () {
            Route::get('/', [EventSessionController::class, 'index']);
            Route::get('/dashboard', [EventSessionController::class, 'eventSessionDashboard']);
            Route::middleware(['auth:api'])->group(function () {
                Route::post('{eventSession}/questions', [EventSessionQuestionController::class, 'store']);
                Route::post('{eventSession}/bookmark', [EventSessionController::class, 'bookmark']);
                Route::get('/my-bookmark', [EventSessionController::class, 'userBookmarkedSession']);
            });
            Route::get('user-detail', [EventSessionController::class, 'getUserSessionDetail']);
            Route::get('speaker-detail', [EventSessionController::class, 'getSpeakerSessionDetail']);
        });
        Route::post('/store-fcm-token', [LoginController::class, 'storeEventFcmToken']);
        Route::get('/event-form', [EventFormController::class, 'index']);
    });
});


Route::prefix('events')->group(function () {
    Route::post('/register', [EventRegistrationController::class, 'register']);
    Route::get('/workshop/{event:code}', [EventWorkshopController::class, 'index']);
    Route::get('/slab/{event:code}', [EventSlabController::class, 'index']);
});

Route::get('/member-profile', [ProfileController::class, 'getMemberProfile']);
