<div class="sidebar-inner">

    <a href="{{ route('event.coordinator.home', ['events' => Session::get('event_code')]) }}" class="sidenav-logo">
        <img class="img-fluid" src="{{ asset('assets/images/logo.png') }}">
    </a>

    <!-- Sidebar menu -->
    <ul class="sidenav-menu">
        <li class="menu-item">
            <a href="{{ route('event.coordinator.home', ['events' => Session::get('event_code')]) }}"
                class="menu-link @if (Route::currentRouteName() == 'home') active @endif" title="Home">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M17.85 6.77777C17.85 6.2087 17.8507 5.799 17.8782 5.47883C17.9062 5.15184 17.9555 5.03188 17.9789 4.99287C17.9849 4.9828 17.9873 4.98107 17.9905 4.97876L17.991 4.97841C17.9974 4.97365 18.0249 4.95519 18.0944 4.93372C18.2503 4.88561 18.5213 4.84999 19 4.84999C19.4788 4.84999 19.7497 4.88561 19.9056 4.93372C19.9752 4.95519 20.0026 4.97365 20.0091 4.97841L20.0096 4.97876C20.0127 4.98107 20.0151 4.9828 20.0212 4.99287C20.0446 5.03188 20.0939 5.15184 20.1219 5.47883C20.1493 5.799 20.15 6.2087 20.15 6.77777V6.79084V6.80399V6.81722V6.83054V6.84395V6.85744V6.87102V6.88468V6.89842V6.91225V6.92616V6.94015V6.95422V6.96838V6.98262V6.99694V7.01134V7.02583V7.04039V7.05503V7.06975V7.08455V7.09944V7.1144V7.12943V7.14455V7.15974V7.17501V7.19036V7.20579V7.22129V7.23686V7.25252V7.26824V7.28405V7.29992V7.31588V7.3319V7.348V7.36417V7.38042V7.39674V7.41313V7.42959V7.44613V7.46273V7.47941V7.49615V7.51297V7.52986V7.54682V7.56384V7.58094V7.5981V7.61533V7.63263V7.65V7.66743V7.68493V7.7025V7.72014V7.73783V7.7556V7.77343V7.79133V7.80929V7.82731V7.8454V7.86355V7.88176V7.90004V7.91838V7.93678V7.95525V7.97377V7.99236V8.01101V8.02971V8.04848V8.06731V8.0862V8.10514V8.12415V8.14321V8.16233V8.18151V8.20075V8.22004V8.23939V8.2588V8.27826V8.29778V8.31735V8.33698V8.35667V8.3764V8.3962V8.41604V8.43594V8.45589V8.4759V8.49596V8.51607V8.53623V8.55644V8.5767V8.59702V8.61738V8.63779V8.65826V8.67877V8.69933V8.71994V8.7406V8.76131V8.78207V8.80287V8.82372V8.84461V8.86555V8.88654V8.90758V8.92865V8.94978V8.97095V8.99216V9.01342V9.03472V9.05606V9.07744V9.09887V9.12034V9.14186V9.16341V9.18501V9.20664V9.22832V9.25004V9.27179V9.29359V9.31543V9.3373V9.35921V9.38116V9.40315V9.42518V9.44724V9.46934V9.49148V9.51365V9.53586V9.55811V9.58039V9.6027V9.62505V9.64743V9.66985V9.6923V9.71478V9.7373V9.75985V9.78243V9.80504V9.82768V9.85036V9.87306V9.8958V9.91856V9.94136V9.96418V9.98704V10.0099V10.0328V10.0558V10.0787V10.1017V10.1248V10.1478V10.1709V10.194V10.2171V10.2403V10.2634V10.2866V10.3099V10.3331V10.3564V10.3797V10.403V10.4263V10.4497V10.4731V10.4965V10.5199V10.5434V10.5668V10.5903V10.6138V10.6374V10.6609V10.6845V10.7081V10.7317V10.7553V10.7789V10.8026V10.8263V10.85V10.8737V10.8974V10.9211V10.9449V10.9687V10.9924V11.0162V11.0401V11.0639V11.0877V11.1116V11.1354V11.1593V11.1832V11.2071V11.231V11.2549V11.2789V11.3028V11.3267V11.3507V11.3747V11.3987V11.4226V11.4466V11.4706V11.4947V11.5187V11.5427V11.5667V11.5908V11.6148V11.6389V11.6629V11.687V11.711V11.7351V11.7592V11.7832V11.8073V11.8314V11.8555V11.8796V11.9036V11.9277V11.9518V11.9759V12V12.0241V12.0482V12.0723V12.0963V12.1204V12.1445V12.1686V12.1927V12.2167V12.2408V12.2649V12.289V12.313V12.3371V12.3611V12.3852V12.4092V12.4333V12.4573V12.4813V12.5053V12.5293V12.5533V12.5773V12.6013V12.6253V12.6493V12.6732V12.6972V12.7211V12.7451V12.769V12.7929V12.8168V12.8407V12.8646V12.8884V12.9123V12.9361V12.9599V12.9837V13.0075V13.0313V13.0551V13.0788V13.1026V13.1263V13.15V13.1737V13.1974V13.221V13.2447V13.2683V13.2919V13.3155V13.3391V13.3626V13.3861V13.4097V13.4331V13.4566V13.4801V13.5035V13.5269V13.5503V13.5737V13.597V13.6203V13.6436V13.6669V13.6901V13.7134V13.7366V13.7597V13.7829V13.806V13.8291V13.8522V13.8752V13.8983V13.9212V13.9442V13.9672V13.9901V14.0129V14.0358V14.0586V14.0814V14.1042V14.1269V14.1496V14.1723V14.1949V14.2176V14.2401V14.2627V14.2852V14.3077V14.3301V14.3526V14.3749V14.3973V14.4196V14.4419V14.4641V14.4863V14.5085V14.5306V14.5527V14.5748V14.5968V14.6188V14.6408V14.6627V14.6846V14.7064V14.7282V14.7499V14.7717V14.7933V14.815V14.8366V14.8581V14.8796V14.9011V14.9225V14.9439V14.9653V14.9866V15.0078V15.029V15.0502V15.0713V15.0924V15.1134V15.1344V15.1554V15.1763V15.1971V15.2179V15.2387V15.2594V15.28V15.3007V15.3212V15.3417V15.3622V15.3826V15.403V15.4233V15.4435V15.4638V15.4839V15.504V15.5241V15.5441V15.564V15.5839V15.6038V15.6236V15.6433V15.663V15.6826V15.7022V15.7217V15.7412V15.7606V15.7799V15.7992V15.8185V15.8377V15.8568V15.8758V15.8948V15.9138V15.9327V15.9515V15.9703V15.989V16.0076V16.0262V16.0447V16.0632V16.0816V16.0999V16.1182V16.1364V16.1546V16.1727V16.1907V16.2087V16.2266V16.2444V16.2621V16.2799V16.2975V16.3151V16.3326V16.35V16.3674V16.3847V16.4019V16.419V16.4361V16.4532V16.4701V16.487V16.5038V16.5206V16.5373V16.5539V16.5704V16.5869V16.6032V16.6196V16.6358V16.652V16.6681V16.6841V16.7001V16.7159V16.7317V16.7475V16.7631V16.7787V16.7942V16.8096V16.825V16.8402V16.8554V16.8706V16.8856V16.9005V16.9154V16.9302V16.945V16.9596V16.9742V16.9886V17.003V17.0174V17.0316V17.0458V17.0598V17.0738V17.0877V17.1016V17.1153V17.129V17.1425V17.156V17.1694V17.1828V17.196V17.2092V17.2222C20.15 17.8944 20.1119 18.3497 20.049 18.6586C19.9858 18.9689 19.9123 19.0565 19.8998 19.0698C19.8953 19.0746 19.8912 19.0784 19.8782 19.0845C19.8612 19.0925 19.8241 19.1064 19.7516 19.1189C19.5859 19.1474 19.3687 19.15 19 19.15C18.6256 19.15 18.4056 19.1474 18.2388 19.1188C18.1657 19.1063 18.129 19.0924 18.113 19.0848C18.1009 19.0791 18.098 19.0761 18.0946 19.0724C18.0836 19.0606 18.0109 18.9742 17.9487 18.6621C17.8869 18.352 17.85 17.8956 17.85 17.2222V6.77777ZM19 3.14999C18.0337 3.14999 17.0408 3.25214 16.5212 4.11823C16.2946 4.49588 16.2189 4.93148 16.1844 5.33366C16.15 5.73476 16.15 6.21671 16.15 6.74641V6.74642V6.77777V17.2222C16.15 17.9377 16.1876 18.523 16.2815 18.9942C16.3749 19.4633 16.539 19.8977 16.8525 20.2332C17.1818 20.5855 17.5835 20.7313 17.9517 20.7944C18.2776 20.8502 18.6414 20.8501 18.9597 20.85L19 20.85L19.0397 20.85C19.3532 20.8501 19.7146 20.8502 20.0398 20.7943C20.4069 20.7311 20.8073 20.5856 21.137 20.2357C21.4517 19.9018 21.619 19.4686 21.7148 18.9977C21.811 18.5253 21.85 17.939 21.85 17.2222V17.2092V17.196V17.1828V17.1694V17.156V17.1425V17.129V17.1153V17.1016V17.0877V17.0738V17.0598V17.0458V17.0316V17.0174V17.003V16.9886V16.9742V16.9596V16.945V16.9302V16.9154V16.9005V16.8856V16.8706V16.8554V16.8402V16.825V16.8096V16.7942V16.7787V16.7631V16.7475V16.7317V16.7159V16.7001V16.6841V16.6681V16.652V16.6358V16.6196V16.6032V16.5869V16.5704V16.5539V16.5373V16.5206V16.5038V16.487V16.4701V16.4532V16.4361V16.419V16.4019V16.3847V16.3674V16.35V16.3326V16.3151V16.2975V16.2799V16.2621V16.2444V16.2266V16.2087V16.1907V16.1727V16.1546V16.1364V16.1182V16.0999V16.0816V16.0632V16.0447V16.0262V16.0076V15.989V15.9703V15.9515V15.9327V15.9138V15.8948V15.8758V15.8568V15.8377V15.8185V15.7992V15.7799V15.7606V15.7412V15.7217V15.7022V15.6826V15.663V15.6433V15.6236V15.6038V15.5839V15.564V15.5441V15.5241V15.504V15.4839V15.4638V15.4435V15.4233V15.403V15.3826V15.3622V15.3417V15.3212V15.3007V15.28V15.2594V15.2387V15.2179V15.1971V15.1763V15.1554V15.1344V15.1134V15.0924V15.0713V15.0502V15.029V15.0078V14.9866V14.9653V14.9439V14.9225V14.9011V14.8796V14.8581V14.8366V14.815V14.7933V14.7717V14.7499V14.7282V14.7064V14.6846V14.6627V14.6408V14.6188V14.5968V14.5748V14.5527V14.5306V14.5085V14.4863V14.4641V14.4419V14.4196V14.3973V14.3749V14.3526V14.3301V14.3077V14.2852V14.2627V14.2401V14.2176V14.1949V14.1723V14.1496V14.1269V14.1042V14.0814V14.0586V14.0358V14.0129V13.9901V13.9672V13.9442V13.9212V13.8983V13.8752V13.8522V13.8291V13.806V13.7829V13.7597V13.7366V13.7134V13.6901V13.6669V13.6436V13.6203V13.597V13.5737V13.5503V13.5269V13.5035V13.4801V13.4566V13.4331V13.4097V13.3861V13.3626V13.3391V13.3155V13.2919V13.2683V13.2447V13.221V13.1974V13.1737V13.15V13.1263V13.1026V13.0788V13.0551V13.0313V13.0075V12.9837V12.9599V12.9361V12.9123V12.8884V12.8646V12.8407V12.8168V12.7929V12.769V12.7451V12.7211V12.6972V12.6732V12.6493V12.6253V12.6013V12.5773V12.5533V12.5293V12.5053V12.4813V12.4573V12.4333V12.4092V12.3852V12.3611V12.3371V12.313V12.289V12.2649V12.2408V12.2167V12.1927V12.1686V12.1445V12.1204V12.0963V12.0723V12.0482V12.0241V12V11.9759V11.9518V11.9277V11.9036V11.8796V11.8555V11.8314V11.8073V11.7832V11.7592V11.7351V11.711V11.687V11.6629V11.6389V11.6148V11.5908V11.5667V11.5427V11.5187V11.4947V11.4706V11.4466V11.4226V11.3987V11.3747V11.3507V11.3267V11.3028V11.2789V11.2549V11.231V11.2071V11.1832V11.1593V11.1354V11.1116V11.0877V11.0639V11.0401V11.0162V10.9924V10.9687V10.9449V10.9211V10.8974V10.8737V10.85V10.8263V10.8026V10.7789V10.7553V10.7317V10.7081V10.6845V10.6609V10.6374V10.6138V10.5903V10.5668V10.5434V10.5199V10.4965V10.4731V10.4497V10.4263V10.403V10.3797V10.3564V10.3331V10.3099V10.2866V10.2634V10.2403V10.2171V10.194V10.1709V10.1478V10.1248V10.1017V10.0787V10.0558V10.0328V10.0099V9.98704V9.96418V9.94136V9.91856V9.8958V9.87306V9.85036V9.82768V9.80504V9.78243V9.75985V9.7373V9.71478V9.6923V9.66985V9.64743V9.62505V9.6027V9.58039V9.55811V9.53586V9.51365V9.49148V9.46934V9.44724V9.42518V9.40315V9.38116V9.35921V9.3373V9.31543V9.29359V9.27179V9.25004V9.22832V9.20664V9.18501V9.16341V9.14186V9.12034V9.09887V9.07744V9.05606V9.03472V9.01342V8.99216V8.97095V8.94978V8.92865V8.90758V8.88654V8.86555V8.84461V8.82372V8.80287V8.78207V8.76131V8.7406V8.71994V8.69933V8.67877V8.65826V8.63779V8.61738V8.59702V8.5767V8.55644V8.53623V8.51607V8.49596V8.4759V8.45589V8.43594V8.41604V8.3962V8.3764V8.35667V8.33698V8.31735V8.29778V8.27826V8.2588V8.23939V8.22004V8.20075V8.18151V8.16233V8.14321V8.12415V8.10514V8.0862V8.06731V8.04848V8.02971V8.01101V7.99236V7.97377V7.95525V7.93678V7.91838V7.90004V7.88176V7.86355V7.8454V7.82731V7.80929V7.79133V7.77343V7.7556V7.73783V7.72014V7.7025V7.68493V7.66743V7.65V7.63263V7.61533V7.5981V7.58094V7.56384V7.54682V7.52986V7.51297V7.49615V7.47941V7.46273V7.44613V7.42959V7.41313V7.39674V7.38042V7.36417V7.348V7.3319V7.31588V7.29992V7.28405V7.26824V7.25252V7.23686V7.22129V7.20579V7.19036V7.17501V7.15974V7.14455V7.12943V7.1144V7.09944V7.08455V7.06975V7.05503V7.04039V7.02583V7.01134V6.99694V6.98262V6.96838V6.95422V6.94015V6.92616V6.91225V6.89842V6.88468V6.87102V6.85744V6.84395V6.83054V6.81722V6.80399V6.79084V6.77777L21.85 6.7464C21.85 6.21671 21.8501 5.73475 21.8157 5.33366C21.7812 4.93148 21.7055 4.49588 21.4789 4.11823C20.9592 3.25214 19.9663 3.14999 19 3.14999ZM10.879 9.49996C10.854 9.72539 10.853 9.98789 10.853 10.3333L10.853 14L10.853 17.6667C10.853 17.6748 10.8529 17.683 10.8527 17.6912C10.8279 18.5507 10.9843 18.8412 11.0773 18.9408C11.1577 19.0269 11.3596 19.15 11.9997 19.15C12.6255 19.15 12.8337 19.0284 12.9193 18.9376C13.0145 18.8368 13.1743 18.5457 13.1469 17.6939C13.1466 17.6848 13.1465 17.6757 13.1465 17.6667V14L13.1465 10.3333C13.1465 9.98789 13.1455 9.72539 13.1205 9.49996C13.0958 9.27778 13.054 9.1641 13.0177 9.10346L13.0165 9.1014C12.9931 9.06167 12.8682 8.84999 11.9997 8.84999C11.1313 8.84999 11.0064 9.06167 10.983 9.1014L10.9818 9.10346C10.9454 9.1641 10.9037 9.27778 10.879 9.49996ZM9.52341 8.22987C10.0024 7.43027 10.8878 7.14999 11.9997 7.14999C13.1117 7.14999 13.9971 7.43027 14.4761 8.22987C14.6894 8.58589 14.7724 8.97221 14.8101 9.31253C14.8465 9.64098 14.8465 9.99359 14.8465 10.3086L14.8465 10.3333L14.8465 14V17.6534C14.8761 18.6293 14.7263 19.4995 14.156 20.104C13.5736 20.7216 12.754 20.85 11.9997 20.85C11.2382 20.85 10.4154 20.7231 9.83455 20.1008C9.26881 19.4947 9.12652 18.6235 9.15301 17.6547L9.15301 14L9.153 10.3333L9.153 10.3086C9.15298 9.99358 9.15295 9.64098 9.18938 9.31253C9.22713 8.97221 9.31014 8.58589 9.52341 8.22987ZM3.87711 14.5196C3.85089 14.7834 3.85003 15.1018 3.85003 15.5278V18.2943C3.85003 18.7748 3.9662 18.9063 4.02252 18.9539C4.11412 19.0314 4.36207 19.15 5.00003 19.15C5.62373 19.15 5.87547 19.0327 5.97207 18.9517C6.03288 18.9007 6.15003 18.7665 6.15003 18.2943V18.2872V18.2801V18.273V18.2659V18.2589V18.2518V18.2448V18.2378V18.2308V18.2238V18.2168V18.2099V18.2029V18.196V18.1891V18.1822V18.1753V18.1684V18.1616V18.1547V18.1479V18.1411V18.1343V18.1275V18.1207V18.1139V18.1072V18.1004V18.0937V18.087V18.0803V18.0736V18.0669V18.0603V18.0536V18.047V18.0404V18.0338V18.0272V18.0206V18.014V18.0075V18.0009V17.9944V17.9879V17.9814V17.9749V17.9684V17.9619V17.9555V17.949V17.9426V17.9362V17.9298V17.9234V17.917V17.9106V17.9043V17.8979V17.8916V17.8853V17.879V17.8727V17.8664V17.8601V17.8538V17.8476V17.8413V17.8351V17.8289V17.8227V17.8165V17.8103V17.8041V17.7979V17.7918V17.7857V17.7795V17.7734V17.7673V17.7612V17.7551V17.749V17.743V17.7369V17.7309V17.7248V17.7188V17.7128V17.7068V17.7008V17.6948V17.6889V17.6829V17.6769V17.671V17.6651V17.6592V17.6532V17.6473V17.6415V17.6356V17.6297V17.6238V17.618V17.6122V17.6063V17.6005V17.5947V17.5889V17.5831V17.5773V17.5715V17.5658V17.56V17.5543V17.5485V17.5428V17.5371V17.5314V17.5257V17.52V17.5143V17.5086V17.503V17.4973V17.4917V17.486V17.4804V17.4748V17.4692V17.4636V17.458V17.4524V17.4468V17.4412V17.4357V17.4301V17.4246V17.419V17.4135V17.408V17.4025V17.397V17.3915V17.386V17.3805V17.375V17.3696V17.3641V17.3587V17.3532V17.3478V17.3424V17.3369V17.3315V17.3261V17.3207V17.3153V17.3099V17.3046V17.2992V17.2938V17.2885V17.2831V17.2778V17.2725V17.2671V17.2618V17.2565V17.2512V17.2459V17.2406V17.2353V17.23V17.2248V17.2195V17.2142V17.209V17.2037V17.1985V17.1933V17.188V17.1828V17.1776V17.1724V17.1672V17.162V17.1568V17.1516V17.1464V17.1412V17.1361V17.1309V17.1257V17.1206V17.1154V17.1103V17.1052V17.1V17.0949V17.0898V17.0847V17.0796V17.0744V17.0693V17.0643V17.0592V17.0541V17.049V17.0439V17.0389V17.0338V17.0287V17.0237V17.0186V17.0136V17.0085V17.0035V16.9985V16.9934V16.9884V16.9834V16.9784V16.9734V16.9684V16.9634V16.9584V16.9534V16.9484V16.9434V16.9384V16.9334V16.9284V16.9235V16.9185V16.9135V16.9086V16.9036V16.8987V16.8937V16.8888V16.8838V16.8789V16.874V16.869V16.8641V16.8592V16.8543V16.8493V16.8444V16.8395V16.8346V16.8297V16.8248V16.8199V16.815V16.8101V16.8052V16.8003V16.7954V16.7905V16.7856V16.7808V16.7759V16.771V16.7661V16.7613V16.7564V16.7515V16.7467V16.7418V16.7369V16.7321V16.7272V16.7224V16.7175V16.7127V16.7078V16.703V16.6981V16.6933V16.6884V16.6836V16.6787V16.6739V16.6691V16.6642V16.6594V16.6546V16.6497V16.6449V16.6401V16.6352V16.6304V16.6256V16.6208V16.6159V16.6111V16.6063V16.6015V16.5966V16.5918V16.587V16.5822V16.5774V16.5725V16.5677V16.5629V16.5581V16.5533V16.5485V16.5436V16.5388V16.534V16.5292V16.5244V16.5196V16.5147V16.5099V16.5051V16.5003V16.4955V16.4907V16.4858V16.481V16.4762V16.4714V16.4666V16.4617V16.4569V16.4521V16.4473V16.4425V16.4376V16.4328V16.428V16.4231V16.4183V16.4135V16.4087V16.4038V16.399V16.3942V16.3893V16.3845V16.3797V16.3748V16.37V16.3651V16.3603V16.3554V16.3506V16.3458V16.3409V16.3361V16.3312V16.3263V16.3215V16.3166V16.3118V16.3069V16.302V16.2972V16.2923V16.2874V16.2826V16.2777V16.2728V16.2679V16.263V16.2581V16.2533V16.2484V16.2435V16.2386V16.2337V16.2288V16.2239V16.219V16.214V16.2091V16.2042V16.1993V16.1944V16.1894V16.1845V16.1796V16.1746V16.1697V16.1648V16.1598V16.1549V16.1499V16.145V16.14V16.135V16.1301V16.1251V16.1201V16.1151V16.1102V16.1052V16.1002V16.0952V16.0902V16.0852V16.0802V16.0752V16.0701V16.0651V16.0601V16.0551V16.05V16.045V16.04V16.0349V16.0299V16.0248V16.0197V16.0147V16.0096V16.0045V15.9995V15.9944V15.9893V15.9842V15.9791V15.974V15.9689V15.9637V15.9586V15.9535V15.9484V15.9432V15.9381V15.9329V15.9278V15.9226V15.9175V15.9123V15.9071V15.9019V15.8967V15.8916V15.8864V15.8811V15.8759V15.8707V15.8655V15.8603V15.855V15.8498V15.8445V15.8393V15.834V15.8287V15.8235V15.8182V15.8129V15.8076V15.8023V15.797V15.7917V15.7864V15.781V15.7757V15.7704V15.765V15.7597V15.7543V15.7489V15.7436V15.7382V15.7328V15.7274V15.722V15.7166V15.7111V15.7057V15.7003V15.6948V15.6894V15.6839V15.6785V15.673V15.6675V15.662V15.6565V15.651V15.6455V15.64V15.6344V15.6289V15.6234V15.6178V15.6122V15.6067V15.6011V15.5955V15.5899V15.5843V15.5787V15.5731V15.5674V15.5618V15.5561V15.5505V15.5448V15.5429L6.14311 15.3406V15.3406C6.13205 15.0114 6.12341 14.754 6.09885 14.5269C6.06936 14.2543 6.02495 14.1272 5.98961 14.0653L5.98894 14.0638C5.97993 14.0437 5.89336 13.85 5.00003 13.85C4.10278 13.85 3.9983 14.0458 3.98392 14.0728L3.98282 14.0748C3.94834 14.1335 3.90328 14.2563 3.87711 14.5196ZM2.51722 13.2134C3.00748 12.3793 3.92522 12.15 5.00003 12.15C6.07679 12.15 6.98578 12.3806 7.46626 13.2229C7.67355 13.5863 7.75045 13.9879 7.78899 14.3441C7.82101 14.6402 7.83207 14.9752 7.84295 15.3046C7.84508 15.3692 7.84721 15.4336 7.84949 15.4975L7.84978 15.5072L7.85003 15.5278V15.5335V15.5391V15.5448V15.5505V15.5561V15.5618V15.5674V15.5731V15.5787V15.5843V15.5899V15.5955V15.6011V15.6067V15.6122V15.6178V15.6234V15.6289V15.6344V15.64V15.6455V15.651V15.6565V15.662V15.6675V15.673V15.6785V15.6839V15.6894V15.6948V15.7003V15.7057V15.7111V15.7166V15.722V15.7274V15.7328V15.7382V15.7436V15.7489V15.7543V15.7597V15.765V15.7704V15.7757V15.781V15.7864V15.7917V15.797V15.8023V15.8076V15.8129V15.8182V15.8235V15.8287V15.834V15.8393V15.8445V15.8498V15.855V15.8603V15.8655V15.8707V15.8759V15.8811V15.8864V15.8916V15.8967V15.9019V15.9071V15.9123V15.9175V15.9226V15.9278V15.9329V15.9381V15.9432V15.9484V15.9535V15.9586V15.9637V15.9689V15.974V15.9791V15.9842V15.9893V15.9944V15.9995V16.0045V16.0096V16.0147V16.0197V16.0248V16.0299V16.0349V16.04V16.045V16.05V16.0551V16.0601V16.0651V16.0701V16.0752V16.0802V16.0852V16.0902V16.0952V16.1002V16.1052V16.1102V16.1151V16.1201V16.1251V16.1301V16.135V16.14V16.145V16.1499V16.1549V16.1598V16.1648V16.1697V16.1746V16.1796V16.1845V16.1894V16.1944V16.1993V16.2042V16.2091V16.214V16.219V16.2239V16.2288V16.2337V16.2386V16.2435V16.2484V16.2533V16.2581V16.263V16.2679V16.2728V16.2777V16.2826V16.2874V16.2923V16.2972V16.302V16.3069V16.3118V16.3166V16.3215V16.3263V16.3312V16.3361V16.3409V16.3458V16.3506V16.3554V16.3603V16.3651V16.37V16.3748V16.3797V16.3845V16.3893V16.3942V16.399V16.4038V16.4087V16.4135V16.4183V16.4231V16.428V16.4328V16.4376V16.4425V16.4473V16.4521V16.4569V16.4617V16.4666V16.4714V16.4762V16.481V16.4858V16.4907V16.4955V16.5003V16.5051V16.5099V16.5147V16.5196V16.5244V16.5292V16.534V16.5388V16.5436V16.5485V16.5533V16.5581V16.5629V16.5677V16.5725V16.5774V16.5822V16.587V16.5918V16.5966V16.6015V16.6063V16.6111V16.6159V16.6208V16.6256V16.6304V16.6352V16.6401V16.6449V16.6497V16.6546V16.6594V16.6642V16.6691V16.6739V16.6787V16.6836V16.6884V16.6933V16.6981V16.703V16.7078V16.7127V16.7175V16.7224V16.7272V16.7321V16.7369V16.7418V16.7467V16.7515V16.7564V16.7613V16.7661V16.771V16.7759V16.7808V16.7856V16.7905V16.7954V16.8003V16.8052V16.8101V16.815V16.8199V16.8248V16.8297V16.8346V16.8395V16.8444V16.8493V16.8543V16.8592V16.8641V16.869V16.874V16.8789V16.8838V16.8888V16.8937V16.8987V16.9036V16.9086V16.9135V16.9185V16.9235V16.9284V16.9334V16.9384V16.9434V16.9484V16.9534V16.9584V16.9634V16.9684V16.9734V16.9784V16.9834V16.9884V16.9934V16.9985V17.0035V17.0085V17.0136V17.0186V17.0237V17.0287V17.0338V17.0389V17.0439V17.049V17.0541V17.0592V17.0643V17.0693V17.0744V17.0796V17.0847V17.0898V17.0949V17.1V17.1052V17.1103V17.1154V17.1206V17.1257V17.1309V17.1361V17.1412V17.1464V17.1516V17.1568V17.162V17.1672V17.1724V17.1776V17.1828V17.188V17.1933V17.1985V17.2037V17.209V17.2142V17.2195V17.2248V17.23V17.2353V17.2406V17.2459V17.2512V17.2565V17.2618V17.2671V17.2725V17.2778V17.2831V17.2885V17.2938V17.2992V17.3046V17.3099V17.3153V17.3207V17.3261V17.3315V17.3369V17.3424V17.3478V17.3532V17.3587V17.3641V17.3696V17.375V17.3805V17.386V17.3915V17.397V17.4025V17.408V17.4135V17.419V17.4246V17.4301V17.4357V17.4412V17.4468V17.4524V17.458V17.4636V17.4692V17.4748V17.4804V17.486V17.4917V17.4973V17.503V17.5086V17.5143V17.52V17.5257V17.5314V17.5371V17.5428V17.5485V17.5543V17.56V17.5658V17.5715V17.5773V17.5831V17.5889V17.5947V17.6005V17.6063V17.6122V17.618V17.6238V17.6297V17.6356V17.6415V17.6473V17.6532V17.6592V17.6651V17.671V17.6769V17.6829V17.6889V17.6948V17.7008V17.7068V17.7128V17.7188V17.7248V17.7309V17.7369V17.743V17.749V17.7551V17.7612V17.7673V17.7734V17.7795V17.7857V17.7918V17.7979V17.8041V17.8103V17.8165V17.8227V17.8289V17.8351V17.8413V17.8476V17.8538V17.8601V17.8664V17.8727V17.879V17.8853V17.8916V17.8979V17.9043V17.9106V17.917V17.9234V17.9298V17.9362V17.9426V17.949V17.9555V17.9619V17.9684V17.9749V17.9814V17.9879V17.9944V18.0009V18.0075V18.014V18.0206V18.0272V18.0338V18.0404V18.047V18.0536V18.0603V18.0669V18.0736V18.0803V18.087V18.0937V18.1004V18.1072V18.1139V18.1207V18.1275V18.1343V18.1411V18.1479V18.1547V18.1616V18.1684V18.1753V18.1822V18.1891V18.196V18.2029V18.2099V18.2168V18.2238V18.2308V18.2378V18.2448V18.2518V18.2589V18.2659V18.273V18.2801V18.2872V18.2943C7.85003 19.0374 7.65832 19.756 7.0647 20.2541C6.50686 20.722 5.75861 20.85 5.00003 20.85C4.23401 20.85 3.48196 20.7233 2.92456 20.2518C2.33186 19.7504 2.15003 19.029 2.15003 18.2943V15.5278V15.5003V15.5003C2.15001 15.1086 2.14999 14.7083 2.18544 14.3515C2.22177 13.9859 2.3017 13.5801 2.51722 13.2134Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Home</h4>
            </a>
        </li>
        <li class="menu-item dropdown-indicator">
            <a class="menu-link @if (Route::is('event.coordinator.forms.pending.registrations.*') ||
                    Route::is('event.coordinator.forms.confirm.registrations.*')) active @endif" data-bs-toggle="collapse"
                href="#dropdown7" role="button"
                @if (Route::is('event.coordinator.forms.pending.registrations.*') ||
                        Route::is('event.coordinator.forms.confirm.registrations.*')) aria-expanded="true" @else aria-expanded="false" @endif
                aria-controls="dropdown7" title="Event Speakers">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.4"
                        d="M19.1199 9.11999C18.7299 9.11999 18.4199 9.42999 18.4199 9.81999V11.4C18.4199 14.94 15.5399 17.82 11.9999 17.82C8.45993 17.82 5.57993 14.94 5.57993 11.4V9.80999C5.57993 9.41999 5.26993 9.10999 4.87993 9.10999C4.48993 9.10999 4.17993 9.41999 4.17993 9.80999V11.39C4.17993 15.46 7.30993 18.81 11.2999 19.17V21.3C11.2999 21.69 11.6099 22 11.9999 22C12.3899 22 12.6999 21.69 12.6999 21.3V19.17C16.6799 18.82 19.8199 15.46 19.8199 11.39V9.80999C19.8099 9.42999 19.4999 9.11999 19.1199 9.11999Z"
                        fill="#292D32" />
                    <path
                        d="M12.0001 2C9.56008 2 7.58008 3.98 7.58008 6.42V11.54C7.58008 13.98 9.56008 15.96 12.0001 15.96C14.4401 15.96 16.4201 13.98 16.4201 11.54V6.42C16.4201 3.98 14.4401 2 12.0001 2ZM13.3101 8.95C13.2401 9.21 13.0101 9.38 12.7501 9.38C12.7001 9.38 12.6501 9.37 12.6001 9.36C12.2101 9.25 11.8001 9.25 11.4101 9.36C11.0901 9.45 10.7801 9.26 10.7001 8.95C10.6101 8.64 10.8001 8.32 11.1101 8.24C11.7001 8.08 12.3201 8.08 12.9101 8.24C13.2101 8.32 13.3901 8.64 13.3101 8.95ZM13.8401 7.01C13.7501 7.25 13.5301 7.39 13.2901 7.39C13.2201 7.39 13.1601 7.38 13.0901 7.36C12.3901 7.1 11.6101 7.1 10.9101 7.36C10.6101 7.47 10.2701 7.31 10.1601 7.01C10.0501 6.71 10.2101 6.37 10.5101 6.27C11.4701 5.92 12.5301 5.92 13.4901 6.27C13.7901 6.38 13.9501 6.71 13.8401 7.01Z"
                        fill="#292D32" />
                </svg>
                <h4 class="headline">Registrations</h4>
            </a>
            <ul class="sidenav-submenu collapse @if (Route::is('event.coordinator.forms.pending.registrations.*') ||
                    Route::is('event.coordinator.forms.confirm.registrations.*')) show @endif" id="dropdown7">
                <li class="menu-item">
                    <a href="{{ route('event.coordinator.forms.pending.registrations.index', ['events' => Session::get('event_code')]) }}"
                        class="menu-link @if (Route::is('event.coordinator.forms.pending.registrations.*')) active @endif">
                        <h4 class="headline">Pending Registrations</h4>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="{{ route('event.coordinator.forms.confirm.registrations.index', ['events' => Session::get('event_code')]) }}"
                        class="menu-link @if (Route::is('event.coordinator.forms.confirm.registrations.*')) active @endif">
                        <h4 class="headline">Confirm Registrations</h4>
                    </a>
                </li>
            </ul>
        </li>

        <li class="menu-item">
            <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                class="menu-link logout" title="Log out">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M3.85002 12C3.85002 9.99114 3.85029 8.45417 3.91141 7.26228C3.97333 6.05473 4.09509 5.30104 4.28923 4.81568C4.45864 4.39214 4.66921 4.20038 4.9956 4.07345C5.39632 3.91761 6.00387 3.84999 7.00002 3.84999C7.97383 3.84999 8.65326 3.91173 9.12813 4.01725C9.60149 4.12244 9.80451 4.25656 9.89898 4.35103C9.98323 4.43528 10.0546 4.56044 10.0991 4.82723C10.1476 5.11838 10.15 5.47843 10.15 5.99999C10.15 6.46944 10.5306 6.84999 11 6.84999C11.4695 6.84999 11.85 6.46944 11.85 5.99999L11.85 5.95742V5.95741C11.8501 5.49111 11.8502 4.99303 11.776 4.54775C11.6954 4.06455 11.5168 3.56471 11.1011 3.14895C10.6955 2.74342 10.1486 2.50254 9.49692 2.35773C8.84679 2.21326 8.02622 2.14999 7.00002 2.14999C5.99618 2.14999 5.10373 2.20737 4.37945 2.48904C3.58084 2.79961 3.04141 3.35785 2.71082 4.18431C2.40496 4.94895 2.27671 5.94526 2.21364 7.17521C2.15002 8.41571 2.15002 9.99583 2.15002 11.9755V11.9757V12V12.0243V12.0245C2.15002 14.0042 2.15002 15.5843 2.21364 16.8248C2.27671 18.0547 2.40496 19.051 2.71082 19.8157C3.04141 20.6421 3.58084 21.2004 4.37945 21.5109C5.10373 21.7926 5.99618 21.85 7.00002 21.85C8.02622 21.85 8.84679 21.7867 9.49692 21.6423C10.1486 21.4974 10.6955 21.2566 11.1011 20.851C11.5168 20.4353 11.6954 19.9354 11.776 19.4522C11.8502 19.007 11.8501 18.5089 11.85 18.0426V18.0426L11.85 18C11.85 17.5306 11.4695 17.15 11 17.15C10.5306 17.15 10.15 17.5306 10.15 18C10.15 18.5216 10.1476 18.8816 10.0991 19.1728C10.0546 19.4395 9.98323 19.5647 9.89898 19.649C9.80451 19.7434 9.60149 19.8775 9.12813 19.9827C8.65326 20.0883 7.97383 20.15 7.00002 20.15C6.00387 20.15 5.39632 20.0824 4.9956 19.9265C4.66921 19.7996 4.45864 19.6078 4.28923 19.1843C4.09509 18.699 3.97333 17.9453 3.91141 16.7377C3.85029 15.5458 3.85002 14.0088 3.85002 12ZM17.6011 7.39895C17.2691 7.06701 16.7309 7.06701 16.399 7.39895C16.067 7.7309 16.067 8.26909 16.399 8.60103L18.9479 11.15H11C10.5306 11.15 10.15 11.5306 10.15 12C10.15 12.4694 10.5306 12.85 11 12.85H18.9479L16.399 15.399C16.067 15.7309 16.067 16.2691 16.399 16.601C16.7309 16.933 17.2691 16.933 17.6011 16.601L21.6011 12.601C21.933 12.2691 21.933 11.7309 21.6011 11.399L17.6011 7.39895Z"
                        fill="#7C8DB5" />
                </svg>
                <h4 class="headline">Log out</h4>
            </a>
            <form id="logout-form"
                action="{{ route('event.coordinator.logout', ['events' => Session::get('event_code')]) }}"
                method="POST" class="d-none">
                @csrf
            </form>
        </li>
    </ul>

</div>
