<li class="menu-item">
    <a href="{{ route('membership.form.index') }}" class="menu-link  @if (Route::is('membership.form.index')) active @endif"
        title="Membership Form">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M8.89281 6.2902C8.95947 5.82478 9.1017 5.56808 9.3032 5.39536C9.63851 5.10795 10.363 4.84999 12 4.84999C13.6371 4.84999 14.3615 5.10795 14.6969 5.39536C14.8987 5.56835 15.041 5.82558 15.1075 6.2924C14.2013 6.18944 13.1687 6.14999 12 6.14999C10.83 6.14999 9.79777 6.18956 8.89281 6.2902ZM7.15891 6.60317C7.20285 5.67764 7.42673 4.76473 8.19685 4.10463C9.0282 3.39204 10.3037 3.14999 12 3.14999C13.6963 3.14999 14.9718 3.39204 15.8032 4.10463C16.5763 4.76729 16.7989 5.68473 16.8416 6.61395C17.7273 6.86092 18.4776 7.23419 19.0805 7.79769C20.2614 8.90157 20.6879 10.5594 20.8092 12.7389C20.8357 12.8212 20.85 12.9089 20.85 13C20.85 13.1577 20.8469 13.3169 20.8387 13.4766C20.8466 13.7793 20.85 14.0911 20.85 14.4118C20.85 16.8466 20.5321 18.8446 19.0663 20.1541C17.6393 21.429 15.3374 21.85 12 21.85C10.3152 21.85 8.91604 21.768 7.77127 21.5396C6.62224 21.3105 5.67025 20.9227 4.9347 20.2676C3.45528 18.9499 3.15002 16.8222 3.15002 14C3.15002 13.7798 3.15188 13.5639 3.15601 13.3522C3.15176 13.2342 3.15002 13.1167 3.15002 13C3.15002 12.9331 3.15776 12.868 3.17238 12.8055C3.26457 10.5721 3.67186 8.85715 4.9347 7.73243C5.53531 7.19751 6.28024 6.84081 7.15891 6.60317ZM4.85702 13.341C4.91096 10.9192 5.2797 9.70165 6.06535 9.00193C6.49647 8.61797 7.12781 8.32218 8.10378 8.12752C9.08401 7.93202 10.3515 7.84999 12 7.84999C13.6493 7.84999 14.9142 7.93215 15.8914 8.13297C16.8623 8.3325 17.4892 8.63735 17.9196 9.03961C18.6917 9.76135 19.0647 11.0152 19.1369 13.459C19.1137 13.8253 19.0586 14.1213 18.9613 14.3695C18.837 14.6867 18.6282 14.9658 18.2262 15.2152C17.3434 15.763 15.5692 16.15 12.0061 16.15C8.44326 16.15 6.66526 15.7631 5.77898 15.2147C5.37506 14.9647 5.16503 14.6851 5.03999 14.3679C4.93198 14.094 4.87554 13.7617 4.85702 13.341ZM18.9827 16.743C18.8014 17.7423 18.4647 18.4119 17.9337 18.8863C17.0274 19.696 15.3293 20.15 12 20.15C10.3515 20.15 9.08401 20.068 8.10378 19.8725C7.12781 19.6778 6.49647 19.382 6.06535 18.9981C5.54773 18.537 5.21107 17.8512 5.02619 16.7444C6.37574 17.5116 8.56842 17.85 12.0061 17.85C15.4448 17.85 17.6357 17.5114 18.9827 16.743ZM9.15002 14C9.15002 13.5306 9.53058 13.15 10 13.15H14C14.4695 13.15 14.85 13.5306 14.85 14C14.85 14.4694 14.4695 14.85 14 14.85L10 14.85C9.53058 14.85 9.15002 14.4694 9.15002 14Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Membership Form</h4>
    </a>
</li>


<li class="menu-item">
    <a href="{{ route('sliders.index') }}" class="menu-link  @if (Route::is('sliders.*')) active @endif"
        title="Slider">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M3 12h18M3 6h18M3 18h18" stroke="#7C8DB5" stroke-width="2" stroke-linecap="round" />
            <circle cx="5" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="12" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="19" cy="12" r="2" fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Web Sliders</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('banners.index') }}" class="menu-link  @if (Route::is('banners.*')) active @endif"
        title="Banner">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M3 12h18M3 6h18M3 18h18" stroke="#7C8DB5" stroke-width="2" stroke-linecap="round" />
            <circle cx="5" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="12" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="19" cy="12" r="2" fill="#7C8DB5" />
        </svg>
        <h4 class="headline">App Banners</h4>
    </a>
</li>

<li class="menu-item dropdown-indicator">
    <a class="menu-link @if (Route::is('members.*') || Route::is('member.roles.*')) active @endif" data-bs-toggle="collapse" href="#dropdown1"
        role="button" @if (Route::is('members.*') || Route::is('member.roles.*')) aria-expanded="true" @else aria-expanded="false" @endif
        aria-controls="dropdown1" title="Chapters">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M8.89281 6.2902C8.95947 5.82478 9.1017 5.56808 9.3032 5.39536C9.63851 5.10795 10.363 4.84999 12 4.84999C13.6371 4.84999 14.3615 5.10795 14.6969 5.39536C14.8987 5.56835 15.041 5.82558 15.1075 6.2924C14.2013 6.18944 13.1687 6.14999 12 6.14999C10.83 6.14999 9.79777 6.18956 8.89281 6.2902ZM7.15891 6.60317C7.20285 5.67764 7.42673 4.76473 8.19685 4.10463C9.0282 3.39204 10.3037 3.14999 12 3.14999C13.6963 3.14999 14.9718 3.39204 15.8032 4.10463C16.5763 4.76729 16.7989 5.68473 16.8416 6.61395C17.7273 6.86092 18.4776 7.23419 19.0805 7.79769C20.2614 8.90157 20.6879 10.5594 20.8092 12.7389C20.8357 12.8212 20.85 12.9089 20.85 13C20.85 13.1577 20.8469 13.3169 20.8387 13.4766C20.8466 13.7793 20.85 14.0911 20.85 14.4118C20.85 16.8466 20.5321 18.8446 19.0663 20.1541C17.6393 21.429 15.3374 21.85 12 21.85C10.3152 21.85 8.91604 21.768 7.77127 21.5396C6.62224 21.3105 5.67025 20.9227 4.9347 20.2676C3.45528 18.9499 3.15002 16.8222 3.15002 14C3.15002 13.7798 3.15188 13.5639 3.15601 13.3522C3.15176 13.2342 3.15002 13.1167 3.15002 13C3.15002 12.9331 3.15776 12.868 3.17238 12.8055C3.26457 10.5721 3.67186 8.85715 4.9347 7.73243C5.53531 7.19751 6.28024 6.84081 7.15891 6.60317ZM4.85702 13.341C4.91096 10.9192 5.2797 9.70165 6.06535 9.00193C6.49647 8.61797 7.12781 8.32218 8.10378 8.12752C9.08401 7.93202 10.3515 7.84999 12 7.84999C13.6493 7.84999 14.9142 7.93215 15.8914 8.13297C16.8623 8.3325 17.4892 8.63735 17.9196 9.03961C18.6917 9.76135 19.0647 11.0152 19.1369 13.459C19.1137 13.8253 19.0586 14.1213 18.9613 14.3695C18.837 14.6867 18.6282 14.9658 18.2262 15.2152C17.3434 15.763 15.5692 16.15 12.0061 16.15C8.44326 16.15 6.66526 15.7631 5.77898 15.2147C5.37506 14.9647 5.16503 14.6851 5.03999 14.3679C4.93198 14.094 4.87554 13.7617 4.85702 13.341ZM18.9827 16.743C18.8014 17.7423 18.4647 18.4119 17.9337 18.8863C17.0274 19.696 15.3293 20.15 12 20.15C10.3515 20.15 9.08401 20.068 8.10378 19.8725C7.12781 19.6778 6.49647 19.382 6.06535 18.9981C5.54773 18.537 5.21107 17.8512 5.02619 16.7444C6.37574 17.5116 8.56842 17.85 12.0061 17.85C15.4448 17.85 17.6357 17.5114 18.9827 16.743ZM9.15002 14C9.15002 13.5306 9.53058 13.15 10 13.15H14C14.4695 13.15 14.85 13.5306 14.85 14C14.85 14.4694 14.4695 14.85 14 14.85L10 14.85C9.53058 14.85 9.15002 14.4694 9.15002 14Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Members</h4>
    </a>
    <ul class="sidenav-submenu collapse @if (Route::is('members.*') || Route::is('member.roles.*')) show @endif" id="dropdown1">
        <li class="menu-item">
            <a href="{{ route('members.index') }}" class="menu-link  @if (Route::is('members.*')) active @endif">
                <h4 class="headline">Members</h4>
            </a>
        </li>
        <li class="menu-item">
            <a href="{{ route('member.roles.index') }}"
                class="menu-link @if (Route::is('member.roles.*')) active @endif">
                <h4 class="headline">Roles</h4>
            </a>
        </li>
    </ul>
</li>

<li class="menu-item">
    <a href="{{ route('committees.index') }}" class="menu-link  @if (Route::is('committees.*')) active @endif"
        title="Committee">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor">
            <path
                d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-3.33 0-10 1.67-10 5v2h20v-2c0-3.33-6.67-5-10-5z" />
        </svg>

        <h4 class="headline">Committee</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('notices.index') }}" class="menu-link  @if (Route::is('notices.*')) active @endif"
        title="Slider">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="currentColor">
            <path
                d="M12 2C10.89 2 10 2.89 10 4V6.22C7.83 6.6 6 8.89 6 11V15C6 17.21 7.79 19 10 19H14C16.21 19 18 17.21 18 15V11C18 8.89 16.17 6.6 14 6.22V4C14 2.89 13.11 2 12 2ZM12 18C10.9 18 10 17.1 10 16H14C14 17.1 13.1 18 12 18ZM8 15V11C8 9.9 8.9 9 10 9H14C15.1 9 16 9.9 16 11V15H8Z" />
        </svg>


        <h4 class="headline">Notices</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('association.settings.index') }}"
        class="menu-link  @if (Route::is('association.settings.index')) active @endif" title="Settings">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Settings</h4>
    </a>
</li>
<li class="menu-item">
    <a href="{{ route('events.index') }}" class="menu-link  @if (Route::is('events.*') && (!Route::is('events.manager.*'))) active @endif"
        title="Event">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Event</h4>
    </a>
</li>
<li class="menu-item">
    <a href="{{ route('events.manager.index') }}" class="menu-link  @if (Route::is('events.manager.*')) active @endif"
        title="Event Managers">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Event Managers</h4>
    </a>
</li>
<li class="menu-item">
    <a href="{{ route('calendars.index') }}" class="menu-link  @if (Route::is('calendars.*')) active @endif"
        title="Calendar">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Calendar</h4>
    </a>
</li>
<li class="menu-item">
    <a href="{{ route('past.office.bearers.index') }}"
        class="menu-link  @if (Route::is('past.office.bearers.*')) active @endif" title="Past Off.Bearer">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Past Off Bearer</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('international.affiliations.index') }}"
        class="menu-link  @if (Route::is('international.affiliations.*')) active @endif" title="International Affiliations">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M6.60537 6.51378C8.19355 7.05875 9.85686 5.9649 10.1523 4.45575C10.334 3.6714 10.5472 3.3284 10.7588 3.15285C10.963 2.9834 11.3113 2.84999 12.0681 2.84999C12.6537 2.84999 12.9861 2.99729 13.2032 3.2013C13.4367 3.42073 13.6532 3.81471 13.7831 4.52742L13.7831 4.52742L13.7839 4.53188C13.9393 5.35915 14.5089 5.98299 15.1709 6.3281C15.8348 6.67419 16.6677 6.78319 17.4529 6.50676C17.4638 6.50292 17.4746 6.49885 17.4854 6.49457C18.2385 6.19431 18.6479 6.20024 18.8979 6.28468C19.1438 6.36773 19.4259 6.5908 19.7749 7.18204C20.1315 7.78636 20.1785 8.1088 20.1376 8.32686C20.0947 8.55514 19.9137 8.8927 19.2772 9.42088L19.2655 9.43072C17.9883 10.5298 17.9883 12.4701 19.2655 13.5693L19.2772 13.5791C19.9137 14.1073 20.0947 14.4448 20.1376 14.6731C20.1785 14.8912 20.1315 15.2136 19.7749 15.8179C19.4279 16.4058 19.1416 16.6392 18.8818 16.7328C18.6166 16.8283 18.1994 16.8428 17.4486 16.5868C15.9258 16.0535 14.076 16.9607 13.7817 18.6708C13.6509 19.4305 13.4405 19.7311 13.2525 19.8767C13.0499 20.0337 12.6968 20.15 11.9699 20.15C11.2703 20.15 10.9103 20.0198 10.6988 19.8501C10.4938 19.6856 10.2861 19.3694 10.1574 18.6662C9.86052 16.9591 8.01275 16.054 6.49126 16.5867C5.74049 16.8428 5.3233 16.8283 5.05808 16.7328C4.79834 16.6392 4.51204 16.4058 4.16504 15.8179C4.16029 15.8099 4.15541 15.8019 4.15039 15.794C3.84533 15.3141 3.81342 14.9815 3.878 14.7201C3.95058 14.4262 4.18745 14.0489 4.7567 13.5825L4.77249 13.5693C6.07171 12.4512 5.92902 10.5134 4.67803 9.52704C4.11043 8.97074 3.93322 8.61707 3.89204 8.36078C3.85285 8.11685 3.90914 7.78512 4.25594 7.19432C4.574 6.6978 4.86758 6.48716 5.15516 6.39857C5.46392 6.30346 5.90804 6.3048 6.60537 6.51378ZM12.0681 1.14999C11.1567 1.14999 10.3275 1.30159 9.67315 1.84463C9.02738 2.38052 8.70223 3.17439 8.49211 4.08984C8.48957 4.10088 8.48726 4.11197 8.48517 4.12311C8.37911 4.68781 7.70759 5.09964 7.14969 4.90323C7.13774 4.89902 7.1257 4.89508 7.11357 4.89141C6.25006 4.63016 5.42296 4.53725 4.65468 4.77391C3.86511 5.01714 3.2779 5.5639 2.81381 6.29402C2.8088 6.30192 2.80391 6.30989 2.79916 6.31794C2.3674 7.04945 2.08131 7.80732 2.21357 8.63046C2.34332 9.438 2.84692 10.1206 3.52868 10.7807C3.55389 10.8051 3.58058 10.8279 3.60861 10.849C4.07858 11.2029 4.11427 11.8861 3.66994 12.2752C2.96812 12.8521 2.42399 13.5173 2.2276 14.3124C2.02343 15.139 2.23349 15.9423 2.70805 16.6939C3.1449 17.4308 3.69105 18.0473 4.48191 18.3322C5.27117 18.6165 6.12879 18.5071 7.04414 18.1943L7.04416 18.1944L7.05157 18.1918C7.68665 17.9682 8.38504 18.3908 8.48288 18.9592L8.48284 18.9592L8.48434 18.9674C8.65007 19.8766 8.98177 20.6521 9.63502 21.1762C10.2821 21.6952 11.0996 21.85 11.9699 21.85C12.8131 21.85 13.6375 21.7288 14.2935 21.2208C14.9641 20.7013 15.2934 19.9095 15.457 18.9592C15.5549 18.3908 16.2532 17.9682 16.8883 18.1918L16.8883 18.1918L16.8958 18.1943C17.8111 18.5071 18.6687 18.6165 19.458 18.3322C20.2531 18.0458 20.8008 17.4242 21.2389 16.682C21.6672 15.9564 21.9636 15.1863 21.8083 14.3594C21.6554 13.5452 21.1035 12.8868 20.3696 12.2765C19.887 11.8565 19.887 11.1435 20.3696 10.7235C21.1035 10.1132 21.6554 9.45483 21.8083 8.64063C21.9636 7.81368 21.6672 7.04363 21.2389 6.31794C20.8028 5.57918 20.2508 4.94726 19.4419 4.67406C18.6426 4.40414 17.7828 4.54864 16.8749 4.90785C16.5837 5.00575 16.2451 4.97098 15.9567 4.82064C15.6628 4.66739 15.4965 4.43702 15.455 4.21978C15.2904 3.31864 14.9673 2.52618 14.3673 1.96243C13.7504 1.3827 12.9543 1.14999 12.0681 1.14999ZM9.85002 11.5C9.85002 10.3126 10.8126 9.34999 12 9.34999C13.1874 9.34999 14.15 10.3126 14.15 11.5C14.15 12.6874 13.1874 13.65 12 13.65C10.8126 13.65 9.85002 12.6874 9.85002 11.5ZM12 7.64999C9.87372 7.64999 8.15002 9.3737 8.15002 11.5C8.15002 13.6263 9.87372 15.35 12 15.35C14.1263 15.35 15.85 13.6263 15.85 11.5C15.85 9.3737 14.1263 7.64999 12 7.64999Z"
                fill="#7C8DB5" />
        </svg>
        <h4 class="headline">International Affiliations</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('notifications.index') }}"
        class="menu-link  @if (Route::is('notifications.*')) active @endif" title="Notifications">
        <svg width="800px" height="800px" viewBox="0 0 24 24" version="1.1"
            xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">

            <title>notice-active</title>
            <desc>Created with sketchtool.</desc>
            <g id="web-app" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                <g id="notice-active" fill="#000000">
                    <path
                        d="M15.0846417,4.85258583 C15.3698859,3.78571001 16.3431867,3 17.5,3 C18.8807119,3 20,4.11928813 20,5.5 C20,6.82802369 18.9645064,7.9141949 17.6568748,7.99515796 C17.8790698,8.62208363 18,9.29691944 18,10 L18,16 L19,16 C19.5499992,16 20,16.4500008 20,17 C20,17.5499992 19.5499992,18 19,18 L15,18 L15,19 C15,20.6568542 13.6568542,22 12,22 C10.3431458,22 9,20.6568542 9,19 L9,18 L5,18 C4.44999981,18 4,17.5499992 4,17 C4,16.4500008 4.44999981,16 5,16 L6,16 L6,10 C6,7.02700371 8.16228666,4.55903653 11,4.08295844 L11,3 C11,2.44771525 11.4477153,2 12,2 C12.5522847,2 13,2.44771525 13,3 L13,4.08295844 C13.7514465,4.20902728 14.4555302,4.47477291 15.0846417,4.85258583 Z M12,20 C12.5522847,20 13,19.5522847 13,19 C13,18.7251922 13,18.3918589 13,18 L11,18 C11,18.470365 11,18.8036984 11,19 C11,19.5522847 11.4477153,20 12,20 Z M8,16 L16,16 L16,10 C16,7.790861 14.209139,6 12,6 C9.790861,6 8,7.790861 8,10 L8,16 Z"
                        id="Shape">
                    </path>
                </g>
            </g>
        </svg>
        <h4 class="headline">Notifications</h4>
    </a>
</li>

<li class="menu-item">
    <a href="{{ route('polls.index') }}"
        class="menu-link  @if (Route::is('polls.*')) active @endif" title="Polls">
        <svg fill="#000000" height="800px" width="800px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 
            viewBox="0 0 512 512" xml:space="preserve">
        <g>
            <g>
                <g>
                    <path d="M501.333,0c-25.109,0-57.024,16.128-66.475,21.205L298.667,0.363c-19.136,0-65.323,1.237-80.299,12.267L133.035,65.6
                        c-4.053,2.517-5.931,7.403-4.629,11.989c1.323,4.587,5.504,7.744,10.261,7.744h96c0.853,0,1.685-0.107,2.517-0.256l14.293-3.52
                        c9.237-1.344,18.453,1.408,25.472,7.488c7.04,6.08,11.051,14.891,11.051,24.192c0,7.403-2.304,14.464-6.677,20.459
                        l-33.557,46.101c-9.365,14.037-7.509,32.896,4.437,44.843c6.933,6.912,16.021,10.389,25.131,10.389s18.197-3.477,25.131-10.411
                        l54.08-54.08c20.203-1.131,38.677-9.856,52.373-23.936c18.944,17.557,79.573,23.125,91.584,24.043
                        c0.277,0.021,0.555,0.021,0.832,0.021c2.667,0,5.269-1.003,7.232-2.837c2.197-2.027,3.435-4.864,3.435-7.829V10.667
                        C512,4.779,507.221,0,501.333,0z M416.043,71.296l-12.309,46.699c-10.112,19.349-29.845,31.339-51.733,31.339
                        c-2.837,0-5.547,1.109-7.552,3.115l-57.088,57.088c-5.355,5.355-14.72,5.355-20.075,0c-4.779-4.757-5.525-12.309-2.027-17.557
                        l33.323-45.739c7.04-9.664,10.752-21.099,10.752-33.045c0-15.467-6.699-30.165-18.389-40.299
                        c-9.664-8.363-21.888-12.928-35.029-12.928c-2.773,0-5.611,0.213-8.448,0.619L233.408,64h-57.344l54.251-33.707
                        c6.677-4.907,36.053-8.597,66.731-8.725l126.528,19.477C421.504,48.448,418.816,58.901,416.043,71.296z M490.667,148.267
                        c-23.061-2.603-51.392-7.915-63.467-14.635c2.133-20.736,5.888-40.832,9.6-57.429l9.771-37.077
                        c9.856-5.184,28.224-13.611,44.096-16.661V148.267z"/>
                    <path d="M405.163,392.917l-21.333-128c-0.853-5.141-5.291-8.917-10.517-8.917H320c0-5.888-4.779-10.667-10.667-10.667
                        s-10.667,4.779-10.667,10.667v10.56c0,0.043-0.021,0.064-0.021,0.107s0.021,0.064,0.021,0.107V320h-192V128H256
                        c5.888,0,10.667-4.779,10.667-10.667s-4.779-10.667-10.667-10.667H96c-5.888,0-10.667,4.779-10.667,10.667V256H32
                        c-5.205,0-9.664,3.776-10.517,8.917l-21.333,128c-0.043,0.277,0.064,0.533,0.043,0.789C0.171,394.048,0,394.325,0,394.667
                        v106.667C0,507.221,4.779,512,10.667,512h384c5.888,0,10.667-4.779,10.667-10.667V394.667c0-0.363-0.171-0.683-0.213-1.024
                        C405.099,393.387,405.205,393.152,405.163,392.917z M41.024,277.333h44.309V320H74.667C68.779,320,64,324.779,64,330.667
                        s4.779,10.667,10.667,10.667h256c5.888,0,10.667-4.779,10.667-10.667S336.555,320,330.667,320H320v-42.667h44.288L382.059,384
                        H23.253L41.024,277.333z M384,490.667H21.333v-85.333H384V490.667z"/>
                </g>
            </g>
        </g>
        </svg>
        <h4 class="headline">Polls</h4>
    </a>
</li>
<li class="menu-item">
    <a href="{{ route('association.posts.index') }}" class="menu-link  @if (Route::is('association.posts.*')) active @endif"
        title="Slider">
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M3 12h18M3 6h18M3 18h18" stroke="#7C8DB5" stroke-width="2" stroke-linecap="round" />
            <circle cx="5" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="12" cy="12" r="2" fill="#7C8DB5" />
            <circle cx="19" cy="12" r="2" fill="#7C8DB5" />
        </svg>
        <h4 class="headline">Posts</h4>
    </a>
</li>
