@extends('frontend.event.registration.layout')
@section('css')
@endsection
@section('content')
    @include('includes.message')
    <div class="container event-form">
        <div class="card my-5">
            <div class="card-body px-3">
                <form class="custom-validation" method="post" action="" id="event-registration-form" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="total_amount" id="total_amount" value="0">
                    <div class="row gy-4">
                        @foreach ($eventFormInputFields as $index => $eventFormInputField)
                            @switch($eventFormInputField->type)
                                @case('text')
                                @if ($eventFormInputField->name === 'transaction_id')
                                    <div class="col-md-6" id="transaction_id_wrapper" style="display: none">
                                        <div class="form-group">
                                            <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                            <input
                                                class="form-control {{ $eventFormInputField->name === 'email' ? 'email email-' . $index : '' }}"
                                                type="{{ $eventFormInputField->name === 'email' ? 'email' : 'text' }}"
                                                id="field_{{ $index }}" name="{{ $eventFormInputField->name }}"
                                                placeholder="{{ $eventFormInputField->helper_text ?? 'Enter ' . strtolower($eventFormInputField->display_label) }}"
                                                value="{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}"
                                                @if ($eventFormInputField->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputField->display_label) }} field is required." @endif
                                                @if ($eventFormInputField->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address."
                                                @endif />
                                        </div>
                                        <div class="invalid-feedback" id="transaction-error" style="display: none;">
                                            Payment is already made with this transaction Id
                                        </div>
                                    </div>
                                @elseif($eventFormInputField->name === 'email')
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                            <input
                                                class="form-control {{ $eventFormInputField->name === 'email' ? 'email email-' . $index : '' }}"
                                                type="{{ $eventFormInputField->name === 'email' ? 'email' : 'text' }}"
                                                id="field_{{ $index }}" name="{{ $eventFormInputField->name }}"
                                                placeholder="{{ $eventFormInputField->helper_text ?? 'Enter ' . strtolower($eventFormInputField->display_label) }}"
                                                value="{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}"
                                                @if ($eventFormInputField->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputField->display_label) }} field is required." @endif
                                                @if ($eventFormInputField->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address."
                                                @endif />
                                        </div>
                                        <div class="invalid-feedback" id="email-error" style="display: none;">
                                            This email is already registered for the event.
                                        </div>
                                    </div>
                                @else
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                            <input
                                                class="form-control {{ $eventFormInputField->name === 'email' ? 'email email-' . $index : '' }}"
                                                type="{{ $eventFormInputField->name === 'email' ? 'email' : 'text' }}"
                                                id="field_{{ $index }}" name="{{ $eventFormInputField->name }}"
                                                placeholder="{{ $eventFormInputField->helper_text ?? 'Enter ' . strtolower($eventFormInputField->display_label) }}"
                                                value="{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}"
                                                @if ($eventFormInputField->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputField->display_label) }} field is required." @endif
                                                @if ($eventFormInputField->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address."
                                                @endif />
                                        </div>
                                    </div>
                                @endif
                                @break

                                @case('dropdown')
                                    @if ($eventFormInputField->name === 'country')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                @include(
                                                    'frontend.event.registration.includes.country-select2',
                                                    [
                                                        'placeholder' =>
                                                            '-- Select ' . $eventFormInputField->display_label . ' --',
                                                        'required' =>
                                                            $eventFormInputField->required ==
                                                            \App\Enums\EventFormFieldEnum::REQUIRED,
                                                        'errorBlockId' => 'error-block-' . $index,
                                                        'defaultValue' => old(
                                                            $eventFormInputField->name,
                                                            $eventFormInputField->default_value ?? ''),
                                                    ]
                                                )
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'state')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2 state" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'city')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2 city" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'category')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        @foreach ($eventCategories as $category)
                                                            <option value="{{ $category->id }}">
                                                                {{ $category->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'workshop')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        <option value="no">No</option>
                                                        @foreach ($eventWorkshops as $workshop)
                                                            <option value="{{ $workshop->id }}">
                                                                {{ $workshop->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'register_accompany')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        @foreach ($eventFormInputField->options ?? [] as $option)
                                                            <option value="{{ $option['value'] }}"
                                                                @if ($eventFormInputField->default_value == $option['value']) selected @endif>
                                                                {{ $option['title'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($eventFormInputField->name === 'accompany_person')
                                        <div class="col-md-6" id="accompany_person_wrapper" style="display: none">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        @foreach ($eventFormInputField->options ?? [] as $option)
                                                            <option value="{{ $option['value'] }}"
                                                                @if ($eventFormInputField->default_value == $option['value']) selected @endif>
                                                                {{ $option['title'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="accompany_inputs_container" class="row" style="display: none"></div>
                                    @elseif($eventFormInputField->name === 'payment_mode')
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        @foreach ($eventFormInputField->options ?? [] as $option)
                                                            <option value="{{ $option['value'] }}"
                                                                @if ($eventFormInputField->default_value == $option['value']) selected @endif>
                                                                {{ $option['title'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                            <div class="form-group" id="bank_details_wrapper" style="display: none">
                                                <label for="bank_details">Bank Details</label>
                                                @if(isset($event->eventBankDetails))
                                                    {!! nl2br($event->eventBankDetails->bank_details) !!}
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div id="qrcode"></div>
                                        </div>
                                    @else
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="select2-drop">
                                                    <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                    <select class="form-select select2" name="{{ $eventFormInputField->name }}"
                                                        id="field_{{ $index }}"
                                                        @if ($eventFormInputField->required) required
                                                        data-parsley-errors-container="#error-block-{{ $index }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif>
                                                        <option value="">-- Select {{ $eventFormInputField->display_label }} --
                                                        </option>
                                                        @foreach ($eventFormInputField->options ?? [] as $option)
                                                            <option value="{{ $option['value'] }}"
                                                                @if ($eventFormInputField->default_value == $option['value']) selected @endif>
                                                                {{ $option['title'] }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="margin-top10" id="error-block-{{ $index }}"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif 
                                @break

                                @case('textarea')
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                            <textarea class="form-control {{ $eventFormInputField->name }}" id="field_{{ $index }}"
                                                name="{{ $eventFormInputField->name }}"
                                                placeholder="{{ $eventFormInputField->helper_text ?? 'Enter ' . strtolower($eventFormInputField->display_label) }}"
                                                rows="3"
                                                @if ($eventFormInputField->required) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputField->display_label) }} field is required." @endif>{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}</textarea>
                                        </div>
                                    </div>
                                @break

                                @case('date')
                                    @if ($eventFormInputField->name === 'transaction_date')
                                        <div class="col-md-6" id="transaction_date_wrapper" style="display: none">
                                            <div class="form-group">
                                                <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                <input class="form-control fc-datepicker" type="text"
                                                    name="{{ $eventFormInputField->name }}" id="field_{{ $index }}"
                                                    placeholder="{{ $eventFormInputField->helper_text ?? 'Select ' . strtolower($eventFormInputField->ldisplay_labelbel) }}"
                                                    value="{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}"
                                                    autocomplete="off"
                                                    @if ($eventFormInputField->required) required
                                                    data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif />
                                            </div>
                                        </div>
                                    @else
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                <input class="form-control fc-datepicker" type="text"
                                                    name="{{ $eventFormInputField->name }}" id="field_{{ $index }}"
                                                    placeholder="{{ $eventFormInputField->helper_text ?? 'Select ' . strtolower($eventFormInputField->display_label) }}"
                                                    value="{{ old($eventFormInputField->name, $eventFormInputField->default_value ?? '') }}"
                                                    autocomplete="off"
                                                    @if ($eventFormInputField->required) required
                                                    data-parsley-required-message="Please select {{ strtolower($eventFormInputField->display_label) }}." @endif />
                                            </div>
                                        </div>
                                    @endif
                                @break

                                @case('file_input')
                                    @if ($eventFormInputField->name === 'upload_payment_receipt')
                                        <div class="col-md-6" id="upload_payment_receipt_wrapper" style="display: none">
                                            <div class="form-group">
                                                <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                <input class="form-control {{ $eventFormInputField->name }}" type="file"
                                                    id="field_{{ $index }}" name="{{ $eventFormInputField->name }}"
                                                    @if ($eventFormInputField->required) required
                                                    data-parsley-required-message="Please upload {{ strtolower($eventFormInputField->display_label) }}." @endif />
                                            </div>
                                        </div>
                                    @else
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="field_{{ $index }}">{{ $eventFormInputField->display_label }} @if($eventFormInputField->required)<span class="text-danger">*</span> @endif</label>
                                                <input class="form-control {{ $eventFormInputField->name }}" type="file"
                                                    id="field_{{ $index }}" name="{{ $eventFormInputField->name }}"
                                                    @if ($eventFormInputField->required) required
                                                    data-parsley-required-message="Please upload {{ strtolower($eventFormInputField->display_label) }}." @endif />
                                            </div>
                                        </div>
                                    @endif 
                                @break
                            @endswitch
                        @endforeach
                        <div class="row pt-3">
                            <div class="col-md-6">
                                <h5>Total Amount: <span id="final-amount">0</span> ₹</h5>
                            </div>
                        </div>
                    </div>
                    <div class="row form-group pt-4 justify-content-center">
                        <div class="col-md-4 text-center">
                            <button type="submit" id="submit-btn" class="mx-auto text-center btn btn-warning btn-sm">Register</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('pageJS')
    @include('frontend.event.registration.includes.event_js')
@endsection