<!DOCTYPE html>
<html class="wide" lang="en">

<head>
    <title>{{ 'Event '.$event->title ?? '' }}</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,height=device-height,initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="{{ asset('assets/images/logo.png') }}" type="image/x-icon" />
    <link rel="stylesheet" type="text/css"
        href="https://fonts.googleapis.com/css?family=Barlow%7CBarlow+Condensed:300,400,500,600,700,900">
    <link href="{{ asset('assets/frontend/event/css/bootstrap.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/frontend/event/css/fonts.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/event/css/style.css') }}">
    <style>
        .nav-link-cite {
            font-size: 16px !important;
        }
    </style>
</head>

<body>
    <div class="page">
        <!-- Section Conference Schedule-->
        <section class="section bg-default text-center pt-4">

            <div class="tabs-custom tabs-horizontal tabs-corporate" id="tabs-1">
                <!--Nav tabs-->
                <ul class="nav nav-tabs">
                    <style>
                        .tabs-custom .nav-link-35 {
                            background-color: #ff0000;
                            color: #00ffe1;
                        }
                        .tabs-custom .nav-link:hover, .tabs-custom .nav-link.active{
                            background-color:#f4f2ee !important;
                        }
                    </style>
                    @foreach ($eventDays as $key => $eventDay)
                        <li class="nav-item" role="presentation">
                            <a class="nav-link nav-link nav-link-secondary-darker @if($key == 0) active  @endif show"
                                style="background-color: {{ $eventDay->bg_color }}; color: {{ $eventDay->text_color }}" href="#{{$key}}" data-toggle="tab"
                                data-triangle=".nav-link-overlay">
                                <span class="nav-link-overlay"></span>
                                <span class="nav-link-cite">{{ $eventDay->name }} |
                                    {{ getTimezoneDateTime($eventDay->date, 'd/m/Y') }}</span>
                            </a>
                        </li>
                    @endforeach
                    <style>
                        .tabs-custom .nav-link-15 {
                            background-color: #8a0000;
                            color: #ffffff;
                        }
                    </style>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link nav-link nav-link-secondary-darker nav-link-15 " href="#tabs15"
                            data-toggle="tab" data-triangle=".nav-link-overlay">
                            <span class="nav-link-overlay"></span>
                            <span class="nav-link-cite" style="font-size: 16px;">Day - 1 | 15th August 2024 </span>
                            <!--<span class="nav-link-title">15th August 2024 </span>-->
                        </a>
                    </li>
                    <style>
                        .tabs-custom .nav-link-16 {
                            background-color: #7a008a;
                            color: #ffffff;
                        }
                    </style>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link nav-link nav-link-secondary-darker nav-link-16 " href="#tabs16"
                            data-toggle="tab" data-triangle=".nav-link-overlay">
                            <span class="nav-link-overlay"></span>
                            <span class="nav-link-cite" style="font-size: 16px;">Day - 2 | 15th August 2024 </span>
                            <!--<span class="nav-link-title">15th August 2024 </span>-->
                        </a>
                    </li>
                    <style>
                        .tabs-custom .nav-link-17 {
                            background-color: #00298a;
                            color: #ffffff;
                        }
                    </style>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link nav-link nav-link-secondary-darker nav-link-17 " href="#tabs17"
                            data-toggle="tab" data-triangle=".nav-link-overlay">
                            <span class="nav-link-overlay"></span>
                            <span class="nav-link-cite" style="font-size: 16px;">Day - 3 | 17th August 2024 </span>
                            <!--<span class="nav-link-title">17th August 2024 </span>-->
                        </a>
                    </li>
                    <style>
                        .tabs-custom .nav-link-18 {
                            background-color: #8a5e00;
                            color: #ffffff;
                        }
                    </style>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link nav-link nav-link-secondary-darker nav-link-18 " href="#tabs18"
                            data-toggle="tab" data-triangle=".nav-link-overlay">
                            <span class="nav-link-overlay"></span>
                            <span class="nav-link-cite" style="font-size: 16px;">Day - 4 | 18th August 2024 </span>
                            <!--<span class="nav-link-title">18th August 2024 </span>-->
                        </a>
                    </li>

                </ul>



                <!--Tab panes-->


                <div class="tab-content wow fadeIn">
                    <style>
                        .thade-35 {
                            background-color: #ff0000;
                            color: #00ffe1;
                        }
                    </style>
                    @foreach ($eventDays as $key => $eventDay)
                    <div class="tab-pane fade  active @if($key == 0) show @endif  " id="{{$key}}">
                        <div class="card-group-custom card-group-corporate" id="accordion35" role="tablist"
                            aria-multiselectable="false">
                            <table class="table table-bordered">
                                @foreach ($eventDay->eventParentSessions as $eventSession)
                                    <thead
                                        style="background: {{ $eventSession->bg_color ?? '#000ba8' }}; color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                        <tr>
                                            <th scope="col" colspan="7">
                                                <h5 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                                    {{ $eventSession->title ?? '' }}</h5>

                                                @foreach ($event->eventDesignations as $eventDesignation)
                                                    @php
                                                        $eventSessionUserNames = null;
                                                        $eventSessionUserNames =
                                                            $eventSession
                                                                ->eventSessionUsers()
                                                                ->wherePivot(
                                                                    'event_designation_id',
                                                                    $eventDesignation->id,
                                                                )
                                                                ->pluck('name')
                                                                ->toArray() ?? '';
                                                    @endphp
                                                    @if (!empty($eventSessionUserNames))
                                                        <h6 class='lsp-1' style='color: #ffffff;'>
                                                            {{ $eventDesignation->designation }}:
                                                            @foreach ($eventSessionUserNames as $key => $eventSessionUserName)
                                                                <a href='javascript:;'
                                                                    class=''>{{ $eventSessionUserName }}</a>
                                                                @if ($key < count($eventSessionUserNames) - 1)
                                                                    ,
                                                                @endif
                                                            @endforeach
                                                        </h6>
                                                    @endif
                                                @endforeach
                                                @php
                                                    $facultyNames = null;
                                                    $facultyNames =
                                                        $eventSession->eventSessionFaculties
                                                            ->pluck('name')
                                                            ->toArray() ?? '';
                                                @endphp
                                                @if (!empty($facultyNames))
                                                    <h6 class='lsp-1' style="color: {{ $eventSession->text_color ?? '#ffffff' }};">Faculty:
                                                        @foreach ($facultyNames as $key => $facultyName)
                                                            <a href='javascript:;'
                                                                class=''>{{ $facultyName }}</a>
                                                            @if ($key < count($facultyNames) - 1)
                                                                ,
                                                            @endif
                                                        @endforeach
                                                    </h6>
                                                @endif
                                                @if ($eventSession->eventHall)
                                                    <h6 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">Hall:
                                                        {{ $eventSession->eventHall->name }}
                                                    </h6>
                                                @endif
                                                <h6 style="color: {{ $eventSession->text_color ?? '#ffffff' }};">
                                                    Time:
                                                    {{ getFormattedDates($eventSession->start_time, 'h:i A') }}-
                                                    {{ getFormattedDates($eventSession->end_time, 'h:i A') }}</h6>
                                            </th>
                                        </tr>
                                        <tr style="background-color: #ffffff; color:#000000">
                                            <th scope="col">Time</th>
                                            <th scope="col" style="width: 400px;">Topic</th>
                                            <th scope="col">Speaker</th>
                                            <th scope="col">Chairperson / Panelists / Faculty</th>
                                        </tr>
                                    </thead>
                                    @foreach ($eventSession->subSessions as $subSession)
                                        @php
                                            $eventSessionAllUsers = [];
                                        @endphp

                                        @php
                                            $facultyNames = null;
                                            $facultyNames = $subSession->eventSessionFaculties->pluck('name')->toArray() ?? '';
                                            $speakerNames = null;
                                            $speakerNames = $subSession->eventSessionSpeakers->pluck('name')->toArray() ?? '';
                                        @endphp
                                        @if (!empty($facultyNames))
                                            @php
                                                $eventSessionAllUsers = array_merge(
                                                    $eventSessionAllUsers,
                                                    $facultyNames,
                                                );
                                            @endphp
                                        @endif

                                        @foreach ($event->eventDesignations as $eventDesignation)
                                            @php
                                                $eventSessionUserNames = $subSession
                                                    ->eventSessionUsers()
                                                    ->wherePivot('event_designation_id', $eventDesignation->id)
                                                    ->pluck('name')
                                                    ->toArray();
                                            @endphp

                                            @if (!empty($eventSessionUserNames))
                                                @php
                                                    $eventSessionAllUsers = array_merge(
                                                        $eventSessionAllUsers,
                                                        $eventSessionUserNames,
                                                    );
                                                @endphp
                                            @endif
                                        @endforeach

                                        {{-- @dd($eventSessionAllUsers); --}}
                                        <tbody>
                                            <tr id='Row_414'>
                                                <td style='background: #ffffff; color: #000000;'>
                                                    {{ getFormattedDates($subSession->start_time, 'h:i A') }}-
                                                    {{ getFormattedDates($subSession->end_time, 'h:i A') }}
                                                </td>
                                                <td style='background: #ffffff; color: #000000;'>
                                                    {{ $subSession->topic ?? '-' }}
                                                </td>
                                                @if (!empty($speakerNames))
                                                    <td style='background: #ffffff; color: #000000;'>
                                                        @foreach ($speakerNames as $key => $speaker)
                                                            <a
                                                                href='javascript:;'>{{ $speaker ?? '' }}</a>
                                                            @if ($key < count($speakerNames) - 1)
                                                                |
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                @else
                                                    <td>-</td>
                                                @endif
                                                @if (!empty($eventSessionAllUsers))
                                                    <td style='background: #ffffff; color: #000000;'>
                                                        @foreach ($eventSessionAllUsers as $key => $eventSessionAllUsersName)
                                                            <a
                                                                href='javascript:;'>{{ $eventSessionAllUsersName ?? '' }}</a>
                                                            @if ($key < count($eventSessionAllUsers) - 1)
                                                                |
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                @else
                                                    <td>-</td>
                                                @endif

                                                {{-- @foreach ($event->eventDesignations as $eventDesignation)
                                                <td style='background: #ffffff; color: #000000;'>
                                                    oooo
                                                </td>
                                            @endforeach --}}
                                            </tr>
                                        </tbody>
                                    @endforeach
                                @endforeach
                            </table>
                        </div>
                    </div>
                    @endforeach




                    <style>
                        .thade-15 {
                            background-color: #8a0000;
                            color: #ffffff;
                        }
                    </style>
                    <div class="tab-pane fade  " id="tabs15">
                        <div class="card-group-custom card-group-corporate" id="accordion15" role="tablist"
                            aria-multiselectable="false">

                            <table class="table table-bordered">
                                <thead style="background: #ffffff; color: #000000;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #000000;'>Session Name 0</h5>

                                            <h6 class='lsp-1' style='color: #000000;'>Chairperson: <a
                                                    href='javascript:;' class='' onclick='showProf(`196`)'>Mr.
                                                    Shivraj
                                                    Singh Thakur</a>, <a href='javascript:;' class=''
                                                    onclick='showProf(`213`)'>Mr. Saitej Gulivindala </a>, <a
                                                    href='javascript:;' class='' onclick='showProf(`214`)'>Ms.
                                                    Sushmita
                                                    Shah</a></h6>
                                            <h6 class='lsp-1' style='color: #000000;'>Co Chairperson: <a
                                                    href='javascript:;' class='' onclick='showProf(`200`)'>Mr.
                                                    Rajeev
                                                    Ali</a></h6>
                                            <h6 style='color: #000000;'>Hall: Hall - A</h6>
                                            <h6 style='color: #000000;'>Time: 11:00 AM - 12:00 PM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_392'>
                                        <td style='background: #f7f5c5; color: #000000;'>11:00 AM - 11:15 AM</td>
                                        <td style='background: #f7f5c5; color: #000000;'>jesbgwjr wlrnler erjbpe</td>
                                        <td style='background: #f7f5c5; color: #000000;'><a href='javascript:;'
                                                onclick='showProf(`190`)'>Ms. M. V. Naga Bharathi</a> | <a
                                                href='javascript:;' onclick='showProf(`208`)'>Mr. Koneti Jagan</a> |
                                            <a href='javascript:;' onclick='showProf(`229`)'>Mr. Arjun Barman</a>
                                        </td>
                                        <td style='background: #f7f5c5; color: #000000;'><a href='javascript:;'
                                                onclick='showProf(`190`)'>Ms. M. V. Naga Bharathi</a></td>
                                    </tr>
                                    <tr id='Row_159'>
                                        <td style='background: #ffffff; color: #000000;'>11:15 AM - 11:30 AM</td>
                                        <td style='background: #ffffff; color: #000000;'>4th5ynu,kyi tymtmy,h</td>
                                        <td style='background: #ffffff; color: #000000;'><a href='javascript:;'
                                                onclick='showProf(`229`)'>Mr. Arjun Barman</a> | <a
                                                href='javascript:;' onclick='showProf(`230`)'>Dr. Basheer Uddin</a>
                                        </td>
                                        <td style='background: #ffffff; color: #000000;'><a href='javascript:;'
                                                onclick='showProf(`229`)'>Mr. Arjun Barman</a></td>
                                    </tr>
                                    <tr id='Row_154'>
                                        <td style='background: #ffffff; color: #000000;'>11:30 AM - 11:45 AM</td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                    </tr>
                                    <tr id='Row_155'>
                                        <td style='background: #ffffff; color: #000000;'>11:45 AM - 12:00 PM</td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                    </tr>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: #ffffff; color: #000000;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #000000;'>Session Name 1</h5>
                                            <h6 style='color: #000000;'>Topic: Advanced Understanding of Basic Sciences
                                                in MIS</h6>
                                            <h6 class='lsp-1' style='color: #000000;'>Chairperson: <a
                                                    href='javascript:;' class='' onclick='showProf(`229`)'>Mr.
                                                    Arjun
                                                    Barman</a></h6>
                                            <h6 style='color: #000000;'>Hall: Hall - A</h6>
                                            <h6 style='color: #000000;'>Time: 09:30 AM - 10:45 AM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_81'>
                                        <td style='background: ; color: ;'>09:30 AM - 09:45 AM</td>
                                        <td style='background: ; color: ;'>Ergonomics injuries</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`192`)'>Mr. Teliki Sai Uday Kiran</a> | <a
                                                href='javascript:;' onclick='showProf(`190`)'>Ms. M. V. Naga
                                                Bharathi</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`192`)'>Mr. Teliki Sai Uday Kiran</a></td>
                                    </tr>
                                    <tr id='Row_47'>
                                        <td style='background: ; color: ;'>09:45 AM - 10:00 AM</td>
                                        <td style='background: ; color: ;'>Electrosurgical currents - pure cut,
                                            dessication, fulguration and blend: Which should be used in MIS and when?
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`194`)'>Rithika Koppulapalli</a> | <a
                                                href='javascript:;' onclick='showProf(`196`)'>Shivraj Singh Thakur</a>
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`194`)'>Rithika Koppulapalli</a></td>
                                    </tr>
                                    <tr id='Row_48'>
                                        <td style='background: ; color: ;'>10:00 AM - 10:15 AM</td>
                                        <td style='background: ; color: ;'>Sterilization and disinfection in
                                            laparoscopy: What is the current standard? Options available and their
                                            cost-effectiveness</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`200`)'>Rajeev Ali</a> | <a href='javascript:;'
                                                onclick='showProf(`201`)'>M.sharath</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`200`)'>Rajeev Ali</a></td>
                                    </tr>
                                    <tr id='Row_49'>
                                        <td style='background: ; color: ;'>10:15 AM - 10:30 AM</td>
                                        <td style='background: ; color: ;'>The barbed suture in MIS: securing the ends
                                            in different designs, where it can and cannot be used</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`202`)'>Shaik Arifa</a> | <a href='javascript:;'
                                                onclick='showProf(`205`)'>Mallela. Sai Rohith</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`202`)'>Shaik Arifa</a></td>
                                    </tr>
                                    <tr id='Row_50'>
                                        <td style='background: ; color: ;'>10:30 AM - 10:45 AM</td>
                                        <td style='background: ; color: ;'>When equipments malfunction: Troubleshooting
                                            for the laparoscopic surgeon</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Koneti Jagan</a> | <a href='javascript:;'
                                                onclick='showProf(`211`)'>Marripudi Sai Dheeraj</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Koneti Jagan</a></td>
                                    </tr>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: #050505; color: #ffffff;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #ffffff;'>Session 2</h5>
                                            <h6 style='color: #ffffff;'>Topic: Being a better laparoscopic surgeon</h6>
                                            <h6 class='lsp-1' style='color: #ffffff;'>Chairperson: <a
                                                    href='javascript:;' class='' onclick='showProf(`221`)'>Mr.
                                                    Ramesh
                                                    Durgam</a></h6>
                                            <h6 style='color: #ffffff;'>Hall: Hall - B</h6>
                                            <h6 style='color: #ffffff;'>Time: 10:45 AM - 12:00 PM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_98'>
                                        <td style='background: ; color: ;'>10:45 AM - 11:00 AM</td>
                                        <td style='background: ; color: ;'>Training opportunities in MIS for Indian
                                            surgeons (as well as for our neighboring friends)</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`229`)'>Mr. Arjun Barman</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`229`)'>Mr. Arjun Barman</a></td>
                                    </tr>
                                    <tr id='Row_57'>
                                        <td style='background: ; color: ;'>11:00 AM - 11:15 AM</td>
                                        <td style='background: ; color: ;'>NIRF Imaging in MIS: Applications, timings
                                            and dosage of administration of dye in different indications, fallacies</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`223`)'>Mr. Abdul Kaleem</a> | <a
                                                href='javascript:;' onclick='showProf(`221`)'>Mr. Ramesh Durgam</a>
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`223`)'>Mr. Abdul Kaleem</a></td>
                                    </tr>
                                    <tr id='Row_58'>
                                        <td style='background: ; color: ;'>11:15 AM - 11:30 AM</td>
                                        <td style='background: ; color: ;'>Understanding the physiology and pathology
                                            behind liver function tests (hematological)</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`218`)'>Mr. Jadi Sudhakar </a> | <a
                                                href='javascript:;' onclick='showProf(`216`)'>Mr. Allakula Ajith Sai
                                            </a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`218`)'>Mr. Jadi Sudhakar </a></td>
                                    </tr>
                                    <tr id='Row_59'>
                                        <td style='background: ; color: ;'>11:30 AM - 11:45 AM</td>
                                        <td style='background: ; color: ;'>Atypical Mycobacterial infections:
                                            pathomicrobiology, diagnosis and treatment regimen</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`215`)'>Mr. Bugudala Virinchi </a> | <a
                                                href='javascript:;' onclick='showProf(`214`)'>Ms. Sushmita Shah</a>
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`215`)'>Mr. Bugudala Virinchi </a></td>
                                    </tr>
                                    <tr id='Row_60'>
                                        <td style='background: ; color: ;'>11:45 AM - 12:00 PM</td>
                                        <td style='background: ; color: ;'>Optical trocars and their optimum usage</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`213`)'>Mr. Saitej Gulivindala </a> | <a
                                                href='javascript:;' onclick='showProf(`211`)'>Mr. Marripudi Sai
                                                Dheeraj</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`213`)'>Mr. Saitej Gulivindala </a></td>
                                    </tr>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: ; color: ;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: ;'>Session 3</h5>
                                            <h6 style='color: ;'>Topic: Battle of the Bulge</h6>
                                            <h6 style='color: ;'>Hall: Hall - C</h6>
                                            <h6 style='color: ;'>Time: 12:00 PM - 01:00 PM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_65'>
                                        <td style='background: ; color: ;'>12:00 PM - 12:15 PM</td>
                                        <td style='background: ; color: ;'>IPOM/IPUM- is there still a place for it? An
                                            American perspective</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Mr. Koneti Jagan</a> | <a
                                                href='javascript:;' onclick='showProf(`205`)'>Mr. Mallela. Sai
                                                Rohith</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Mr. Koneti Jagan</a></td>
                                    </tr>
                                    <tr id='Row_66'>
                                        <td style='background: ; color: ;'>12:15 PM - 12:30 PM</td>
                                        <td style='background: ; color: ;'>Preventive strategies for incisional hernias
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`228`)'>Ms. Qamarunissa</a> | <a href='javascript:;'
                                                onclick='showProf(`214`)'>Ms. Sushmita Shah</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`228`)'>Ms. Qamarunissa</a></td>
                                    </tr>
                                    <tr id='Row_67'>
                                        <td style='background: ; color: ;'>12:30 PM - 12:45 PM</td>
                                        <td style='background: ; color: ;'>Types of hernia prosthesis (macro/micro
                                            porous; light/medium/heavy weight; woven/knitted; materials) and choosing
                                            the best one for your case</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`192`)'>Mr. Teliki Sai Uday Kiran</a> | <a
                                                href='javascript:;' onclick='showProf(`190`)'>Ms. M. V. Naga
                                                Bharathi</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`192`)'>Mr. Teliki Sai Uday Kiran</a></td>
                                    </tr>
                                    <tr id='Row_68'>
                                        <td style='background: ; color: ;'>12:45 PM - 01:00 PM</td>
                                        <td style='background: ; color: ;'>Role of AI in planning hernia repair</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`196`)'>Mr. Shivraj Singh Thakur</a> | <a
                                                href='javascript:;' onclick='showProf(`215`)'>Mr. Bugudala Virinchi
                                            </a>
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`196`)'>Mr. Shivraj Singh Thakur</a></td>
                                    </tr>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: ; color: ;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: ;'>LUNCH</h5>

                                            <h6 style='color: ;'>Hall: Lunch Room</h6>
                                            <h6 style='color: ;'>Time: 01:00 PM - 02:00 PM</h6>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: #a65d2b; color: #71a111;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #71a111;'>Dean Francis</h5>
                                            <h6 style='color: #71a111;'>Topic: Reprehenderit cumque</h6>
                                            <h6 style='color: #71a111;'>Hall: Hall - C</h6>
                                            <h6 style='color: #71a111;'>Time: 05:13 PM - 01:25 AM</h6>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: #33066d; color: #491435;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #491435;'>Nigel Melendez</h5>
                                            <h6 style='color: #491435;'>Topic: Odit amet doloribus</h6>
                                            <h6 style='color: #491435;'>Hall: Hall - B</h6>
                                            <h6 style='color: #491435;'>Time: 07:43 PM - 01:27 PM</h6>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>

                            <table class="table table-bordered">
                                <thead style="background: #a65d2b; color: #71a111;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: #71a111;'>Dean Francis</h5>
                                            <h6 style='color: #71a111;'>Topic: Reprehenderit cumque</h6>
                                            <h6 style='color: #71a111;'>Hall: Hall - B</h6>
                                            <h6 style='color: #71a111;'>Time: 05:00 PM - 06:00 PM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_416'>
                                        <td style='background: #ffffff; color: #000000;'>05:00 PM - 05:30 PM</td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                    </tr>
                                    <tr id='Row_417'>
                                        <td style='background: #ffffff; color: #000000;'>05:30 PM - 06:00 PM</td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                        <td style='background: #ffffff; color: #000000;'></td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!--</div>-->
                    <style>
                        .thade-16 {
                            background-color: #7a008a;
                            color: #ffffff;
                        }
                    </style>
                    <div class="tab-pane fade  " id="tabs16">
                        <div class="card-group-custom card-group-corporate" id="accordion16" role="tablist"
                            aria-multiselectable="false">

                            <table class="table table-bordered">
                                <thead style="background: ; color: ;">
                                    <tr>
                                        <th scope="col" colspan="7">
                                            <h5 style='color: ;'>Session 19</h5>
                                            <h6 style='color: ;'>Topic: GROIN HERNIA</h6>
                                            <h6 class='lsp-1' style='color: ;'>Rapporteur: <a href='javascript:;'
                                                    class='' onclick='showProf(`190`)'>M. V. Naga Bharathi</a>,
                                                <a href='javascript:;' class=''
                                                    onclick='showProf(`194`)'>Rithika
                                                    Koppulapalli</a>
                                            </h6>
                                            <h6 style='color: ;'>Hall: Hall - A</h6>
                                            <h6 style='color: ;'>Time: 03:00 PM - 04:00 PM</h6>

                                        </th>
                                    </tr>
                                    <tr>
                                        <th scope="col">Time</th>
                                        <th scope="col">Topic</th>
                                        <th scope="col">Moderator r ehgowhgow</th>
                                        <th scope="col">Chairperson / Panelists / Faculty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr id='Row_74'>
                                        <td style='background: ; color: ;'>03:00 PM - 03:15 PM</td>
                                        <td style='background: ; color: ;'>Management of chronic groin pain after
                                            laparoscopic hernia repair</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`202`)'>Ms. Shaik Arifa</a> | <a href='javascript:;'
                                                onclick='showProf(`223`)'>Mr. Abdul Kaleem</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`202`)'>Ms. Shaik Arifa</a></td>
                                    </tr>
                                    <tr id='Row_75'>
                                        <td style='background: ; color: ;'>03:15 PM - 03:30 PM</td>
                                        <td style='background: ; color: ;'>Intra-operative complications in
                                            laparoscopic
                                            inguinal hernia repair</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`216`)'>Mr. Allakula Ajith Sai </a> | <a
                                                href='javascript:;' onclick='showProf(`211`)'>Mr. Marripudi Sai
                                                Dheeraj</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`216`)'>Mr. Allakula Ajith Sai </a></td>
                                    </tr>
                                    <tr id='Row_76'>
                                        <td style='background: ; color: ;'>03:30 PM - 03:45 PM</td>
                                        <td style='background: ; color: ;'>Laparoscopic management of Giant Scrotal
                                            hernias</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`200`)'>Mr. Rajeev Ali</a> | <a href='javascript:;'
                                                onclick='showProf(`205`)'>Mr. Mallela. Sai Rohith</a></td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`200`)'>Mr. Rajeev Ali</a></td>
                                    </tr>
                                    <tr id='Row_77'>
                                        <td style='background: ; color: ;'>03:45 PM - 04:00 PM</td>
                                        <td style='background: ; color: ;'>Robotic Inguinal Hernia: Cost vs results &
                                            quality of life</td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Mr. Koneti Jagan</a> | <a
                                                href='javascript:;' onclick='showProf(`229`)'>Mr. Arjun Barman</a>
                                        </td>
                                        <td style='background: ; color: ;'><a href='javascript:;'
                                                onclick='showProf(`208`)'>Mr. Koneti Jagan</a></td>
                                    </tr>
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <!--</div>-->
                    <style>
                        .thade-17 {
                            background-color: #00298a;
                            color: #ffffff;
                        }
                    </style>
                    <div class="tab-pane fade  " id="tabs17">
                        <div class="card-group-custom card-group-corporate" id="accordion17" role="tablist"
                            aria-multiselectable="false">

                        </div>
                    </div>
                    <!--</div>-->
                    <style>
                        .thade-18 {
                            background-color: #8a5e00;
                            color: #ffffff;
                        }
                    </style>
                    {{-- <div class="tab-pane fade  " id="tabs18">
                        <div class="card-group-custom card-group-corporate" id="accordion18" role="tablist"
                            aria-multiselectable="false">

                        </div>
                    </div> --}}
                    <!--</div>-->
                </div>
            </div>
        </section>
    </div>


    <script src="{{ asset('assets/frontend/event/js/jquery.min.js') }}"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.nav-link').on('click', function() {
                $('.nav-link').removeClass('active show');
                $('.tab-pane').removeClass('active show');
                $(this).addClass('active show');
                var target = $(this).attr('href');
                $(target).addClass('active show');
            });
        });
    </script>

</body>

</html>
