@extends('layouts.master')
@section('css')
    <link href="{{ asset('assets/css/jquery.timepicker.min.css') }}" rel="stylesheet">
@endsection
@section('content')
    @php
        $extra = collect($eventVenue->extra ?? []);
    @endphp
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.venues.update', $eventVenue->id) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit {{ $eventVenue->name ?? '-' }}
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.venues.index', $eventVenue->eventDay->id) }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Title" id="name"
                                    class="form-control" value="{{ old('name', $eventVenue->name) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @php
                                        $countryCodes = getCountries();
                                    @endphp
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach (getCountries() as $countryCode)
                                            <option @if ($countryCode->country_code == '+91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact', $eventVenue->contact) }}" name="contact"
                                    id="contact" class="form-control" maxlength="10" minlength="10"
                                    placeholder="Enter Contact"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Video Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input name="video_link" type="url" id="video_link" placeholder="Enter Video Link"
                                    class="form-control" value="{{ old('video_link', $extra->get('video_link')) }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Website Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input name="website_link" type="url" id="website_link" placeholder="Enter Website Link"
                                    class="form-control" value="{{ old('website_link', $eventVenue->website_link) }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index', $eventVenue->index) }}" placeholder="Enter Index" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea rows="5" class="form-control" id="description" name="description" placeholder="Enter Description"
                                    maxlength="1024">{{ old('description', $extra->get('description')) }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Address') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea rows="5" class="form-control" id="address" name="address" placeholder="Enter Address"
                                    maxlength="1024">{{ old('address', $extra->get('address')) }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Latitude') }}
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control" placeholder="Latitude" type="text" name="latitude"
                                    id="latitude" value="{{ old('latitude', $eventVenue->latitude) }}">
                            </div>
                            <div class="col-sm-2">
                                <label>{{ __('Longitude') }}
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control" placeholder="Longitude" type="text" name="longitude"
                                    id="longitude" value="{{ old('longitude', $eventVenue->longitude) }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Address Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input name="address_link" type="url" id="address_link"
                                    placeholder="Enter Address Link" class="form-control"
                                    value="{{ old('address_link', $extra->get('address_link')) }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Start Time') }}
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input readonly class="form-control fc-timepicker" placeholder="HH:MM" type="text"
                                    name="start_time" id="start_time"
                                    value="{{ old('start_time', $eventVenue->start_date_time) }}">

                            </div>
                            <div class="col-sm-2">
                                <label>{{ __('End Time') }}
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input readonly class="form-control fc-timepicker" placeholder="MM:SS" type="text"
                                    name="end_time" id="end_time"
                                    value="{{ old('end_time', $eventVenue->end_date_time) }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.timepicker.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
            $('.timepicker').timepicker({
                timeFormat: 'hh:mm p',
                interval: 60,
                dynamic: false,
                dropdown: true,
                scrollbar: true
            });
            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 30,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
