@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.speakers.store', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add New Speaker
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.speakers.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Title') }}</label>
                            </div>
                            <div class="col-xl-4">
                                <select class="form-control select2" data-parsley-error-message="Please select Title"
                                    data-parsley-errors-container="#error-block" id="title" name="title" required>
                                    <option value="">Select Title</option>
                                    @foreach (\App\Enums\TitleEnum::getValues() as $title)
                                        <option value="{{ $title }}">{{ $title }}</option>
                                    @endforeach
                                </select required>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @php
                                        $countryCodes = getCountries();
                                    @endphp
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option @if ($countryCode->country_code == '91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact') }}" name="contact" id="contact"
                                    class="form-control" maxlength="10" minlength="10" placeholder="Enter Contact"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57' required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Speaker Type') }}</label>
                            </div>
                            <div class="col-sm-5 mb-2">
                                <select class="form-control select2" name="event_speaker_type_id" id="event_speaker_type_id"
                                    data-placeholder="Select Speaker Type" data-parsley-errors-container="#error-block-2" data-parsley-error-message="Please Select Type" required>
                                    @if (count($eventSpeakerTypes) > 0)
                                        <option value="">Select Speaker Type</option>
                                        @foreach ($eventSpeakerTypes as $eventSpeakerType)
                                            <option value="{{ $eventSpeakerType->id }}">{{ $eventSpeakerType->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <div class="margin-top10" id="error-block-2"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Institute') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="institute" placeholder="Enter Institute" id="institute"
                                    class="form-control" value="{{ old('institute') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Designation') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="designation" placeholder="Enter Designation" id="designation"
                                    class="form-control" value="{{ old('designation') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Personal Info') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="personal_info" id="personal_info" class="form-control" placeholder="Enter Personal Info"
                                    cols="30" rows="5">{{ old('personal_info') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Text 1') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="text_1" id="text_1" class="form-control" placeholder="Enter Text 1" cols="30"
                                    rows="5">{{ old('text_1') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Text 2') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="text_2" id="text_2" class="form-control" placeholder="Enter Text 2" cols="30"
                                    rows="5">{{ old('text_2') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Bio') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="bio" id="bio" class="form-control" placeholder="Enter bio" cols="30"
                                    rows="5">{{ old('bio') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Extra') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="extra" id="extra" class="form-control" placeholder="Enter extra details"
                                    cols="30" rows="5">{{ old('extra') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Profile Image') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" onchange="loadFile(this)" name="image" id="image"
                                            hidden="" required>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewLogo"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Profile Image will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
