@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }

        .event_session_status {
            color: white !important;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        @if (isset($parentSession))
                                            {{ $parentSession->title }} Sub-sessions ({{ $eventSessions->total() }})
                                        @else
                                            Sessions ({{ $eventSessions->total() }})
                                        @endif
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="title" class="form-control" placeholder="Title"
                                        @if ($request->title) value="{{ $request->title }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" name="event_hall_id" id="event_hall_id">
                                        <option value="">Select Event Hall</option>
                                        @foreach ($eventHalls as $eventHall)
                                            <option value="{{ $eventHall->id }}"
                                                @if ($request->event_hall_id == $eventHall->id) selected @endif>
                                                {{ $eventHall->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" name="event_day_id" id="event_day_id">
                                        <option value="">Select Event Day</option>
                                        @foreach ($eventDays as $eventDay)
                                            <option value="{{ $eventDay->id }}"
                                                @if ($request->event_day_id == $eventDay->id) selected @endif>
                                                {{ $eventDay->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                @if (isset($parentSession))
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.sub.sessions.create', $parentSession->id) }}"
                                            class="btn btn-outline-primary px-4">+
                                            Add new</a>
                                    </div>
                                @else
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('event.sessions.create') }}"
                                            class="btn btn-outline-primary px-4">+
                                            Add new</a>
                                    </div>
                                @endif
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <!-- Message -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Title</th>
                    <th>Topic</th>
                    <th>Text Color</th>
                    <th>Background Color</th>
                    @if (!isset($parentSession))
                        <th>Event Day</th>
                        <th>Event Hall</th>
                    @endif
                    <th>Start Time</th>
                    <th>End Time</th>
                    @if (!isset($parentSession))
                        <th>Status</th>
                        <th>Sub Sessions</th>
                    @endif
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventSessions) > 0)
                        @php $i = $eventSessions->perPage() * ($eventSessions->currentPage() - 1) + 1; @endphp
                        @php
                            $statuses = App\Enums\EventSessionEnum::getStatusAndColors();
                            $statusLabels = App\Enums\EventSessionEnum::getStatusLabels();
                        @endphp
                        @foreach ($eventSessions as $eventSession)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventSession->title ?? '' }}</td>
                                <td>
                                    @if ($eventSession->topic)
                                        {{ Str::limit($eventSession->topic, 30) }}
                                    @else
                                        -
                                    @endif
                                </td>
                                @if ($eventSession->text_color)
                                    <td>
                                        {{ $eventSession->text_color }}
                                        <div class="color" style="background: {{ $eventSession->text_color }}; ">
                                        </div>
                                    </td>
                                @else
                                    <td>-</td>
                                @endif
                                @if ($eventSession->bg_color)
                                    <td>
                                        {{ $eventSession->bg_color }}
                                        <div class="color" style="background: {{ $eventSession->bg_color }}; ">
                                        </div>
                                    </td>
                                @else
                                    <td>-</td>
                                @endif
                                @if (!isset($parentSession))
                                    <td>{{ $eventSession->eventDay->name ?? '' }}</td>
                                    <td>{{ $eventSession->eventHall->name ?? '' }}</td>
                                @endif
                                <td>{{ $eventSession->start_time ?? '-' }}
                                </td>
                                <td>{{ $eventSession->end_time ?? '-' }}
                                </td>
                                @if (!isset($parentSession))
                                    <td>
                                        <select name="status" id="event_session_status"
                                            class="form-control event_session_status"
                                            data-session-id="{{ $eventSession->id }}" style="width: auto;">
                                            <option value="" disabled>Select Status
                                            </option>
                                            @foreach ($statuses as $status => $color)
                                                <option value="{{ $status }}" data-color="{{ $color }}"
                                                    style="background-color: {{ $color }};"
                                                    {{ $eventSession->status == $status ? 'selected' : '' }}>
                                                    {{ $statusLabels[$status] ?? '' }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                @endif
                                @if (!isset($parentSession))
                                    @if ($eventSession->type == App\Models\EventSession::TYPE_AUTO)
                                        <td><a href="{{ route('event.sub.sessions.index', $eventSession->id) }}"
                                                class="btn btn-sm btn-primary" style="width: 130px">Sub-Sessions
                                                ({{ $eventSession->subSessions->count() }})
                                            </a></td>
                                    @else
                                        <td>-</td>
                                    @endif
                                @endif
                                <td>
                                    <div class="members-tools-button">
                                        @if (isset($parentSession))
                                            <a href="{{ route('event.sub.sessions.edit', $eventSession->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                            </a>
                                        @else
                                            <a href="{{ route('event.sessions.edit', $eventSession->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                            </a>
                                        @endif
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.sessions.destroy', $eventSession->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventSessions->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                <div class="modal-header">
                    <h5 class="modal-title">Change Index</h5>
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                </div>
                <form id="indexchange" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="modal-body">
                        <label>Enter Index</label>
                        <input type="text" class="form-control" id="index" placeholder="Enter index" name="index"
                            value="">
                        <input type="hidden" class="associationId" name="id" value="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        function changeColor(that) {
            var flagStatusColor = $(that).find('option:selected').data('color');
            $(that).css('background-color', flagStatusColor);
        }

        $($('.event_session_status')).each(function() {
            changeColor(this);
        })


        function updateEventSessionStatus(type, url, title, status = null) {
            swal({
                title: title,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        url: url,
                        type: type,
                        data: {
                            "_token": $("#csrf-token").val(),
                            "status": status,
                        },
                        success: function(response) {
                            swal({
                                text: response.message,
                                icon: "success",
                                button: "Ok",
                            }).then(function() {

                            });
                        }
                    });
                } else {
                    location.reload();
                }
            });
        }


        $('.event_session_status').on('change', function() {
            var status = $(this).val();
            var eventSessionId = $(this).data('session-id');
            var url = "{{ route('event.sessions.status', ':eventSession') }}";
            url = url.replace(':eventSession', eventSessionId);
            var title = 'Are You Sure Want To Change Status';
            changeColor(this);
            updateEventSessionStatus('patch', url, title, status);
        })

        $(document).on('click', '.index-btn', function() {
            var associationId = $(this).data('id');
            var index = $(this).data('value');

            $('#indexchange .associationId').val(associationId);
            $('#index').val(index);
            $("#myModal").modal("show");

        });

        $('#indexchange').on('submit', function(e) {
            e.preventDefault();

            var associationId = $('.associationId').val();
            var index = $('#index').val();

            var url = "{{ route('event.speakers.update.index', ':associationId') }}";
            url = url.replace(':associationId', associationId);
            $.ajax({
                url: url,
                method: 'PATCH',
                data: {
                    id: associationId,
                    index: index,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    swal({
                        text: response.message,
                        icon: "success",
                        button: "Ok",
                    }).then(function() {
                        location.reload();
                    });
                }
            });
        });
    </script>
@endsection
