@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.sessions.store', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add New Session
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4" id="submit-btn">submit</button>
                        <a href="{{ route('event.sessions.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Topic') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="topic" id="topic" class="form-control" placeholder="Topic" rows="3">{{ old('topic') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Notes') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="notes" id="notes" class="form-control" placeholder="Notes" rows="3">{{ old('notes') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Text Color') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label for="text_colorpicker">Color</label>
                                <input class="form-control text_color" type="color" id="text_colorpicker"
                                    name="text_color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff"
                                    required>
                            </div>
                            <div class="col-sm-4">
                                <label for="text_color">Hexcode</label>
                                <input class="form-control text_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" id="text_color"
                                    required></input>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Background Color') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <label for="bg_colorpicker">Color</label>
                                <input class="form-control bg_color" type="color" id="bg_colorpicker" name="bg_color"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" required>
                            </div>
                            <div class="col-sm-4">
                                <label for="bg_color">Hexcode</label>
                                <input class="form-control bg_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" id="bg_color"
                                    required></input>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Enable Ask Questions') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="ask_questions" name="ask_questions" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Yes</option>
                                    <option value="{{ App\Enums\StatusEnum::DEACTIVE }}" selected>No</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Type') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control select2" id="type" name="type"
                                    onchange="onChangeType()" required>
                                    <option value="{{ App\Models\EventSession::TYPE_AUTO }}">Auto</option>
                                    <option value="{{ App\Models\EventSession::TYPE_MANUAL }}">Manual</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Start Time') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control fc-timepicker" autocomplete="off" placeholder="MM:SS"
                                    type="text" name="start_time" id="start_time"
                                    data-parsley-error-message="Please Enter Start Time" value="{{ old('start_time') }}"
                                    required>
                            </div>
                            <div class="col-sm-2">
                                <label>{{ __('End Time') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-3">
                                <input class="form-control fc-timepicker" autocomplete="off" placeholder="MM:SS"
                                    type="text" name="end_time" data-parsley-error-message="Please Enter End Time"
                                    id="end_time" value="{{ old('end_time') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center sub_sessions_min_div">
                            <div class="col-sm-2">
                                <label>{{ __('Duration / Sub Session (In minutes)') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="sub_sessions_min" placeholder="Enter Sub Session"
                                    id="sub_sessions_min" class="form-control" value="{{ old('sub_sessions_min') }}"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57' required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center sub_sessions_div">
                            <div class="col-sm-2">
                                <label>{{ __('Total Sub Session') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="sub_sessions" placeholder="Total Sub Sessions"
                                    id="sub_sessions" class="form-control" value="{{ old('sub_sessions') }}"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57' readonly>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Day') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2" data-parsley-errors-container="#error-block"
                                    data-placeholder="Select Day" id="event_day_id" name="event_day_id">
                                    <option value="">Select Day</option>
                                    @foreach ($eventDays as $eventDay)
                                        <option value="{{ $eventDay->id }}">
                                            {{ $eventDay->name }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Hall') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2" data-parsley-errors-container="#error-block"
                                    data-placeholder="Select Hall" id="event_hall_id" name="event_hall_id">
                                    <option value="">Select Hall</option>
                                    @foreach ($eventHalls as $eventHall)
                                        <option value="{{ $eventHall->id }}">
                                            {{ $eventHall->name }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Speaker') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2 event_speaker_users" multiple
                                    data-parsley-error-message="Please select speaker"
                                    data-placeholder="Select Session speaker" id="event_speaker_ids"
                                    name="event_speaker_ids[]">
                                    <option value="">Select Session Speaker</option>
                                    @foreach ($eventSpeakers as $eventSpeaker)
                                        <option value="{{ $eventSpeaker->id }}">
                                            {{ $eventSpeaker->full_name }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Moderator') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="moderator" placeholder="Enter Moderator Name" id="moderator"
                                    class="form-control" value="{{ old('moderator') }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="{{ asset('assets/js/jquery.timepicker.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        var typeManual = @json(App\Models\EventSession::TYPE_MANUAL);

        $(document).ready(function() {
            $(".custom-validation").parsley();

            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 10,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });

            function checkMemberExists(startTime, endTime, eventDayId, selectedId, removeOne = false) {
                eventId = "{{ Session::get('event_id') }}";
                var checkSessionUserUrl = "{{ route('event.sessions.check.session.user', ':event') }}";
                checkSessionUserUrl = checkSessionUserUrl.replace(':event', eventId);
                $.ajax({
                    url: checkSessionUserUrl,
                    method: "POST",
                    data: {
                        _token: $("#csrf-token").val(),
                        user_id: selectedId,
                        start_time: startTime,
                        end_time: endTime,
                        event_day_id: eventDayId,
                    },
                    success: function(response) {
                        if (response.error) {

                            if (selectedId && removeOne) {
                                var optionToRemove = $('.event_session_users').find(
                                    'option[value="' + selectedId + '"]');
                                optionToRemove
                                    .remove();
                            } else {
                                var optionToRemove = $('.event_session_users').find(
                                    'option');
                                optionToRemove
                                    .remove();
                            }
                            alert(response.message);

                            return response.error
                        }
                    },
                    error: function() {
                        console.error("An error occurred while checking the condition.");
                    }
                });
            }

            function checkFacultyExists(startTime, endTime, eventDayId, selectedId, removeOne = false) {
                eventId = "{{ Session::get('event_id') }}";
                console.log(eventId);
                var checkFacultyUser = "{{ route('event.sessions.check.speaker.user', ':event') }}";
                checkFacultyUser = checkFacultyUser.replace(':event', eventId);

                $.ajax({
                    url: checkFacultyUser,
                    method: "POST",
                    data: {
                        _token: $("#csrf-token").val(),
                        speaker_id: selectedId,
                        start_time: startTime,
                        end_time: endTime,
                        event_day_id: eventDayId,
                    },
                    success: function(response) {
                        if (response.error) {

                            if (selectedId && removeOne) {
                                var optionToRemove = $('.event_speaker_users').find(
                                    'option[value="' + selectedId + '"]');
                                optionToRemove
                                    .remove();
                            } else {
                                var optionToRemove = $('.event_speaker_users').find(
                                    'option');
                                optionToRemove
                                    .remove();
                            }
                            alert(response.message);

                            return response.error
                        }
                    },
                    error: function() {
                        console.error("An error occurred while checking the condition.");
                    }
                });
            }

            $('.event_speaker_users').on('change', function() {
                var selectedValues = $(this).val();
                if (selectedValues.length === 0) {
                    return;
                }
                var startTime = $("#start_time").val();
                var endTime = $("#end_time").val();
                var eventDayId = $("#event_day_id").val();

                if (endTime == '' || startTime == '' || eventDayId == '') {
                    alert("Please Enter Start Time, End Time and Select Day.");
                    $(this).val(selectedValues.slice(0, -1)).trigger('change');
                    return;
                }
                var selectedId = selectedValues[selectedValues.length - 1];
                checkFacultyExists(startTime, endTime, eventDayId, selectedId, true);
            });

            $('#event_day_id').on('change', function() {
                var startTime = $("#start_time").val();
                var endTime = $("#end_time").val();
                var eventDayId = $("#event_day_id").val();

                if (endTime == '' || startTime == '' || eventDayId == '') {
                    return;
                }
                var isData = $('select[name^="event_designations"]').val();

                if (isData.length === 0) {
                    console.log(isData.length);
                    return;
                }

                $('select[name^="event_designations"]').each(function() {
                    var selectedUser = $(this).val();
                    if (!selectedUser || selectedUser.length === 0) {
                        return;
                    }
                    var designationId = $(this).attr('name').match(/\[(\d+)\]/)[
                        1];
                    console.log(selectedUser);
                    response = checkMemberExists(startTime, endTime, eventDayId, selectedUser);
                    if (response) {
                        return false;
                    }
                });

            });

            $('.event_session_users').on('change', function() {

                var selectedValues = $(this).val();
                if (selectedValues.length === 0) {
                    return;
                }
                var startTime = $("#start_time").val();
                var endTime = $("#end_time").val();
                var eventDayId = $("#event_day_id").val();

                if (endTime == '' || startTime == '' || eventDayId == '') {
                    alert("Please Enter Start Time, End Time and Select Day.");
                    var optionToRemove = $('.event_session_users').find(
                        'option');
                    optionToRemove
                        .remove();
                    return;
                }
                var selectedId = selectedValues[selectedValues.length - 1];
                checkMemberExists(startTime, endTime, eventDayId, selectedId, true);
            });

            $('.event_session_users').select2({
                ajax: {
                    url: "{{ route('members.search') }}",
                    method: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data.results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 1,
            });

        });

        $('#text_colorpicker').on('input', function() {
            $('#text_color').val(this.value);
        });
        $('#text_color').on('input', function() {
            $('#text_colorpicker').val(this.value);
        });

        $('#bg_colorpicker').on('input', function() {
            $('#bg_color').val(this.value);
        });
        $('#bg_color').on('input', function() {
            $('#bg_colorpicker').val(this.value);
        });

        function calculateSubSessions() {
            const startTime = $("#start_time").val();
            const endTime = $("#end_time").val();
            const duration = parseInt($("#sub_sessions_min").val());
            var type = $("#type").val();

            if (type === typeManual) {
                $("#sub_sessions_min").val('');
                $("#sub_sessions").val('');
            } else {
                if (startTime && endTime && !isNaN(duration) && duration > 0) {
                    const start = new Date(`1970-01-01T${startTime}:00`);
                    const end = new Date(`1970-01-01T${endTime}:00`);
                    // Calculate difference in milliseconds and convert to minutes
                    const diffInMinutes = (end - start) / 60000;
                    if (diffInMinutes > 0) {
                        const totalSubSessions = Math.floor(diffInMinutes / duration);
                        $("#sub_sessions").val(totalSubSessions);
                    } else {
                        $("#sub_sessions").val(0);
                    }
                } else {
                    $("#sub_sessions").val('');
                }
            }
        }

        $("#sub_sessions_min, #type").on('input', calculateSubSessions);
        $("#start_time, #end_time").on('blur', function() {
            calculateSubSessions();
        });

        function onChangeType() {
            var type = $("#type").val();
            if (type == typeManual) {
                $(".sub_sessions_min_div").hide();
                $(".sub_sessions_div").hide();
                $("#sub_sessions_min").removeAttr("required");
            } else {
                $(".sub_sessions_min_div").show();
                $(".sub_sessions_div").show();
                $("#sub_sessions_min").attr("required", "required");
            }
        }

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
