@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.mail.templates.store', Session::get('event_id')) }}" id="mailTemplateForm"
            enctype="multipart/form-data">
            @csrf
            <div class="card shadow-none mb-3">
                <div class="card-body px-0">
                    <div class="row mb-2 justify-content-between">
                        <div class="col-auto mb-4">
                            <h2 class="title-1">New email template</h2>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4">submit</button>
                                <a href="{{ route('mail.templates.index') }}" type="button"
                                    class="btn btn-secondary px-4">cancel</a>
                            </div>
                        </div>
                    </div>
                    <hr>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Template name<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="text" name="name" id="name" placeholder="Enter Template Name"
                                    value="{{ old('name') }}" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Mailjet Template ID<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <select class="form-control select2" name="template_id" id="template_id"
                                    style="width: 100%;" data-placeholder="Select Mailjet Template">

                                    <option value="">Select Mailjet Template</option>

                                    @foreach ($mailjetTemplates as $mailjetTemplate)
                                        <option value="{{ $mailjetTemplate['ID'] ?? '' }}"
                                            {{ old('template_id') == ($mailjetTemplate['ID'] ?? '') ? 'selected' : '' }}>
                                            {{ $mailjetTemplate['Name'] ?? '' }} ({{ $mailjetTemplate['ID'] ?? '' }})
                                        </option>
                                    @endforeach
                                </select>
                                <label for="template_id" class="error"></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>From (Email)<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="email" name="from" id="from" placeholder="Enter From Email"
                                    value="{{ old('from') }}" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Subject<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-10">
                                <input type="text" name="subject" id="subject" placeholder="Enter mail Subject"
                                    value="{{ old('subject') }}" class="form-control">
                            </div>
                        </div>
                    </div>
                    <div id="cc-section">
                        @php
                            $oldCc = old('cc', ['']); // Default to one empty input
                        @endphp

                        @foreach ($oldCc as $index => $ccEmail)
                            <div class="form-group cc-field">
                                <div class="row align-items-center">
                                    <div class="col-xl-2">
                                        <label>{{ $index === 0 ? 'CC' : '' }}</label>
                                    </div>
                                    <div class="col-xl-8">
                                        <input type="email" name="cc[]" class="form-control"
                                            placeholder="Enter CC Email" value="{{ $ccEmail }}">
                                    </div>
                                    <div class="col-xl-2">
                                        <button type="button" class="btn btn-danger remove-cc"
                                            style="{{ $index === 0 ? 'display:none;' : '' }}">
                                            Remove
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="form-group text-end">
                        <button type="button" id="add-cc" class="btn btn-primary">Add More CC</button>
                    </div>

                    <div id="bcc-section">
                        @php
                            $oldBcc = old('bcc', ['']); // Default to one empty input if no old values
                        @endphp

                        @foreach ($oldBcc as $index => $bcc)
                            <div class="form-group bcc-field">
                                <div class="row align-items-center">
                                    <div class="col-xl-2">
                                        <label>{{ $index === 0 ? 'BCC' : '' }}</label>
                                    </div>
                                    <div class="col-xl-8">
                                        <input type="email" name="bcc[]" class="form-control"
                                            placeholder="Enter BCC Email" value="{{ $bcc }}">
                                    </div>
                                    <div class="col-xl-2">
                                        <button type="button" class="btn btn-danger remove-bcc"
                                            style="{{ $index === 0 ? 'display:none;' : '' }}">
                                            Remove
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    <div class="form-group text-end">
                        <button type="button" id="add-bcc" class="btn btn-primary">Add More BCC</button>
                    </div>

                    <div class="form-group">
                        <div class="row">
                            <div class="col-xl-2">
                                <label>Variables</label>
                            </div>
                            <div class="col-xl-10">
                                <select class="form-control select2" name="dynamic_variables[]" multiple
                                    id="dynamic_variables" style="width: 100%;" data-placeholder="Select Variables">

                                    @foreach ($columnsDisplay as $columnName)
                                        <option value="{{ $columnName }}"
                                            {{ collect(old('dynamic_variables'))->contains($columnName) ? 'selected' : '' }}>
                                            {{ $columnName }}
                                        </option>
                                    @endforeach
                                </select>
                                <label for="dynamic_variables" class="error"></label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>Attachments</label>
                            </div>
                            <div class="col-xl-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="attachment" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" name="attachments[]" id="attachment" hidden multiple>
                                    </div>
                                    <div class="col-auto">
                                        <div class="profile-image w-32px" id="preview_images">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control select2" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                        {{ old('status') == App\Enums\StatusEnum::ACTIVE ? 'selected' : '' }}>
                                        Active
                                    </option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                        {{ old('status') == App\Enums\StatusEnum::INACTIVE ? 'selected' : '' }}>
                                        Deactive
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#mailTemplateForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                    template_id: {
                        required: true
                    },
                    from: {
                        required: true,
                        email: true
                    },
                    subject: {
                        required: true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                    template_id: {
                        required: "Please Select Mailjet Template Id"
                    },
                    from: {
                        required: "Please Enter from Mail"
                    },
                    subject: {
                        required: "Please Enter Subject"
                    },
                }
            });

            // Clone CC field
            $('#add-cc').click(function() {
                var newCC = $('.cc-field:first').clone();
                newCC.find('input').val('');
                newCC.find('.remove-cc').show();
                $('#cc-section').append(newCC);
            });

            $(document).on('click', '.remove-cc', function() {
                $(this).closest('.cc-field').remove();
            });

            // Clone BCC field
            $('#add-bcc').click(function() {
                var newBCC = $('.bcc-field:first').clone();
                newBCC.find('input').val('');
                newBCC.find('.remove-bcc').show();
                $('#bcc-section').append(newBCC);
            });

            $(document).on('click', '.remove-bcc', function() {
                $(this).closest('.bcc-field').remove();
            });
        });

        $('#attachment').change(function() {
            const file = this.files;
            $.each(file, function(key, val) {
                const size = (val.size / 1024 / 1024).toFixed(2);
                if (size > 2) {
                    alert("File size must be less then 2 MB");
                } else {
                    if (val) {
                        const fileType = val.type;
                        if (fileType.startsWith('image/')) {
                            let reader = new FileReader();
                            reader.onload = function(event) {
                                $('#preview_images').append(
                                    '<img class="img-fluid m-1" src="' +
                                    event.target.result + '">');
                            }
                            reader.readAsDataURL(val);
                        } else {
                            $('#preview_images').append(
                                '<div class="file-icon-section m-1"><i class="fas fa-file-alt"></i></div>'
                            );
                        }
                    }
                }
            });
        });
    </script>
@endsection
