@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.important.dates.update',$eventImportantDate->id) }}" id="crudForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit Date
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.important.dates.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date') }}</label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="date" id="date" class="form-control fc-datepicker"
                                    value="{{ date('d-m-Y', strtotime(old('date',$eventImportantDate->date)) ?? '') }}" autocomplete="off">
                            </div>
                        </div>
                    </div>


                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-12">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-12">
                                <textarea name="description" id="description" class="form-control ckeditor" rows="5">{{ old('description',$eventImportantDate->description) }}</textarea>
                            </div>
                            <label for="description" class="error"></label>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                    @if ($eventImportantDate->status == App\Enums\StatusEnum::ACTIVE) selected @endif>Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                    @if ($eventImportantDate->status == App\Enums\StatusEnum::INACTIVE) selected @endif>Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });

        $(".fc-datepicker").datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            yearRange: "1800:2200"
        });

        $(document).ready(function() {
            $('#crudForm').validate({
                ignore: [],
                rules: {
                    date: {
                        required: true
                    },
                    description:{
                         required: function()
                        {
                         CKEDITOR.instances.description.updateElement();
                        },
                    },
                    status: {
                        required: true,
                    },
                },
                messages: {
                    date: {
                        required: "Please Enter Name"
                    },
                    description: {
                        required: "Please Enter description"
                    },
                    status: {
                        required: "Please Select status"
                    },
                }
            });
        });
    </script>
@endsection
