@extends('layouts.master')
@section('css')
@endsection
<style>
    /* textarea{
        border: 1px solid lightgray !important;

    } */
</style>
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.exhibitors.store', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add New Exhibitor
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.exhibitors.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Company Name') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="company_name" placeholder="Enter Company Name" id="company_name"
                                    class="form-control" value="{{ old('company_name') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Sponsor Type') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="sponsor_type" placeholder="Enter Sponsor Type" id="sponsor_type"
                                    class="form-control" value="{{ old('sponsor_type') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Category') }}<span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2" data-parsley-errors-container="#error-block-category"
                                    data-placeholder="Select Category" id="event_exhibitor_category_id" name="event_exhibitor_category_id" required>
                                    <option value="">Select Category</option>
                                    @foreach ($eventExhibitorCategories as $eventExhibitorCategory)
                                        <option value="{{ $eventExhibitorCategory->id }}">
                                            {{ $eventExhibitorCategory->name }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block-category"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Email') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="email" name="email" id="email" placeholder="Enter Email" type="email"
                                    class="form-control" value="{{ old('email') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Contact') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-1 mb-2">
                                <select class="form-control select2" name="country_code" id="country_code"
                                    data-placeholder="Select Country Code">
                                    @php
                                        $countryCodes = getCountries();
                                    @endphp
                                    @if (count($countryCodes) > 0)
                                        <option value="">Select Country Code</option>
                                        @foreach ($countryCodes as $countryCode)
                                            <option @if ($countryCode->country_code == '91') selected @endif
                                                value="{{ $countryCode->country_code }}">
                                                +{{ $countryCode->country_code }}</option>
                                        @endforeach
                                    @else
                                        <option selected value="91"> +91</option>
                                    @endif
                                </select>
                            </div>
                            <div class="col-sm-4  mb-2">
                                <input type="text" value="{{ old('contact') }}" name="contact" id="contact"
                                    class="form-control" maxlength="10" minlength="10"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57' required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Hall') }}</label>
                            </div>
                            <div class="col-xl-8">
                                <select class="form-control select2" data-parsley-errors-container="#error-block"
                                    data-placeholder="Select Hall" id="event_hall_id" name="event_hall_id">
                                    <option value="">Select Hall</option>
                                    @foreach ($eventHalls as $eventHall)
                                        <option value="{{ $eventHall->id }}">
                                            {{ $eventHall->name }}</option>
                                    @endforeach
                                </select>
                                <div class="margin-top10" id="error-block"></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Stall') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="stall" placeholder="Enter stall" id="stall"
                                    class="form-control" value="{{ old('stall') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Webisite Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="website_link" data-parsley-type="url"
                                    placeholder="Enter Webisite Link" id="website_link" class="form-control"
                                    value="{{ old('website_link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Brochure Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="brochure_link" data-parsley-type="url"
                                    placeholder="Enter Brochure Link" id="brochure_link" class="form-control"
                                    value="{{ old('brochure_link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('About') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="about" id="about" class="form-control" rows="5">{{ old('about') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Connect With Us') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="connect" id="connect" class="form-control" rows="5">{{ old('connect') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Address') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="address" id="address" class="form-control" rows="5">{{ old('address') }}</textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Logo') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Logo Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" onchange="loadFile(this)" name="image" id="image"
                                            hidden="" required>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewLogo"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Logo will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
