@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Workshops ({{ $eventFormWorkshops->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('event.forms.workshops.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Venue</th>
                    <th>Reg. Fee</th>
                    <th>Max. No. of Participants</th>
                    <th>No. of Registered Participants</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventFormWorkshops) > 0)
                        @php $i = $eventFormWorkshops->perPage() * ($eventFormWorkshops->currentPage() - 1) + 1; @endphp
                        @foreach ($eventFormWorkshops as $workshop)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $workshop->name ?? '' }}</td>
                                <td>
                                    {{ $workshop->start_date ? date('d-m-Y', strtotime($workshop->start_date)) : '' }}
                                </td>
                                <td>
                                    {{ $workshop->end_date ? date('d-m-Y', strtotime($workshop->end_date)) : '' }}
                                </td>
                                <td>{{ $workshop->venue ?? '' }}</td>
                                <td>{{ $workshop->registration_fee ?? '' }}</td>
                                <td>{{ $workshop->registration_limit ?? '' }}</td>
                                <td>{{ $workshop->no_of_registration ?? '' }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($workshop->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.forms.workshops.status', $workshop->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('event.forms.workshops.status', $workshop->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('event.forms.workshops.edit', $workshop->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.forms.workshops.destroy', $workshop->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventFormWorkshops->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
