@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.forms.workshops.store',Session::get('event_id')) }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Workshop
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">Submit</button>
                        <a href="{{ route('event.forms.workshops.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Start Date') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('start_date') }}" name="start_date" id="start_date" autocomplete="off"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('End Date') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('end_date') }}" name="end_date" id="end_date" autocomplete="off"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Venue') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="venue" placeholder="Enter Venue" id="venue"
                                    class="form-control" value="{{ old('venue') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Registration Fee') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="registration_fee" placeholder="Enter Registration Fee" id="registration_fee"
                                    class="form-control" value="{{ old('registration_fee') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Max No. Of Participants') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="registration_limit" placeholder="Enter No. Of Registration" id="registration_limit"
                                    class="form-control" value="{{ old('registration_limit') }}" required>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $(".custom-validation").parsley();
        });
    </script>
@endsection
