@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.forms.slabs.update',$eventFormSlab->id) }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Slab
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">Submit</button>
                        <a href="{{ route('event.forms.slabs.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name', $eventFormSlab->name) }}" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date (Start At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('start_date', date('d-m-Y', strtotime($eventFormSlab->start_date))) }}" name="start_date" id="start_date" autocomplete="off"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Time (Start At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-timepicker" placeholder="HH:MM" type="text"
                                    autocomplete="off" value="{{ old('start_time', date('H:i', strtotime($eventFormSlab->start_time))) }}" name="start_time" id="start_time"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Date (End At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-datepicker" placeholder="DD-MM-YYYY" type="text"
                                    value="{{ old('end_date', date('d-m-Y', strtotime($eventFormSlab->end_date))) }}" name="end_date" id="end_date" autocomplete="off"
                                    required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Time (End At)') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <input class="form-control fc-timepicker" placeholder="HH:MM" type="text"
                                    autocomplete="off" value="{{ old('end_time', date('H:i', strtotime($eventFormSlab->end_time))) }}" name="end_time" id="end_time"
                                    required>
                            </div>
                        </div>
                    </div>
                    @if ($eventFormCategories->count() > 0)
                        <div class="form-group">
                            <label class="mb-2">Categories & Amounts <span class="text-danger">*</span></label>
                            @foreach ($eventFormCategories as $index => $category)
                                @php
                                    $isChecked = isset($selectedCategories[$category->id]);
                                    $amount = $selectedCategories[$category->id] ?? '';
                                @endphp
                                <div class="row align-items-center mb-2">
                                    <div class="col-sm-1 text-center">
                                        <input type="checkbox" class="form-check-input category-checkbox" id="category_{{ $index }}"
                                            name="categories[{{ $index }}][checked]" value="1" {{ $isChecked ? 'checked' : '' }}>
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="category_{{ $index }}">{{ $category->name }}</label>
                                        <input type="hidden" name="categories[{{ $index }}][id]" value="{{ $category->id }}">
                                    </div>
                                    <div class="col-sm-4">
                                        <input type="number" class="form-control amount-input" placeholder="Enter Amount"
                                            name="categories[{{ $index }}][amount]" step="0.01" min="0"
                                            id="amount_{{ $index }}" value="{{ $amount }}"
                                            {{ $isChecked ? 'required' : '' }}>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 30,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });

            $(".custom-validation").parsley();

            $('.category-checkbox').on('change', function () {
                const row = $(this).closest('.row');
                const amountInput = row.find('.amount-input');

                if ($(this).is(':checked')) {
                    amountInput.prop('required', true);
                } else {
                    amountInput.prop('required', false);
                }
            });

        });
    </script>
@endsection
