@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Pending Registration ({{ $pendingRegistrations->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Category</th>
                    <th>Workshop</th>
                    <th>Accompany Registration</th>
                    <th>No of Accompanying Person</th>
                    <th>Amount</th>
                    <th>Transaction Id</th>
                    <th>Transaction Date</th>
                    <th>Payment Receipt</th>
                    <th class="text-center">Action</th>
                </thead>
                <tbody>
                    @if (count($pendingRegistrations) > 0)
                        @php
                            $i = $pendingRegistrations->perPage() * ($pendingRegistrations->currentPage() - 1) + 1;
                        @endphp
                        @foreach ($pendingRegistrations as $pendingRegistration)
                            @php
                                $user = $pendingRegistration->user;
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $user->name ?? '-' }}</td>
                                <td>{{ $user->email ?? '-' }}</td>
                                <td>{{ $user->full_mobile_number ?? '-' }}</td>
                                <td>
                                    {{ $pendingRegistration->member_data['category_data']['category_name'] ?? '-' }}<br>
                                    {{ $pendingRegistration->member_data['category_data']['category_amount'] ?? '-' }}
                                </td>
                                <td>
                                    {{ $pendingRegistration->member_data['workshop_data']['workshop_name'] ?? ($pendingRegistration->member_data['workshop'] ?? '-') }}<br>
                                    {{ $pendingRegistration->member_data['workshop_data']['workshop_amount'] ?? '-' }}
                                </td>
                                <td>
                                    {{ $pendingRegistration->member_data['register_accompany'] ?? '-' }}<br>
                                    ({{ $pendingRegistration->member_data['accompany_data']['accompany_amount'] ?? 0 }})
                                </td>
                                <td>
                                    {{ $pendingRegistration->member_data['accompany_person'] ?? '-' }}<br>
                                    @if (isset($pendingRegistration->member_data['accompany_name']))
                                        @foreach ($pendingRegistration->member_data['accompany_name'] as $data)
                                            {{ $data }}<br>
                                        @endforeach
                                    @endif
                                </td>
                                <td>{{ $pendingRegistration->amount ?? '' }}</td>
                                <td>
                                    @if (isset($pendingRegistration->member_data['transaction_id']))
                                        {{ $pendingRegistration->member_data['transaction_id'] ?? '' }}
                                    @endif
                                </td>
                                <td>
                                    @if (isset($pendingRegistration->member_data['transaction_date']))
                                        {{ $pendingRegistration->member_data['transaction_date'] ?? '' }}
                                    @endif
                                </td>
                                <td>
                                    @if (isset($pendingRegistration->member_data['upload_payment_receipt']))
                                        @php
                                            $receiptId = $pendingRegistration->member_data['upload_payment_receipt'];
                                            $receipt = $pendingRegistration->getPaymentReceipt($receiptId);
                                        @endphp
                                        @if (isset($receipt))
                                            <div class="members-tools-button">
                                                <a href="{{ getFilePath($receipt) }}" class="btn btn-sm-icon me-3"
                                                    target="_blank">
                                                    <img src="{{ asset('assets/images/icon/show.png') }}">
                                                </a>
                                            </div>
                                        @endif
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        <div class="status status-success"
                                            onclick="sweetAlertAjax('POST','{{ route('event.forms.pending.registrations.confirmation', $pendingRegistration->id) }}', 'Are You Sure To Confirm Registration ? (once confirm it cannot be revert)')">
                                            <span class="me-1"></span> Confirm Registration
                                        </div>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $pendingRegistrations->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
