@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Event coordinators ({{ $eventCoordinators->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ route('event.coordinators.index') }}">
                            <div class="row justify-content-xxl-end">

                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="filter" class="form-control" placeholder="Name & Email"
                                        @if ($request->filter) value="{{ $request->filter }}" @endif>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                {{-- <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        export
                                    </button>
                                </div> --}}
                                <div class="col-auto mb-2">
                                    <a href="{{ route('event.coordinators.create') }}"
                                        class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead class="text-center">
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Contact</th>
                    <th>Email</th>
                    <th>Password</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventCoordinators) > 0)
                        @php $i = $eventCoordinators->perPage() * ($eventCoordinators->currentPage() - 1) + 1; @endphp
                        @foreach ($eventCoordinators as $eventCoordinator)
                            @php
                                $admin = $eventCoordinator->admin;
                            @endphp
                            <tr class="text-center">
                                <td>{{ $i++ }}</td>
                                <td>{{ $admin->name ?? '-' }}</td>
                                <td>{{ $admin->full_mobile_number ?? '-' }}</td>
                                <td>{{ $admin->email ?? '-' }}</td>
                                <td>{{ $admin->pin ?? '-' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('event.coordinators.edit', $admin->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.coordinators.destroy', $admin->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary px-3"
                                            onclick="copyToClipboard(`{{ route('event.login') }} \nName: {{ $admin->name ?? '' }} \nEvent: {{ $admin->eventManager->event->title ?? '-' }} \nEmail: {{ $admin->email ?? '' }} \nPassword: {{ $admin->pin ?? '' }}`)"><img
                                                src="{{ asset('assets/images/icon/link.png') }}">Copy credentials
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventCoordinators->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
