@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.eposter.store',Session::get('event_id')) }}" id="crudForm" class="custom-validation" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New E-Poster
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.eposter.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-xl-2">
                                    <label>{{ __('Presenter Name') }}</label>
                                </div>
                                <div class="col-xl-8">
                                    <select class="form-control select2 event_session_users"
                                        data-parsley-error-message="Please select Presenter"
                                        data-placeholder="Select Session Presenter" id="presenter_id"
                                        name="presenter_id" data-parsley-errors-container="#error-block" data-parsley-error-message="Please Select Presenter Name" required>
                                    </select>
                                    <div class="margin-top10" id="error-block"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Abstract Id') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="abstract_id" id="abstract_id" class="form-control"
                                    value="{{ old('abstract_id') }}" data-parsley-error-message="Please Enter Abstract Id" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title') }}" data-parsley-error-message="Please Enter Title" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row ">
                            <div class="col-sm-2">
                                <label>{{ __('Category') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-5 mb-2">
                                <select class="form-control select2" name="event_e_poster_category_id" id="event_e_poster_category_id"
                                    data-placeholder="Select E-Poster Category" data-parsley-errors-container="#error-block-2" data-parsley-error-message="Please Select Category" required>
                                    @if (count($eventEPosterCategories) > 0)
                                        <option value="">Select E-Poster Category</option>
                                        @foreach ($eventEPosterCategories as $eventEPosterCategory)
                                            <option value="{{ $eventEPosterCategory->id }}">{{ $eventEPosterCategory->name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                <div class="margin-top10" id="error-block-2"></div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Upload Poster') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(File Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-xl-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="poster_file" class="btn btn-primary mb-0 file-input__label">choose
                                            file</label>
                                        <input type="file" name="poster_file" id="poster_file" hidden
                                        accept="application/pdf,image/*,.doc,.docx,.csv,.xlsx" class="file-input"
                                            onchange="validateFile(this)" data-parsley-error-message="Please Upload E-Poster file" required>
                                    </div>
                                    <div class="col-auto">
                                        <div class="profile-image w-32px">
                                            <div id="previewDocumentImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px; min-width:264px; background-position: center center;background-size: cover;background-repeat: no-repeat;">
                                                E-Poster will show here
                                            </div>
                                            <iframe id="pdf-iframe" style="width: 100%; height: 600px; display: none;"></iframe>
                                        </div>
                                    </div>
                                    <label for="poster_file" id="poster_file_error" class="error"></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-4">
                                <label>{{ __('Co Authors') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <button type="button" class="btn btn-primary px-4 mb-2" id="add_ca_input"
                                    onclick="addCAInput(1)">+Add</button>
                                <div class="row" id="ca_input">
                                    <div class="row ca_input_div ca_input_1" data-id="1">
                                        <div class="col-lg-8 ca_input_1">
                                            <input type="text" value="" name="co_author[]" id="co_author_1"
                                                class="form-control mb-2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Institute / Organization') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="institute" id="institute" class="form-control"
                                    value="{{ old('institute') }}" data-parsley-error-message="Please Enter Institute / Organization" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index') }}" maxlength="3" placeholder="Enter Index"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control" id="status" name="status">
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();

            $('.event_session_users').select2({
                ajax: {
                    url: "{{ route('members.search') }}",
                    method: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data.results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 1,
            });
        });

        function showPassword() {
            var x = document.getElementById("password");
            if (x.type === "password") {
                x.type = "text";
            } else {
                x.type = "password";
            }
        }

        $(".fc-datepicker").datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
            yearRange: "1800:2200"
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            if (elementId === '#poster_file') {
                resetPreview('#previewSliderImage');
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif|\.pdf|\.doc|\.docx|\.csv|\.xlsx)$/i;
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('File size exceeds the 3MB limit. Please upload a smaller File.');
                        event.value = '';
                        return;
                    }
                    $(elementId).valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (elementId === '#poster_file') {
                            updatePreview('#previewSliderImage', e.target.result);
                        }
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

        function addCAInput(id) {
            var key = id + 1;
            $("#add_ca_input").attr('onclick', "addCAInput(" + key + ")");
            var inputHtml = `<div class="row ca_input_div ca_input_` + key + `" data-id="` + key +
                `"><div class="col-lg-8 ca_input_` + key + `">
                                    <input type="text" value="" name="co_author[]" id="co_author_` + key + `" class="form-control mb-2">
                                </div>
                                <div class="col-lg-4 ca_input_` + key +
                `">
                                    <button type="button" class="btn btn-outline-primary" onclick="removeCAInput(` +
                key + `)">- Remove</button>
                                </div></div>`;
            $('#ca_input').append(inputHtml);
        }

        function removeCAInput(id) {
            $('.ca_input_' + id).remove();
            $(".ca_input_div").each(function(key, value) {
                key++;
                var dataId = $(this).data('id');
                if (key != dataId) {
                    $(this).removeClass('ca_input_' + dataId);
                    $(this).addClass('ca_input_' + key);
                    $('.ca_input_' + dataId).find('input').attr('id', 'co_author_' + key + '');
                    $('.ca_input_' + dataId).find('button').attr('onclick', 'removeCAInput(' + key +
                        ')');
                    $('.ca_input_' + dataId).addClass('ca_input_' + key);
                    $('.ca_input_' + dataId).removeClass('ca_input_' + dataId);
                    $(this).data('id', key);
                }
                $("#add_ca_input").attr('onclick', "addCAInput(" + key + ")");
            })
        }

        function validateFile(input) {
            // Check if a file was selected
            var file = input.files[0];
            if (!file) {
                $("#poster_file_error").html("Please select a file.");
                document.getElementById("previewDocumentImage").style.backgroundImage = 'none';
                document.getElementById("previewDocumentImage").innerHTML = 'E-Poster Photo will show here';
                return;
            }

            // Get file extension
            var ext = file.name.split(".");
            ext = ext[ext.length - 1].toLowerCase();
            var arrayExtensions = ["jpg", "jpeg", "png", "pdf", "gif", "doc", "docx", "csv", "xlsx"];
            if (arrayExtensions.lastIndexOf(ext) == -1) {
                $("#poster_file_error").html("File must be a PDF or an image (JPG, JPEG, PNG, GIF, DOC, DOCX, CSV, XLSX).");
                $("#poster_file").val("");
                // Clear preview if invalid file
                document.getElementById("previewDocumentImage").style.backgroundImage = 'none';
                document.getElementById("previewDocumentImage").innerHTML = 'E-Poster will show here';
            } else {
                $("#poster_file_error").html('');

                if (ext === "pdf") {
                    document.getElementById("previewDocumentImage").innerHTML = '<i class="fas fa-file-pdf" style="font-size: 80px; color: red;"></i>';
                    document.getElementById("previewDocumentImage").style.backgroundImage = 'none';
                } else if (["doc", "docx"].includes(ext)) {
                    // Display a placeholder for DOC files
                    document.getElementById("previewDocumentImage").innerHTML = '<i class="fas fa-file-word" style="font-size: 80px; color: blue;"></i>';
                    document.getElementById("previewDocumentImage").style.backgroundImage = 'none';
                } else if (ext === "csv" || ext === "xlsx") {
                    // Display a placeholder for CSV and XLSX files
                    document.getElementById("previewDocumentImage").innerHTML = '<i class="fas fa-file-excel" style="font-size: 80px; color: green;"></i>';
                    document.getElementById("previewDocumentImage").style.backgroundImage = 'none';
                } else {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        document.getElementById("previewDocumentImage").style.backgroundImage = 'url(' + e.target.result + ')';
                        document.getElementById("previewDocumentImage").innerHTML = '';
                    };
                    reader.readAsDataURL(file);
                }
            }
        }
    </script>
@endsection
