@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Event Days ({{ $eventDays->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <button type="button" class="btn btn-outline-primary px-4" onclick="addEventDay()">
                                        + Add Event Day
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Date</th>
                    <th>Text Color</th>
                    <th>Background Color</th>
                    <th>Venue</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventDays) > 0)
                        @php $i = $eventDays->perPage() * ($eventDays->currentPage() - 1) + 1; @endphp
                        @foreach ($eventDays as $eventDay)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventDay->name ?? '' }}</td>
                                <td>{{ $eventDay->date ? getTimezoneDateTime($eventDay->date, 'd-m-Y') : '-' }}
                                </td>
                                <td>
                                    {{ $eventDay->text_color }}
                                    <div class="color" style="background: {{ $eventDay->text_color ?? '' }}; ">
                                    </div>
                                </td>
                                <td>
                                    {{ $eventDay->bg_color }}
                                    <div class="color" style="background: {{ $eventDay->bg_color ?? '' }}; ">
                                    </div>
                                </td>
                                <td><a href="{{ route('event.venues.index', $eventDay->id) }}"
                                        class="btn btn-sm btn-primary" style="width: 115px">View Venue
                                        ({{ $eventDay->eventVenues->count() }})</a></td>
                                <td>
                                    <div class="members-tools-button">
                                        <a class="btn btn-sm-icon me-3" data-id="{{ $eventDay->id }}"
                                            data-name="{{ $eventDay->name }}"
                                            data-date="{{ getTimezoneDateTime($eventDay->date, 'd-m-Y') }}"
                                            data-text-color="{{ $eventDay->text_color }}"
                                            data-bg-color="{{ $eventDay->bg_color }}"
                                            onclick="editEventDay(this)">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.days.destroy', $eventDay->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventDays->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="addQuestionsModal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Edit Event Day</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" class="custom-validation" action="" id="editEventDayForm"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="">Name</label>
                                <input type="text" name="name" id="name" placeholder="Enter Name"
                                    class="form-control" data-parsley-error-message="Name is required" required>
                            </div>
                            <div class="col-md-12">
                                <label for="">Date</label>
                                <input class="form-control fc-datepicker" placeholder="Select Date" type="text"
                                    name="date" id="date" data-parsley-error-message="Date is required"
                                    autocomplete="off" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="text_colorpicker">Text Color</label>
                                <input class="form-control text_color" type="color" id="text_colorpicker"
                                    name="text_color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff"
                                    required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="text_color">Text Hexcode</label>
                                <input class="form-control text_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" id="text_color"
                                    required></input>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="bg_colorpicker">Background Color</label>
                                <input class="form-control bg_color" type="color" id="bg_colorpicker" name="bg_color"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="bg_color">Background Hexcode</label>
                                <input class="form-control bg_color" type="text" placeholder="#ffffff"
                                    pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="#ffffff" id="bg_color"
                                    required></input>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">submit</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('#text_colorpicker').on('input', function() {
                $('#text_color').val(this.value);
            });
            $('#text_color').on('input', function() {
                $('#text_colorpicker').val(this.value);
            });

            $('#bg_colorpicker').on('input', function() {
                $('#bg_color').val(this.value);
            });
            $('#bg_color').on('input', function() {
                $('#bg_colorpicker').val(this.value);
            });

            $('#addQuestionsModal').on('hidden.bs.modal', function() {
                $('#editEventDayForm')[0].reset();
            });
        });

        function addEventDay() {
            var eventId = "{{ Session::get('event_id') }}";
            var url = "{{ route('event.days.store', ':eventId') }}";
            url = url.replace(':eventId', eventId);
            $("#model-title").html("Add Event Day");
            $("#date").val("");
            $("#name").val("");
            $("#editEventDayForm").find('input[name="_method"]').val('POST');
            $("#editEventDayForm").attr("action", url);
            $("#addQuestionsModal").modal("show");
        }

        function editEventDay(button) {
            var eventDayId = $(button).data('id');
            var name = $(button).data('name');
            var date = $(button).data('date');
            var txtcolor = $(button).data('text-color').trim();
            var bgcolor = $(button).data('bg-color').trim();
            var url = "{{ route('event.days.update', ':eventDayId') }}";
            url = url.replace(':eventDayId', eventDayId);
            $("#model-title").html("Edit Event Day");
            $("#date").val(date);
            $("#name").val(name);
            $(".text_color").val(txtcolor);
            $(".bg_color").val(bgcolor);
            $("#editEventDayForm").find('input[name="_method"]').val('PUT');
            $("#editEventDayForm").attr("action", url);
            $("#addQuestionsModal").modal("show");
        }
    </script>
@endsection
