@extends('layouts.master')
@section('css')
    <style>
        .color {
            height: 20px;
            width: 60px;
            border: 1px solid #000;
        }
    </style>
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Contact Us Type ({{ $eventContactUsTypes->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <button type="button" class="btn btn-outline-primary px-4" onclick="addContactUsType()">
                                        + Add Contact Us Type
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Index</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventContactUsTypes) > 0)
                        @php $i = $eventContactUsTypes->perPage() * ($eventContactUsTypes->currentPage() - 1) + 1; @endphp
                        @foreach ($eventContactUsTypes as $eventContactUsType)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $eventContactUsType->name ?? '' }}</td>
                                <td>{{ $eventContactUsType->index ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a class="btn btn-sm-icon me-3" data-id="{{ $eventContactUsType->id }}"
                                            data-name="{{ $eventContactUsType->name }}"
                                            data-index="{{ $eventContactUsType->index }}"
                                            onclick="editContactUsType(this)">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.contact.us.type.destroy', $eventContactUsType->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventContactUsTypes->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="addEventContactUsTypesModal" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Add Contact Us Type</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" class="custom-validation" action="" id="editEventContactUsTypesForm"
                        enctype="multipart/form-data">
                        @csrf
                        @method('POST')
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label for="">Name</label>
                                <input type="text" name="name" id="name" placeholder="Enter Name"
                                    class="form-control" data-parsley-error-message="Name is required" required>
                            </div>
                            <div class="col-md-12 mb-3">
                                <label for="">Index</label>
                                <input type="text" name="index" id="index" placeholder="Enter index"
                                    class="form-control" data-parsley-type="integer" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">submit</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('#addEventContactUsTypesModal').on('hidden.bs.modal', function() {
                $('#editEventContactUsTypesForm')[0].reset();
            });
        });

        function addContactUsType() {
            var eventId = "{{ Session::get(key: 'event_id') }}";
            var url = "{{ route('event.contact.us.type.store', ':eventId') }}";
            url = url.replace(':eventId', eventId);
            $("#model-title").html("Add Contact Us Type");
            $("#name").val("");
            $("#index").val("");
            $("#editEventContactUsTypesForm").find('input[name="_method"]').val('POST');
            $("#editEventContactUsTypesForm").attr("action", url);
            $("#addEventContactUsTypesModal").modal("show");
        }

        function editContactUsType(button) {
            var eventContactUsTypes = $(button).data('id');
            var name = $(button).data('name');
            var index = $(button).data('index');
            var url = "{{ route('event.contact.us.type.update', ':eventContactUsTypes') }}";
            url = url.replace(':eventContactUsTypes', eventContactUsTypes);
            $("#model-title").html("Edit Contact Us Type");
            $("#name").val(name);
            $("#index").val(index);
            $("#editEventContactUsTypesForm").find('input[name="_method"]').val('PUT');
            $("#editEventContactUsTypesForm").attr("action", url);
            $("#addEventContactUsTypesModal").modal("show");
        }
    </script>
@endsection
