@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.app.dashboard.sponsor.links.update', $eventDashboardSponsorLink->id) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Dashboard Sponsor Link
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.app.dashboard.sponsor.links.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name', $eventDashboardSponsorLink->name) }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" placeholder="Enter Link" id="link"
                                    class="form-control" value="{{ old('link', $eventDashboardSponsorLink->link) }}" data-parsley-type="url" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Image') }}<span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" onchange="loadFile(this)" name="image" id="image"
                                            hidden="">
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewLogo"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;background-image: url({{ getFilePath($eventDashboardSponsorLink->image->path ?? null) }});background-position: center center;background-size: cover;background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="index" id="index" placeholder="Enter index"
                                    class="form-control" data-parsley-type="integer" maxlength="3"
                                    value="{{ old('index', $eventDashboardSponsorLink->index) }}"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
