@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('event.activities.store', Session::get('event_id')) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add New Activity
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.activities.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Images') }}</label> <span class="text-danger">*</span>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-sm-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="images" class="btn btn-primary mb-0">Choose file</label>
                                        <input type="file" name="images[]" id="images" hidden class="filestyle"
                                            onchange="loadFiles(this)" accept="image/*" multiple required>
                                        <label for="images" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-12 mt-3">
                                        <div id="previewImage" class="bg-light d-flex align-items-center flex-wrap">
                                            {{-- @foreach ($images as $image)
                                                <div class="position-relative mx-2 mb-3"
                                                    id="singer-index-{{ $image->id }}"
                                                    style="height:100px; width:100px;">
                                                    <div class="profile-image bg-dark d-flex align-items-center justify-content-center"
                                                        style="height:100px; width:100px;
                                                        @if (checkFileExist($image->path ?? '')) background-image:url({{ getFilePath($image->path ?? '') }}); @endif
                                                                background-position: center center;
                                                                background-size: cover;
                                                                background-repeat: no-repeat;">
                                                    </div>
                                                    <button
                                                        class="remove-image-btn position-absolute top-0 end-0 btn btn-sm btn-danger p-1"
                                                        type="button" style="margin: -5px; cursor: pointer;"
                                                        onclick="sweetAlertAjax('delete', '{{ route('event.aboutus.media.delete', ['media' => $image->id]) }}', 'Are you sure you want to delete this image?', 'singer-index-{{ $image->id }}')">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </div>
                                            @endforeach --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="name" placeholder="Enter Name" id="name"
                                    class="form-control" value="{{ old('name') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link') }}
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" data-parsley-type="url" placeholder="Enter Link"
                                    id="link" class="form-control" value="{{ old('link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index') }}" maxlength="3" placeholder="Enter Index"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <textarea name="description" id="description" class="form-control" placeholder="Enter Description" rows="5">{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFiles = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            console.log(elementId);


            if (elementId === '#images') {
                $('#previewImage .new-image-preview').remove(); // Reset previously selected preview images
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg, .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $(elementId).valid();
                    var currentImagesCount = $('#previewImage div').length;
                    var newFilesCount = event.files.length;

                    if (currentImagesCount + newFilesCount > 10) {
                        alert('You can upload a maximum of 10 images.');
                        event.value = '';
                        return;
                    }
                    var isValid = true;
                    $(event.files).each(function(i, file) {
                        if (!allowedExtensions.exec(file.name)) {
                            alert('Please upload files with extensions .jpeg, .jpg, .png only.');
                            event.value = '';
                            isValid = false;
                            return false;
                        }
                        if (file.size > maxFileSize) {
                            alert( file.name +' size exceeds the 3MB limit. Please upload a smaller Image.');
                            event.value = '';
                            return;
                        }
                    });

                    if (!isValid) {
                        return;
                    }

                    $(event.files).each(function(i, file) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            if (elementId === '#images') {
                                var galleryIndex = $('#previewImage div').length;
                                galleryIndex = galleryIndex + 1;

                                var imageContainer = $('<div>', {
                                    id: 'gallery_' + galleryIndex,
                                    class: 'image-preview-container new-image-preview position-relative mx-2 mb-3',
                                    style: 'height:100px; width:100px; margin:5px; background-position: center center; background-size: cover; background-repeat: no-repeat; background-image: url(' +
                                        e.target.result + ');'
                                });

                                var crossButton = $('<button>', {
                                    type: 'button',
                                    class: 'remove-image-btn position-absolute top-0 end-0 btn btn-sm btn-danger p-1',
                                    html: '<i class="fas fa-trash-alt"></i>',
                                    style: 'margin: -5px; cursor: pointer;',
                                    click: function() {
                                        $(this).parent().remove();
                                    }
                                });

                                imageContainer.append(crossButton);

                                $('#previewImage').append(imageContainer);

                                $('#previewImage').css({
                                    'height': 'auto',
                                    'width': '500%'
                                });
                            }
                        };
                        reader.readAsDataURL(file);
                    });
                }
            }
        };

        $("#event_date").on("change", function() {
            $("#event_date").valid();
        });
    </script>
@endsection
