@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('event.aboutus.button.store',Session::get('event_id')) }}" id="buttonForm" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New Button
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('event.aboutus.index') }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="link" id="link" class="form-control"
                                    value="{{ old('link') }}">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ old('index') }}" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>

    <script>
        $(document).ready(function() {
            $('#buttonForm').validate({
                ignore: [],
                rules: {
                    name: {
                        required: true
                    },
                    link: {
                        required: true,
                        url:true
                    },
                },
                messages: {
                    name: {
                        required: "Please Enter Name"
                    },
                    link: {
                        required: "Please Enter Link"
                    },
                }
            });
        });
    </script>
@endsection
