@extends('layouts.master')

@section('content')
    <div class="card">
        <div class="card-body">
            <form method="POST" action="{{ route('association.settings.store') }}" enctype="multipart/form-data">
                @csrf
                @method('post')

                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Site Settings</h1>
                        </div>
                        <div class="col-auto">
                            <div class="d-flex gap-3">
                                <button type="submit" class="btn btn-primary px-4 register_btn">submit</button>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Name') }}</label>
                        </div>
                        <div class="col-sm-10">
                            <input type="text" name="name" id="name"
                                value="{{ $associationSetting->name ?? null }}" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Logo') }}</label>
                            <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                        </div>
                        <div class="col-sm-10">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <label for="logo" class="btn btn-primary mb-0">choose
                                        file</label>
                                    <input type="file" name="logo" id="logo" hidden class="filestyle"
                                        onchange="loadFile(this, 'previewSliderImage')">
                                    <label for="logo" class="error" style="display: none;"></label>
                                </div>
                                <div class="col-sm-4">
                                    <div class="profile-image w-32px">
                                        <div id="previewSliderImage"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;
                                            @if (checkFileExist($associationSetting->media->path ?? '')) background-image:url({{ getFilePath($associationSetting->media->path ?? '') }}); @endif
                                            background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Badge') }}</label>
                            <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                        </div>
                        <div class="col-sm-10">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <label for="badge" class="btn btn-primary mb-0">choose
                                        file</label>
                                    <input type="file" name="badge" id="badge" hidden class="filestyle"
                                        onchange="loadFile(this, 'previewBadge')">
                                    <label for="badge" class="error" style="display: none;"></label>
                                </div>
                                <div class="col-sm-4">
                                    <div class="profile-image w-32px">
                                        <div id="previewBadge"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;
                                            @if (checkFileExist($associationSetting->badge->path ?? '')) background-image:url({{ getFilePath($associationSetting->badge->path ?? '') }}); @endif
                                            background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('ID Card') }}</label>
                            <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                        </div>
                        <div class="col-sm-10">
                            <div class="row align-items-center">
                                <div class="col-auto">
                                    <label for="card" class="btn btn-primary mb-0">choose
                                        file</label>
                                    <input type="file" name="card" id="card" hidden class="filestyle"
                                        onchange="loadFile(this, 'previewCard')">
                                    <label for="badge" class="error" style="display: none;"></label>
                                </div>
                                <div class="col-sm-4">
                                    <div class="profile-image w-32px">
                                        <div id="previewCard"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;
                                            @if (checkFileExist($associationSetting->card->path ?? '')) background-image:url({{ getFilePath($associationSetting->card->path ?? '') }}); @endif
                                            background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">OTP Verification </h1>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Member Login by OTP') }}</label>
                        </div>
                        <div class="col-sm-4">
                            <select name="enable_otp_login" class="form-control select2" id="enable_otp_login">
                                <option value="{{ \App\Enums\AssociationEnum::YES }}"
                                    {{ old('enable_otp_login', $associationSetting->enable_otp_login ?? null) == \App\Enums\AssociationEnum::YES ? 'selected' : '' }}>
                                    Yes
                                </option>
                                <option value="{{ \App\Enums\AssociationEnum::NO }}"
                                    {{ old('enable_otp_login', $associationSetting->enable_otp_login ?? null) == \App\Enums\AssociationEnum::NO ? 'selected' : '' }}>
                                    No
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Send OTP to Mail') }}</label>
                        </div>
                        <div class="col-sm-4">
                            <select name="otp_via_email" class="form-control select2" id="otp_via_email">
                                <option value="{{ \App\Enums\AssociationEnum::YES }}"
                                    {{ old('otp_via_email', $associationSetting->otp_via_email ?? null) == \App\Enums\AssociationEnum::YES ? 'selected' : '' }}>
                                    Yes
                                </option>
                                <option value="{{ \App\Enums\AssociationEnum::NO }}"
                                    {{ old('otp_via_email', $associationSetting->otp_via_email ?? null) == \App\Enums\AssociationEnum::NO ? 'selected' : '' }}>
                                    No
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-2">
                            <label>{{ __('Send OTP to Whatsapp') }}</label>
                        </div>
                        <div class="col-sm-4">
                            <select name="otp_via_whatsapp" class="form-control select2" id="otp_via_whatsapp">
                                <option value="{{ \App\Enums\AssociationEnum::YES }}"
                                    {{ old('otp_via_whatsapp', $associationSetting->otp_via_whatsapp ?? null) == \App\Enums\AssociationEnum::YES ? 'selected' : '' }}>
                                    Yes
                                </option>
                                <option value="{{ \App\Enums\AssociationEnum::NO }}"
                                    {{ old('otp_via_whatsapp', $associationSetting->otp_via_whatsapp ?? null) == \App\Enums\AssociationEnum::NO ? 'selected' : '' }}>
                                    No
                                </option>
                            </select>
                        </div>
                    </div>
                </div>

                <hr>
                <div class="member-header shadow-none p-0 mb-4">
                    <div class="row justify-content-between">
                        <div class="col-auto">
                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Code Of Ethics </h1>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-12">
                            <label>{{ __('About') }}</label>
                        </div>
                        <div class="col-sm-12">
                            <textarea name="about" id="about" class="form-control ckeditor">{{ $associationSetting->about ?? null }}</textarea>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-12">
                            <label>{{ __('Vision') }}</label>
                        </div>
                        <div class="col-sm-12">
                            <textarea name="vision" id="vision" class="form-control ckeditor">{{ $associationSetting->vision ?? null }}</textarea>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="row align-items-center">
                        <div class="col-sm-12">
                            <label>{{ __('Mission') }}</label>
                        </div>
                        <div class="col-sm-12">
                            <textarea name="mission" id="mission" class="form-control ckeditor">{{ $associationSetting->mission ?? null }}</textarea>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>

    <script>
        $('#addSettingForm').validate({
            ignore: [],
            rules: {
                key: {
                    required: true,
                },
                value: {
                    required: true,
                },
            },
            messages: {
                key: {
                    required: "Please Add Key"
                },
                value: {
                    required: "Please Add value"
                },
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(input, previewId) {
            const $preview = $('#' + previewId);
            $preview.css({
                'background-image': 'none',
                'background-position': 'center center',
                'background-size': 'cover',
                'background-repeat': 'no-repeat'
            }).html('');

            var filePath = input.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;

            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload a file with extensions .jpeg, .jpg, .png only.');
                input.value = '';
                return;
            }

            if (input.files && input.files[0]) {
                var file = input.files[0];
                if (file.size > maxFileSize) {
                    alert('Image size exceeds the 3MB limit. Please upload a smaller image.');
                    input.value = '';
                    return;
                }

                var reader = new FileReader();
                reader.onload = function(e) {
                    $preview.css('background-image', 'url(' + e.target.result + ')');
                };
                reader.readAsDataURL(file);
            }
        };
    </script>
@endsection
