@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Posts ({{ $posts->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>User Name</th>
                    <th>Contact</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($posts) > 0)
                        @php $i = $posts->perPage() * ($posts->currentPage() - 1) + 1; @endphp
                        @foreach ($posts as $post)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $post->user->name ?? null }}</td>
                                <td>{{ $post->user->contact ?? null }}</td>
                                <td>{{ $post->title ?? null }}</td>
                                <td>{{ $post->description ?? null }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('association.posts.destroy', $post->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $posts->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
