@extends('layouts.master')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" type="text/css">
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        {{ Str::limit($poll->question, 20, '...') }}
                                        <br> Poll Options ({{ $pollOptions->total() }})
                                    </h2>
                                </div>
                                <form method="get" action="{{ url()->current() }}">
                                    <div class="col-auto mb-2">
                                        <div class="d-flex gap-3">
                                            <a href="{{ route('polls.options.create', $poll->id) }}"
                                                class="btn btn-outline-primary px-4">+
                                                Create Poll Option</a>
                                            <a href="{{ route('polls.index') }}" type="button"
                                                class="btn btn-light px-4">cancel</a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Type</th>
                    <th>Option</th>
                    <th class="text-center">Answer</th>
                    <th>Vote Count</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($pollOptions) > 0)
                        @php $i = $pollOptions->perPage() * ($pollOptions->currentPage() - 1) + 1; @endphp
                        @foreach ($pollOptions as $pollOption)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if ($pollOption->type == App\Enums\PollOptionTypeEnum::TEXT)
                                        Text
                                    @elseif ($pollOption->type == App\Enums\PollOptionTypeEnum::IMAGE)
                                        Image
                                    @endif
                                <td>
                                    @if ($pollOption->type == App\Enums\PollOptionTypeEnum::IMAGE)
                                        @if ($pollOption->image)
                                            <div class=" w-25">
                                                <a class="image-popup-no-margins mr-2"
                                                    href="{{ getFilePath($pollOption->image->path ?? null) }}">
                                                    <img src="{{ getFilePath($pollOption->image->path) }}"
                                                        class="img-responsive" style="width:50px;"></a>
                                            </div>
                                        @endif
                                    @else
                                        {{ $pollOption->option }}
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($pollOption->answer_type == App\Enums\PollOptionAnswerTypeEnum::RIGHT)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.options.type', $pollOption->id) }}', 'Are You Sure To Change?')">
                                                <span class="me-1"></span> Right
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('polls.options.type', $pollOption->id) }}', 'Are You Sure To Change?')">
                                                <span class="me-1"></span> Wrong
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>{{ $pollOption->vote_count ?? 0 }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('polls.options.edit', $pollOption->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('polls.options.destroy', $pollOption->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $pollOptions->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
    <script>
        $(".image-popup-no-margins").magnificPopup({
            type: "image",
            closeOnContentClick: !0,
            closeBtnInside: !1,
            fixedContentPos: !0,
            mainClass: "mfp-no-margins mfp-with-zoom",
            image: {
                verticalFit: !0
            },
            zoom: {
                enabled: !0,
                duration: 300
            }
        });
    </script>
@endsection
