@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('polls.options.update', $pollOption->id) }}"
            id="crudForm" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1"> {{ Str::limit($poll->question, 20, '...') }} </h2>
                    <h2 class="title-1">Edit Poll Option
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">Submit</button>
                        <a href="{{ route('polls.options.index', $poll->id) }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('type') }}</label>
                            </div>
                            <div class="col-xl-5">
                                <select class="form-control select2" id="type" name="type">
                                    <option value="{{ App\Enums\PollOptionTypeEnum::TEXT }}"
                                        @if ($pollOption->type == App\Enums\PollOptionTypeEnum::TEXT) selected @endif>Text</option>
                                    <option value="{{ App\Enums\PollOptionTypeEnum::IMAGE }}"
                                        @if ($pollOption->type == App\Enums\PollOptionTypeEnum::IMAGE) selected @endif>Image</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    {{-- <div hidden class="form-group image-option">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Image') }} <span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-xl-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose
                                            file</label>
                                        <input type="file" name="image" id="image" hidden class="filestyle"
                                            onchange="loadFile(this)" accept=".jpg, .jpeg, .png">
                                        <label for="image" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="profile-image w-32px">
                                            <div id="previewSliderImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px;  background-position: center center;background-size: cover;background-repeat: no-repeat;">
                                                Image will show here
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}

                    <div hidden class="form-group image-option">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Image') }}</label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-sm-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose
                                            file</label>
                                        <input type="file" name="image" id="image" hidden class="filestyle"
                                            onchange="loadFile(this)" accept=".jpg, .jpeg, .png">
                                        <label for="image" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="profile-image w-32px">
                                            <div id="previewSliderImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px;
                                                @if (checkFileExist($pollOption->image->path ?? null)) background-image:url({{ getFilePath($pollOption->image->path) }}); @endif
                                                background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div hidden class="form-group text-option">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Option') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="option" placeholder="Enter Option" id="option"
                                    class="form-control"
                                    value="{{ old('option', $pollOption->type === App\Enums\PollOptionTypeEnum::TEXT ? $pollOption->option : '') }}">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.2/standard/ckeditor.js"></script>
    <script>
        $(document).ready(function() {
            $('.fc-datepicker').datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });

            $('.fc-timepicker').timepicker({
                timeFormat: 'HH:mm',
                interval: 30,
                startTime: '08:00',
                dynamic: true,
                dropdown: true,
                scrollbar: true,
                zaddress: 9999999
            });

            $(".custom-validation").parsley();
            $('#type').trigger('change');

        });

        $('#type').on('change', function() {
            var selectedValue = $(this).val();
            if (selectedValue == "{{ App\Enums\PollOptionTypeEnum::IMAGE }}") {
                $('.image-option').removeAttr('hidden');
                $('.text-option').attr('hidden', true);
                $('#question').removeAttr('required');
                $('#question').val('');
            } else {
                $('.text-option').removeAttr('hidden');
                $('.image-option').attr('hidden', true);
                $('#question').attr('required', true);
                $('#image').removeAttr('required');
                $('#image').val('');
            }
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            if (elementId === '#image') {
                resetPreview('#previewSliderImage');
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $(elementId).valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (elementId === '#image') {
                            updatePreview('#previewSliderImage', e.target.result);
                        }
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
