@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" action="{{ route('past.office.bearers.store') }}" enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">New Past Office Bearers</h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('past.office.bearers.index') }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Year') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="year" id="year" class="form-control fc-datepicker"
                                    autocomplete="off" value="{{ old('year') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('President') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control select2" name="president_id">
                                    <option value="">Select User</option>
                                </select>
                            </div>
                        </div>
                    </div>


                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Vice President') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control select2" name="vice_president_id">
                                    <option value="">Select User</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Secretary') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control select2" name="secretary_id">
                                    <option value="">Select User</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Treasurer') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <select class="form-control select2" name="treasurer_id">
                                    <option value="">Select User</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                ajax: {
                    url: "{{ route('members.search') }}",
                    method: "GET",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term
                        };
                    },
                    processResults: function(data) {
                        return {
                            results: data.results
                        };
                    },
                    cache: true
                },
                minimumInputLength: 1,
            });
        });

        $(".fc-datepicker").datepicker({
            dateFormat: "yy",
            changeYear: true,
            showButtonPanel: true,
            beforeShow: function(input, inst) {
                $(inst.dpDiv).find(".ui-datepicker-calendar").hide();
            },
            onClose: function(dateText, inst) {
                const year = inst.selectedYear;
                $(this).val(year);
            },
            yearRange: "1800:2200"
        });

        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            let elementId = event.getAttribute("id");
            elementId = '#' + elementId;
            if (elementId === '#notice_image') {
                resetPreview('#previewNoticeImage');
            }

            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $(elementId).valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        if (elementId === '#notice_image') {
                            updatePreview('#previewNoticeImage', e.target.result);
                        }
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
