@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Notification List ({{ $notifications->total() }})
                                    </h2>
                                </div>
                                <form method="get" action="{{ url()->current() }}">
                                    <div class="col-auto mb-2">
                                        <a href="{{ route('notifications.create') }}"
                                            class="btn btn-outline-primary px-4">+
                                            Send Notification</a>
                                    </div>
                                </form>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Title</th>
                    <th>Body</th>
                </thead>
                <tbody>
                    @if (count($notifications) > 0)
                        @php $i = $notifications->perPage() * ($notifications->currentPage() - 1) + 1; @endphp
                        @foreach ($notifications as $notification)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $notification->title ?? '' }}</td>
                                <td>{{ $notification->body ?? '' }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('notifications.destroy', $notification->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $notifications->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
