@extends('layouts.master')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/magnific-popup.css') }}" type="text/css">
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Members ({{ $members->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ route('members.index') }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" data-placeholder="Role" name="role_id"
                                        data-placeholder="Select Role">
                                        <option value="all">All</option>
                                        @foreach ($memberRoles as $memberRole)
                                            <option value="{{ $memberRole->id }}"
                                                @if (request()->role_id == $memberRole->id) selected @endif>
                                                {{ $memberRole->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="filter" class="form-control" placeholder="Name & Email"
                                        @if ($request->filter) value="{{ $request->filter }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="contact" class="form-control" placeholder="Contact"
                                        @if ($request->contact) value="{{ $request->contact }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="registration_number" class="form-control" placeholder="Registration Number"
                                        value="{{ $request->registration_number }}" >
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        export
                                    </button>
                                </div>
                                <div class="col-auto mb-2">
                                    <a href="{{ route('members.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="button" class="btn btn-primary px-4 import-btn" data-toggle="modal"
                                        data-target="#upload">
                                        Import
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead class="text-center">
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Member code</th>
                    <th>Registration Number</th>
                    <th>Contact</th>
                    <th>Role</th>
                    <th>Image</th>
                    <th>Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($members) > 0)
                        @php $i = $members->perPage() * ($members->currentPage() - 1) + 1; @endphp
                        @foreach ($members as $row)
                        @php
                            $associationUser = getAssociationUser($row, $association);
                        @endphp
                            <tr class="text-center">
                                <td>{{ $i++ }}</td>
                                <td>{{ $row->name ?? '-' }}</td>
                                <td>{{ $row->email ?? '-' }}</td>
                                <td>{{ $associationUser->user_member_id ?? $row->unique_id ?? '-' }}</td>
                                <td>{{ $row->memberDetail->registration_number ?? '-' }}</td>
                                <td>{{ $row->contact ?? '-' }}</td>
                                <td>{{ $row->memberDetail->role->name ?? '-' }}</td>
                                <td>
                                    @if ($row->memberDetail->image)
                                        <div class=" w-25">
                                            <a class="image-popup-no-margins mr-2"
                                                href="{{ getFilePath($row->memberDetail->image->path) }}">
                                                <img src="{{ getFilePath($row->memberDetail->image->path) }}"
                                                    class="img-responsive" style="width:50px;"></a>
                                        </div>
                                    @endif
                                </td>

                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($row->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('members.status', $row->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('members.status', $row->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('members.edit', $row->id) }}" class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('members.destroy', $row->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>

                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sendTemplate({{ $row->id }} , {{ $row->country_code }}, {{ $row->contact }})">send
                                            message
                                        </button>

                                        @if ($request->dev == '1')
                                            <a href="{{ route('members.view', $row->id) }}" class="btn btn-sm-icon me-3"
                                                value="{{ $request->dev }}">
                                                <img src="{{ asset('assets/images/icon/show.png') }}">
                                            </a>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $members->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade sendTemplateModalClass" id="" tabindex="-1" aria-labelledby="sendTemplateLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="sendTemplateLabel">New Message</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <img class="img-fluid" src="{{ asset('assets/images/icon/close.png') }}">
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('bulk.messages.index') }}" id="sendTemplateForm">
                        @csrf
                        <input type="hidden" name="country_code" id="country_code">
                        <input type="hidden" name="mobile" id="mobile">
                        <div class="form-group">
                            <div class="row align-items-center">
                                <div class="col-sm-4">
                                    <label>{{ __('Template Name') }}<span class="text-danger">*</span></label>
                                </div>
                                <div class="col-sm-8">
                                    <select class="select2 template-select2" style="width: 100%;"
                                        data-placeholder="Select a template" name="template_name" id="template_name">
                                        <option value="">Select Template</option>
                                        @foreach (messageTemplateQuery() as $template)
                                            <option value="{{ $template['id'] }}">{{ $template['name'] }}</option>
                                        @endforeach
                                    </select>
                                    <label for="template_name" class="error" style="display: none;"></label>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary px-5 mt-3">submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="upload" tabindex="-1" aria-labelledby="uploadModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="uploadModalLabel">Upload File</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="uploadForm" class="custom-validation"
                        action="{{ route('members.import', Auth::user()->id) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="mb-3">
                            <label for="fileInput" class="form-label">Choose file</label>
                            <input type="file" onchange="checkValidation(this)" name="file" id="fileInput"
                                class="form-control fileUpload" required>
                        </div>
                    </form>
                    <div class="">
                        Download Member Sample File From Here: <b><a
                                href="{{ asset('assets/excel/member_details.xlsx') }}" download="">Member
                                File</a></b>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" form="uploadForm" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.magnific-popup.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#sendTemplateForm').validate({
                ignore: [],
                rules: {
                    template_name: {
                        required: true
                    },
                    mobile_number: {
                        required: true
                    },
                },
                messages: {
                    template_name: {
                        required: "Please Select Template"
                    },
                    mobile_number: {
                        required: "Please Enter Mobile Number"
                    },
                },
                submitHandler: function(form) {
                    swal({
                        title: 'Are you sure want to send template',
                        icon: "warning",
                        buttons: true,
                        dangerMode: true,
                    }).then((send) => {
                        if (send) {
                            form.submit();
                        }
                    });
                    return false;
                }
            });
        });

        function sendTemplate(userId, countryCode, mobileNumber) {
            $('.sendTemplateModalClass').attr('id', 'sendTemplateModal' + userId);
            $('#sendTemplateForm')[0].reset();
            $('#country_code').val(countryCode);
            $('#mobile').val(mobileNumber);
            $("#sendTemplateModal" + userId).modal('show');
        }
        checkValidation = function(event) {
            var filePath = event.value;
            var allowedExtensions = /(\.xlsx)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .xlsx only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var reader = new FileReader();
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
        $(document).on('click', '.import-btn', function() {
            $("#upload").modal("show");
        });

        $(".image-popup-no-margins").magnificPopup({
            type: "image",
            closeOnContentClick: !0,
            closeBtnInside: !1,
            fixedContentPos: !0,
            mainClass: "mfp-no-margins mfp-with-zoom",
            image: {
                verticalFit: !0
            },
            zoom: {
                enabled: !0,
                duration: 300
            }
        });
    </script>
@endsection
