@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">International Affiliations
                                        ({{ $internationalAffiliations->total() }})</h2>
                                </div>

                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="name" class="form-control" placeholder="Name"
                                        @if ($request->name) value="{{ $request->name }}" @endif>
                                </div>

                                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" data-placeholder="active" name="status"
                                        id="status">
                                        <option value="all" @if ($request->status == 'all' || $request->status == '') selected @endif>All
                                        </option>
                                        <option value="active" @if ($request->status == 'active') selected @endif>Active
                                        </option>
                                        <option value="inactive" @if ($request->status == 'inactive') selected @endif>Inactive
                                        </option>
                                    </select>
                                </div>

                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <a href="{{ url()->current() }}" class="btn btn-secondary">
                                        Clear Search
                                    </a>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('international.affiliations.create') }}"
                                        class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display  mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Image</th>
                    <th>Index</th>
                    <th>Link</th>
                    <th>Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($internationalAffiliations) > 0)
                        @php $i = $internationalAffiliations->perPage() * ($internationalAffiliations->currentPage() - 1) + 1; @endphp
                        @foreach ($internationalAffiliations as $internationalAffiliation)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $internationalAffiliation->name ?? '' }}</td>
                                <td>
                                    @if ($internationalAffiliation->image)
                                        <div class=" w-25">
                                            <a class="image-popup-no-margins mr-2"
                                                href="{{ getFilePath($internationalAffiliation->image->path) }}">
                                                <img src="{{ getFilePath($internationalAffiliation->image->path) }}"
                                                    class="img-responsive" style="width:50px;"></a>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; align-items: center;">
                                        {{ $internationalAffiliation->index ?? '' }}
                                        <button type="button" class="btn btn-sm-icon me-3 index-btn"
                                            data-id="{{ $internationalAffiliation->id }}" data-toggle="modal"
                                            data-target="myModal" data-value="{{ $internationalAffiliation->index }}">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                    </div>
                                </td>
                                <td>{{ $internationalAffiliation->link ?? '' }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($internationalAffiliation->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('international.affiliations.status', $internationalAffiliation->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('international.affiliations.status', $internationalAffiliation->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('international.affiliations.edit', $internationalAffiliation->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('international.affiliations.destroy', $internationalAffiliation->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $internationalAffiliations->appends(Request::all())->links() }}
        </div>
    </div>
    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                <div class="modal-header">
                    <h5 class="modal-title">Change Index</h5>
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                </div>
                <form id="indexchange" method="POST">
                    @csrf
                    <div class="modal-body">
                        <label>Enter Index</label>
                        <input type="text" class="form-control" id="index" placeholder="Enter index" name="index"
                            value="">
                        <input type="hidden" class="userId" name="id" value="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).on('click', '.index-btn', function() {
            var userId = $(this).data('id');
            var index = $(this).data('value');

            $('#indexchange .userId').val(userId);
            $('#index').val(index);
            $("#myModal").modal("show");

        });

        $('#indexchange').on('submit', function(e) {
            e.preventDefault();

            var userId = $('.userId').val();
            var index = $('#index').val();

            var url = "{{ route('international.affiliations.update.index', ':internationalAffiliation') }}";
            url = url.replace(':internationalAffiliation', userId);


            $.ajax({
                url: url,
                method: 'post',
                data: {
                    id: userId,
                    index: index,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#myModal').modal('hide');
                    swal({
                        text: response.message,
                        icon: "success",
                        button: "Ok",
                    }).then(function() {
                        location.reload();
                    });
                }
            });
        });
    </script>
@endsection
