@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation"
            action="{{ route('international.affiliations.update', $internationalAffiliation->id) }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Edit International Affiliations</h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('international.affiliations.index') }}" type="button"
                            class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Name') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ $internationalAffiliation->name }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Image') }} <span class="text-danger">*</span></label>
                                <p class="text-small text-danger">(Image Size will be less then 3 MB)</p>
                            </div>
                            <div class="col-sm-10">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="image" class="btn btn-primary mb-0">choose
                                            file</label>
                                        <input type="file" name="image" id="image" hidden class="filestyle"
                                            onchange="loadFile(this)">
                                        <label for="image" class="error" style="display: none;"></label>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="profile-image w-32px">
                                            <div id="previewBannerImage"
                                                class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                                style="height:170px;
                                                @if (checkFileExist($internationalAffiliation->image->path)) background-image:url({{ getFilePath($internationalAffiliation->image->path) }}); @endif
                                                background-position: center center;background-size: contain;background-repeat: no-repeat;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link/URL') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="url" name="link" id="link" class="form-control"
                                    value= "{{ $internationalAffiliation->link }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Index') }}
                                </label>
                            </div>
                            <div class="col-sm-5">
                                <input type="text" name="index" id="index" class="form-control"
                                    value="{{ $internationalAffiliation->index }}" maxlength="3"
                                    onkeypress='return event.charCode >= 48 && event.charCode <= 57'>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Status') }}</label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control" id="status" name="status" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                        {{ $internationalAffiliation->status == App\Enums\StatusEnum::ACTIVE ? 'selected' : '' }}>
                                        Active
                                    </option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                        {{ $internationalAffiliation->status == App\Enums\StatusEnum::INACTIVE ? 'selected' : '' }}>
                                        Deactive
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $(".custom-validation").parsley();
        });


        function resetPreview(previewId) {
            $(previewId).css({
                'background-image': 'url()',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        function updatePreview(previewId, result) {
            $(previewId).css({
                'background-image': 'url(' + result + ')',
                'background-position': 'center center',
                'background-size': 'contain',
                'background-repeat': 'no-repeat'
            }).html('');
        }

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            var maxFileSize = 3 * 1024 * 1024;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    var file = event.files[0];
                    if (file.size > maxFileSize) {
                        alert('Image size exceeds the 3MB limit. Please upload a smaller Image.');
                        event.value = '';
                        return;
                    }
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };
    </script>
@endsection
