@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        {{ $event->title }} Event Participants ({{ $eventParticipants->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="filter" class="form-control" placeholder="Name & Contact"
                                        @if ($request->filter) value="{{ $request->filter }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="email" class="form-control" placeholder="Email"
                                        @if ($request->email) value="{{ $request->email }}" @endif>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        Export
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Date</th>
                    @if ($event->eventFormInputFields)
                        @foreach ($event->eventFormInputFields as $inputFormFields)
                            @if (!in_array($inputFormFields->name, $basicFields))
                                <th>
                                    {{ $inputFormFields->label }}
                                </th>
                            @endif
                        @endforeach
                    @endif
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventParticipants) > 0)
                        @php $i = $eventParticipants->perPage() * ($eventParticipants->currentPage() - 1) + 1; @endphp
                        @foreach ($eventParticipants as $eventParticipant)
                            @php
                                $user = $eventParticipant->user;
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $user->name ?? '-' }}</td>
                                <td>{{ $user->email ?? '-' }}</td>
                                <td>{{ $user->contact ?? '-' }}</td>
                                <td>{{ $eventParticipant->created_at ? getTimezoneDateTime($eventParticipant->created_at, 'd-m-Y | h:i A') : '-' }}
                                </td>
                                @if ($event->eventFormInputFields)
                                    @foreach ($event->eventFormInputFields as $inputFormFields)
                                        @if (!in_array($inputFormFields->name, $basicFields))
                                            <td>
                                                @php $extraColumn =  isset($eventParticipant) ? (isset($eventParticipant->extra[$inputFormFields['name']]) ? $eventParticipant->extra[$inputFormFields['name']] : '-') : '-'; @endphp
                                                @php $eventRegistrationId = $user->eventRegistrations ? $user->eventRegistrations->first()->id : ''; @endphp
                                                <span
                                                    class="extra_data_{{ $inputFormFields->name }}_{{ $eventRegistrationId }}">
                                                    @if ($inputFormFields->type == 'checkbox')
                                                        @if (is_array($extraColumn))
                                                            @if (count($extraColumn) > 0)
                                                                <ol style="margin-bottom:0">
                                                                    @foreach ($extraColumn as $key => $extraField)
                                                                        <li>{{ $extraField }}
                                                                        </li>
                                                                    @endforeach
                                                                </ol>
                                                            @endif
                                                        @endif
                                                    @elseif($inputFormFields->type == 'file_input')
                                                        @php
                                                            $fileInput = $event->getFileInput($extraColumn);
                                                        @endphp
                                                        @if(isset($fileInput))
                                                            <div class="members-tools-button">
                                                                <a href="{{ getFilePath($fileInput) }}" class="btn btn-sm-icon me-3" target="_blank">
                                                                    <img src="{{ asset('assets/images/icon/show.png') }}">
                                                                </a>
                                                            </div>
                                                        @else
                                                            -
                                                        @endif
                                                    @elseif($inputFormFields->name == 'category')
                                                        {{ $eventParticipant->extra['category_data']['category_name'] ?? '-' }}<br>
                                                        {{ $eventParticipant->extra['category_data']['category_amount'] ?? '-' }}
                                                    @elseif($inputFormFields->name == 'workshop')
                                                        {{ $eventParticipant->extra['workshop_data']['workshop_name'] ?? $eventParticipant->extra[$inputFormFields['name']] ?? '-' }}<br>
                                                        {{ $eventParticipant->extra['workshop_data']['workshop_amount'] ?? '-' }}
                                                    @elseif($inputFormFields->name == 'register_accompany')
                                                        {{ $eventParticipant->extra['register_accompany'] ?? '-' }}<br>
                                                        {{ $eventParticipant->extra['accompany_data']['accompany_amount'] ?? '' }}
                                                    @elseif($inputFormFields->name == 'accompany_person')
                                                        {{ $eventParticipant->extra['accompany_person'] ?? '-' }}<br>
                                                        @if(isset($eventParticipant->extra['accompany_name']))
                                                            @foreach ($eventParticipant->extra['accompany_name'] as $data)
                                                                {{ $data }}<br>
                                                            @endforeach
                                                        @endif
                                                    @else
                                                    {{ $extraColumn }}
                                                    @endif
                                                </span>
                                            </td>
                                        @endif
                                    @endforeach
                                @endif
                                <td>
                                    <button class="btn btn-sm-icon me-3"
                                        onclick="sweetAlertAjax('delete','{{ route('events.participants.delete', $eventParticipant->id) }}', 'Are you sure you want to delete?')">
                                        <img src="{{ asset('assets/images/icon/delete.png') }}">
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventParticipants->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
