@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        {{ $event->title }} Confirm Registrations ({{ $eventParticipants->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="filter" class="form-control" placeholder="Name & Contact"
                                        @if ($request->filter) value="{{ $request->filter }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="email" class="form-control" placeholder="Email"
                                        @if ($request->email) value="{{ $request->email }}" @endif>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        Export
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>User Details</th>
                    <th>Date</th>
                    @if ($event->eventFormInputFields)
                        @foreach ($event->eventFormInputFields as $inputFormFields)
                            @if ($inputFormFields->visible == \App\Enums\EventFormFieldEnum::VISIBLE)
                                @if (!in_array($inputFormFields->name, $basicFields))
                                    <th>
                                        {{ $inputFormFields->display_label }}
                                    </th>
                                @endif
                            @endif
                        @endforeach
                    @endif
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($eventParticipants) > 0)
                        @php $i = $eventParticipants->perPage() * ($eventParticipants->currentPage() - 1) + 1; @endphp
                        @foreach ($eventParticipants as $eventParticipant)
                            @php
                                $user = $eventParticipant->user;
                                $extra = $eventParticipant->extra;
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $user->name ?? '-' }} <br>{{ $user->email ?? '-' }}
                                    <br>{{ $user->full_mobile_number ?? '-' }} <br>
                                    @if ($canEdit)
                                        <button class="btn btn-sm btn-warning"
                                            onclick="editUserDetails('{{ $user->id }}','{{ $user->name }}','{{ $user->email }}','{{ $user->contact }}','{{ $eventParticipant->id }}')">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    @endif
                                </td>
                                {{-- <td>{{ $user->email ?? '-' }}</td>
                                <td>{{ $user->full_mobile_number ?? '-' }}</td> --}}
                                <td>{{ $eventParticipant->created_at ? getTimezoneDateTime($eventParticipant->created_at, 'd-m-Y | h:i A') : '-' }}
                                </td>
                                @if ($event->eventFormInputFields)
                                    @foreach ($event->eventFormInputFields as $inputFormFields)
                                        @if ($inputFormFields->visible == \App\Enums\EventFormFieldEnum::VISIBLE)
                                            @if (!in_array($inputFormFields->name, $basicFields))
                                                <td>
                                                    @php $extraColumn =  isset($eventParticipant) ? (isset($eventParticipant->extra[$inputFormFields['name']]) ? $eventParticipant->extra[$inputFormFields['name']] : '-') : '-'; @endphp
                                                    @php $eventRegistrationId = $user->eventRegistrations ? $user->eventRegistrations->first()->id : ''; @endphp
                                                    <span
                                                        class="extra_data_{{ $inputFormFields->name }}_{{ $eventRegistrationId }}">
                                                        @if ($inputFormFields->type == 'checkbox')
                                                            @if (is_array($extraColumn))
                                                                @if (count($extraColumn) > 0)
                                                                    <ol style="margin-bottom:0">
                                                                        @foreach ($extraColumn as $key => $extraField)
                                                                            <li>{{ $extraField }}
                                                                            </li>
                                                                        @endforeach
                                                                    </ol>
                                                                @endif
                                                            @endif
                                                        @elseif($inputFormFields->type == 'file_input')
                                                            @php
                                                                $fileInput = $event->getFileInput($extraColumn);
                                                            @endphp
                                                            @if (isset($fileInput))
                                                                <div class="members-tools-button">
                                                                    <a href="{{ getFilePath($fileInput) }}"
                                                                        class="btn btn-sm-icon me-3" target="_blank">
                                                                        <img
                                                                            src="{{ asset('assets/images/icon/show.png') }}">
                                                                    </a>
                                                                </div>
                                                            @else
                                                                -
                                                            @endif
                                                        @elseif($inputFormFields->name == 'category')
                                                            {{ $eventParticipant->extra['category_data']['category_name'] ?? '-' }}<br>
                                                            {{ $eventParticipant->extra['category_data']['category_amount'] ?? '-' }}
                                                        @elseif($inputFormFields->name == 'workshop')
                                                            {{ $eventParticipant->extra['workshop_data']['workshop_name'] ?? ($eventParticipant->extra[$inputFormFields['name']] ?? '-') }}<br>
                                                            {{ $eventParticipant->extra['workshop_data']['workshop_amount'] ?? '-' }}
                                                        @elseif($inputFormFields->name == 'register_accompany')
                                                            {{ $eventParticipant->extra['register_accompany'] ?? '-' }}<br>
                                                            {{ $eventParticipant->extra['accompany_data']['accompany_amount'] ?? '' }}
                                                        @elseif($inputFormFields->name == 'accompany_person')
                                                            {{ $eventParticipant->extra['accompany_person'] ?? '-' }}<br>
                                                            @if (isset($eventParticipant->extra['accompany_name']))
                                                                @foreach ($eventParticipant->extra['accompany_name'] as $data)
                                                                    {{ $data }}<br>
                                                                @endforeach
                                                            @endif
                                                        @else
                                                            {{ $extraColumn }}
                                                        @endif
                                                    </span>
                                                    @if (
                                                        $canEdit &&
                                                            !Str::contains($inputFormFields->display_label, [
                                                                'Category',
                                                                'Workshop',
                                                                'Accompany',
                                                                'Accompany Person',
                                                                'Payment Mode',
                                                                'Upload Payment Receipt',
                                                                'Transaction Date',
                                                                'UTR Id / Transaction Id.',
                                                            ]))
                                                        <button class="btn btn-sm btn-warning"
                                                            onclick="editData({{ $eventParticipant->id }}, '{{ $inputFormFields->name }}')">
                                                            <i class="fa fa-edit"></i>
                                                        </button>
                                                    @endif
                                                </td>
                                            @endif
                                        @endif
                                    @endforeach
                                @endif
                                @if ($canEdit)
                                    <td>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('event.coordinator.forms.confirm.registrations.destroy', $eventParticipant->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventParticipants->appends(Request::all())->links() }}
        </div>
    </div>

    {{-- Edit Model  --}}
    <div class="modal fade editModelClass" id="editModel" aria-modal="true" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Edit</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('event.coordinator.forms.registrations.updateFieldValue') }}"
                        id="updateFieldValue">
                        @csrf
                        <span class="form-field"></span>
                        <button type="submit" class="btn btn-primary px-5 mt-3">submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Edit user Model  --}}
    <div class="modal fade editUserModelClass" id="editUserModel" aria-modal="true" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="model-title">Edit</h4>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="width: 1.5rem; height: 1.5rem;">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('event.coordinator.forms.registrations.updateUserData') }}"
                        id="updateUserDetailsForm">
                        @csrf
                        <span class="user-field"></span>
                        <button type="submit" class="btn btn-primary px-5 mt-3">submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $('#updateFieldValue').parsley();
        $('#updateUserDetailsForm').parsley();

        function editData(id, column) {
            var url = "{{ route('event.coordinator.forms.registrations.get.data', ':eventRegistration') }}";
            url = url.replace(':eventRegistration', id);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: url,
                data: {
                    "column": column
                },
                success: function(response) {
                    if (response.status == 200) {
                        $('.form-field').html(response.data);
                        $('.editModelClass').modal('show');
                    }
                },
                error: function(xhr) {
                    alert(xhr.responseJSON.message);
                }
            });
        }

        function editUserDetails(id, name, email, phone, registrationId) {
            var url = "{{ route('event.coordinator.forms.registrations.get.user.data', ':user') }}";
            url = url.replace(':user', id);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'GET',
                url: url,
                data: {
                    id: registrationId
                },
                success: function(response) {
                    if (response.status == 200) {
                        $('.user-field').html(response.data);
                        $('.editUserModelClass').modal('show');
                    }
                },
                error: function(xhr) {
                    alert(xhr.responseJSON.message);
                }
            });
        }

        $(function() {
            //get state
            $(document).on('change', '.country', function() {
                var selectedOption = $(this).find('option:selected');
                var countryId = selectedOption.data('countryid');
                if (countryId) {
                    $.ajax({
                        url: "{{ route('frontend.get.states', ':countryId') }}".replace(
                            ':countryId', countryId),
                        type: 'GET',
                        dataType: 'json',
                        success: function(response) {
                            var $stateSelect = $('.state');
                            $stateSelect.empty().append(
                                '<option value="">-- Select State --</option>');

                            $.each(response, function(index, state) {
                                $stateSelect.append('<option value="' + state.id +
                                    '" data-stateid="' + state.id + '">' + state
                                    .name + '</option>');
                            });

                            $stateSelect.trigger('change');
                        },
                        error: function() {
                            console.log('Failed to fetch states. Please try again.');
                        }
                    });
                } else {
                    $('.state').empty().append('<option value="">-- Select State --</option>');
                }
            });

            var preSelectedCountryOption = $('.country option:selected');
            var preSelectedCountryId = preSelectedCountryOption.data('countryid');

            if (preSelectedCountryId) {
                $('.country').trigger('change');
            }

            //get city
            $(document).on('change', '.state', function() {
                var selectedOption = $(this).find('option:selected');
                var stateId = selectedOption.data('stateid');
                if (stateId) {
                    $.ajax({
                        url: "{{ route('frontend.get.cities', ':stateId') }}".replace(':stateId',
                            stateId),
                        type: 'GET',
                        dataType: 'json',
                        success: function(response) {
                            var $citySelect = $('.city');
                            $citySelect.empty().append(
                                '<option value="">-- Select City --</option>');

                            $.each(response, function(index, city) {
                                $citySelect.append('<option value="' + city.id +
                                    '" data-cityid="' + city.id + '">' + city.name +
                                    '</option>');
                            });

                            $citySelect.trigger('change');
                        },
                        error: function() {
                            console.log('Failed to fetch cities. Please try again.');
                        }
                    });
                } else {
                    $('.city').empty().append('<option value="">-- Select City --</option>');
                }
            });

            $('input[name="email"]').on('change', function() {
                var email = $(this).val();
                const $errorMsg = $('#email-error');
                const $submitButton = $('#submit-btn');

                if (!email) return;

                $.ajax({
                    url: '{{ route('frontend.check.mail.exists', ['event' => $event->id]) }}',
                    type: 'GET',
                    data: {
                        email: email,
                    },
                    success: function(response) {
                        if (response.exists) {
                            $errorMsg.show();
                            $submitButton.prop('disabled', true);
                        } else {
                            $errorMsg.hide();
                            $submitButton.prop('disabled', false);
                        }
                    },
                    error: function(xhr) {
                        console.error('AJAX error:', xhr.responseText);
                    }
                });
            });

        })
    </script>
@endsection
