 <input type="hidden" value="{{ $eventRegistration->id }}" name="id">
 @switch($eventFormInputFields->type)
     @case('text')
         @if ($eventFormInputFields->name === 'transaction_id')
             <div class="col-md-12" id="transaction_id_wrapper">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }} @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input
                         class="form-control {{ $eventFormInputFields->name === 'email' ? 'email email-' . $eventFormInputFields->id : '' }}"
                         type="{{ $eventFormInputFields->name === 'email' ? 'email' : 'text' }}"
                         id="field_{{ $eventFormInputFields->id }}" name="{{ $eventFormInputFields->name }}"
                         placeholder="{{ $eventFormInputFields->helper_text ?? 'Enter ' . strtolower($eventFormInputFields->display_label) }}"
                         value="{{ old($eventFormInputFields->name, array_key_exists($eventFormInputFields->name, $eventRegistration->extra) ? $eventRegistration->extra[$eventFormInputFields->name] : '') }}"
                         @if ($eventFormInputFields->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputFields->display_label) }} field is required." @endif
                         @if ($eventFormInputFields->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address." @endif />
                 </div>
                 <div class="invalid-feedback" id="transaction-error" style="display: none;">
                     Payment is already made with this transaction Id
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'email')
             <div class="col-md-12">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input
                         class="form-control {{ $eventFormInputFields->name === 'email' ? 'email email-' . $eventFormInputFields->id : '' }}"
                         type="{{ $eventFormInputFields->name === 'email' ? 'email' : 'text' }}"
                         id="field_{{ $eventFormInputFields->id }}" name="{{ $eventFormInputFields->name }}"
                         placeholder="{{ $eventFormInputFields->helper_text ?? 'Enter ' . strtolower($eventFormInputFields->display_label) }}"
                         value="{{ old($eventFormInputFields->name, array_key_exists($eventFormInputFields->name, $eventRegistration->extra) ? $eventRegistration->extra[$eventFormInputFields->name] : '') }}"
                         @if ($eventFormInputFields->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputFields->display_label) }} field is required." @endif
                         @if ($eventFormInputFields->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address." @endif />
                 </div>
                 <div class="invalid-feedback" id="email-error" style="display: none;">
                     This email is already registered for the event.
                 </div>
             </div>
         @else
             <div class="col-md-12">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input
                         class="form-control {{ $eventFormInputFields->name === 'email' ? 'email email-' . $eventFormInputFields->id : '' }}"
                         type="{{ $eventFormInputFields->name === 'email' ? 'email' : 'text' }}"
                         id="field_{{ $eventFormInputFields->id }}" name="{{ $eventFormInputFields->name }}"
                         placeholder="{{ $eventFormInputFields->helper_text ?? 'Enter ' . strtolower($eventFormInputFields->display_label) }}"
                         value="{{ old($eventFormInputFields->name, array_key_exists($eventFormInputFields->name, $eventRegistration->extra) ? $eventRegistration->extra[$eventFormInputFields->name] : '') }}"
                         @if ($eventFormInputFields->required == \App\Enums\EventFormFieldEnum::REQUIRED) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputFields->display_label) }} field is required." @endif
                         @if ($eventFormInputFields->name === 'email') data-parsley-type="email"
                                                data-parsley-type-message="Please enter a valid email address." @endif />
                 </div>
             </div>
         @endif
     @break

     @case('dropdown')
         @if ($eventFormInputFields->name === 'country')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         @include('frontend.event.registration.includes.country-select2', [
                             'placeholder' => '-- Select ' . $eventFormInputFields->display_label . ' --',
                             'required' =>
                                 $eventFormInputFields->required == \App\Enums\EventFormFieldEnum::REQUIRED,
                             'errorBlockId' => 'error-block-' . $eventFormInputFields->id,
                             'defaultValue' => old(
                                 $eventFormInputFields->name,
                                 $eventFormInputFields->default_value ?? ''),
                         ])
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'state')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2 state" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'city')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2 city" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'category')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             @foreach ($eventCategories as $category)
                                 <option value="{{ $category->id }}">
                                     {{ $category->name }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'workshop')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             <option value="no">No</option>
                             @foreach ($eventWorkshops as $workshop)
                                 <option value="{{ $workshop->id }}">
                                     {{ $workshop->name }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'register_accompany')
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             @foreach ($eventFormInputFields->options ?? [] as $option)
                                 <option value="{{ $option['value'] }}" @if ($eventFormInputFields->default_value == $option['value']) selected @endif>
                                     {{ $option['title'] }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @elseif($eventFormInputFields->name === 'accompany_person')
             <div class="col-md-12" id="accompany_person_wrapper">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             @foreach ($eventFormInputFields->options ?? [] as $option)
                                 <option value="{{ $option['value'] }}" @if ($eventFormInputFields->default_value == $option['value']) selected @endif>
                                     {{ $option['title'] }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
             <div id="accompany_inputs_container" class="row"></div>
         @elseif($eventFormInputFields->name === 'payment_mode')
             {{-- @dd($eventRegistration->extra[$eventFormInputFields->name]) --}}
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             @foreach ($eventFormInputFields->options ?? [] as $option)
                                 <option value="{{ $option['value'] }}" @if (array_key_exists($eventFormInputFields->name, $eventRegistration->extra) &&
                                         $eventRegistration->extra[$eventFormInputFields->name] == $option['value']
                                 ) selected @endif>
                                     {{ $option['title'] }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
                 <div class="form-group" id="bank_details_wrapper">
                     <label for="bank_details">Bank Details</label>
                     @if (isset($event->eventBankDetails))
                         {!! nl2br($event->eventBankDetails->bank_details) !!}
                     @endif
                 </div>
             </div>
             <div class="col-md-12">
                 <div id="qrcode"></div>
             </div>
         @else
             <div class="col-md-12">
                 <div class="form-group">
                     <div class="select2-drop">
                         <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                             @if ($eventFormInputFields->required)
                                 <span class="text-danger">*</span>
                             @endif
                         </label>
                         <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                         <select class="form-select select2" name="{{ $eventFormInputFields->name }}"
                             id="field_{{ $eventFormInputFields->id }}"
                             @if ($eventFormInputFields->required) required
                                                        data-parsley-errors-container="#error-block-{{ $eventFormInputFields->id }}"
                                                        data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                             <option value="">-- Select {{ $eventFormInputFields->display_label }} --
                             </option>
                             @foreach ($eventFormInputFields->options ?? [] as $option)
                                 <option value="{{ $option['value'] }}" @if ($eventFormInputFields->default_value == $option['value']) selected @endif>
                                     {{ $option['title'] }}
                                 </option>
                             @endforeach
                         </select>
                         <div class="margin-top10" id="error-block-{{ $eventFormInputFields->id }}"></div>
                     </div>
                 </div>
             </div>
         @endif
     @break

     @case('textarea')
         <div class="col-md-12">
             <div class="form-group">
                 <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }} @if ($eventFormInputFields->required)
                         <span class="text-danger">*</span>
                     @endif
                 </label>
                 <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                 <textarea class="form-control {{ $eventFormInputFields->name }}" id="field_{{ $eventFormInputFields->id }}"
                     name="{{ $eventFormInputFields->name }}"
                     placeholder="{{ $eventFormInputFields->helper_text ?? 'Enter ' . strtolower($eventFormInputFields->display_label) }}"
                     rows="3"
                     @if ($eventFormInputFields->required) required
                                                data-parsley-required-message="The {{ strtolower($eventFormInputFields->display_label) }} field is required." @endif>{{ old($eventFormInputFields->name, $eventFormInputFields->default_value ?? '') }}</textarea>
             </div>
         </div>
     @break

     @case('date')
         @if ($eventFormInputFields->name === 'transaction_date')
             <div class="col-md-12" id="transaction_date_wrapper">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input class="form-control fc-datepicker" type="text" name="{{ $eventFormInputFields->name }}"
                         id="field_{{ $eventFormInputFields->id }}"
                         placeholder="{{ $eventFormInputFields->helper_text ?? 'Select ' . strtolower($eventFormInputFields->ldisplay_labelbel) }}"
                         value="{{ old($eventFormInputFields->name, array_key_exists($eventFormInputFields->name, $eventRegistration->extra) ? $eventRegistration->extra[$eventFormInputFields->name] : '') }}"
                         autocomplete="off"
                         @if ($eventFormInputFields->required) required
                                                    data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif />
                 </div>
             </div>
         @else
             <div class="col-md-12">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input class="form-control fc-datepicker" type="text" name="{{ $eventFormInputFields->name }}"
                         id="field_{{ $eventFormInputFields->id }}"
                         placeholder="{{ $eventFormInputFields->helper_text ?? 'Select ' . strtolower($eventFormInputFields->display_label) }}"
                         value="{{ old($eventFormInputFields->name, array_key_exists($eventFormInputFields->name, $eventRegistration->extra) ? $eventRegistration->extra[$eventFormInputFields->name] : '') }}"
                         autocomplete="off"
                         @if ($eventFormInputFields->required) required
                                                    data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif />
                 </div>
             </div>
         @endif
     @break

     @case('file_input')
         @if ($eventFormInputFields->name === 'upload_payment_receipt')
             <div class="col-md-12" id="upload_payment_receipt_wrapper">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input class="form-control {{ $eventFormInputFields->name }}" type="file"
                         id="field_{{ $eventFormInputFields->id }}" name="{{ $eventFormInputFields->name }}"
                         @if ($eventFormInputFields->required) required
                                                    data-parsley-required-message="Please upload {{ strtolower($eventFormInputFields->display_label) }}." @endif />
                 </div>
             </div>
         @else
             <div class="col-md-12">
                 <div class="form-group">
                     <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }}
                         @if ($eventFormInputFields->required)
                             <span class="text-danger">*</span>
                         @endif
                     </label>
                     <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                     <input class="form-control {{ $eventFormInputFields->name }}" type="file"
                         id="field_{{ $eventFormInputFields->id }}" name="{{ $eventFormInputFields->name }}"
                         @if ($eventFormInputFields->required) required
                                                    data-parsley-required-message="Please upload {{ strtolower($eventFormInputFields->display_label) }}." @endif />
                 </div>
             </div>
         @endif
     @case('radio')
         <div class="col-md-12">
             <div class="form-group">
                 <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }} @if ($eventFormInputFields->required)
                         <span class="text-danger">*</span>
                     @endif
                 </label>
                 <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                 @foreach ($eventFormInputFields->options ?? [] as $option)
                     <div class="form-check">
                         <input class="form-check-input {{ $option['title'] }}" type="radio"
                             id="field_{{ $eventFormInputFields->id }}_{{ $loop->index }}"
                             name="{{ $eventFormInputFields->name }}" value="{{ $option['value'] }}"
                             @if (array_key_exists($eventFormInputFields->name, $eventRegistration->extra) &&
                                     $eventRegistration->extra[$eventFormInputFields->name] == $option['value']
                             ) checked @endif
                             @if ($eventFormInputFields->required && $loop->first) data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                         <label class="form-check-label" for="field_{{ $eventFormInputFields->id }}_{{ $loop->index }}">
                             {{ $option['value'] }}
                         </label>
                     </div>
                 @endforeach
             </div>
         </div>
     @case('checkbox')
         <div class="col-md-12">
             <div class="form-group">
                 <label for="field_{{ $eventFormInputFields->id }}">{{ $eventFormInputFields->display_label }} @if ($eventFormInputFields->required)
                         <span class="text-danger">*</span>
                     @endif
                 </label>
                 <input type="hidden" name="key" value="{{ $eventFormInputFields->name }}">
                 @foreach ($eventFormInputFields->options ?? [] as $option)
                     <div class="form-check">
                         <input class="form-check-input {{ $option['title'] }}" type="checkbox"
                             id="field_{{ $eventFormInputFields->id }}_{{ $loop->index }}"
                             name="{{ $eventFormInputFields->name }}" value="{{ $option['value'] }}"
                             @if (array_key_exists($eventFormInputFields->name, $eventRegistration->extra) &&
                                     $eventRegistration->extra[$eventFormInputFields->name] == $option['value']
                             ) checked @endif
                             @if ($eventFormInputFields->required && $loop->first) data-parsley-required-message="Please select {{ strtolower($eventFormInputFields->display_label) }}." @endif>
                         <label class="form-check-label" for="field_{{ $eventFormInputFields->id }}_{{ $loop->index }}">
                             {{ $option['value'] }}
                         </label>
                     </div>
                 @endforeach
             </div>
         </div>
     @break

 @endswitch
