@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Committee ({{ $committees->total() }})
                                    </h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('committees.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Index</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($committees) > 0)
                        @php $i = $committees->perPage() * ($committees->currentPage() - 1) + 1; @endphp
                        @foreach ($committees as $row)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $row->name }}</td>
                                <td>
                                    <div style="display: flex; align-items: center;">
                                        {{ $row->index ?? '' }}
                                        <button type="button" class="btn btn-sm-icon me-3 index-btn"
                                            data-id="{{ $row->id }}" data-toggle="modal" data-target="myModal"
                                            data-value="{{ $row->index }}">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                    </div>
                                </td>
                                @if ($row->name != 'Standing' && $row->name != 'Executive')
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary mx-auto">
                                            @if ($row->status == App\Enums\StatusEnum::ACTIVE)
                                                <div class="status status-success"
                                                    onclick="sweetAlertAjax('PATCH','{{ route('committees.status', $row->id) }}', 'Are You Sure To Inactive')">
                                                    <span class="me-1"></span> Active
                                                </div>
                                            @else
                                                <div class="status status-danger"
                                                    onclick="sweetAlertAjax('PATCH','{{ route('committees.status', $row->id) }}', 'Are You Sure To Active')">
                                                    <span class="me-1"></span> Inactive
                                                </div>
                                            @endif
                                        </button>
                                    </td>

                                    <td>
                                        <div class="members-tools-button">
                                            <a href="{{ route('committees.view', $row->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/show.png') }}">
                                            </a>

                                            <a href="{{ route('committees.edit', $row->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/edit.png') }}">
                                            </a>
                                            <button class="btn btn-sm-icon me-3"
                                                onclick="sweetAlertAjax('delete','{{ route('committees.destroy', $row->id) }}', 'Are you sure you want to delete?')">
                                                <img src="{{ asset('assets/images/icon/delete.png') }}">
                                            </button>
                                        </div>
                                    </td>
                                @else
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary mx-auto" disabled>
                                            @if ($row->status == App\Enums\StatusEnum::ACTIVE)
                                                <div class="status status-success"
                                                    onclick="sweetAlertAjax('PATCH','{{ route('committees.status', $row->id) }}', 'Are You Sure To Inactive')">
                                                    <span class="me-1"></span> Active
                                                </div>
                                            @else
                                                <div class="status status-danger"
                                                    onclick="sweetAlertAjax('PATCH','{{ route('committees.status', $row->id) }}', 'Are You Sure To Active')">
                                                    <span class="me-1"></span> Inactive
                                                </div>
                                            @endif
                                        </button>
                                    </td>
                                    <td>
                                        <div class="members-tools-button">
                                            <a href="{{ route('committees.view', $row->id) }}"
                                                class="btn btn-sm-icon me-3">
                                                <img src="{{ asset('assets/images/icon/show.png') }}">
                                            </a>
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $committees->appends(Request::all())->links() }}
        </div>
    </div>

    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                <div class="modal-header">
                    <h5 class="modal-title">Change Index</h5>
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                </div>
                <form id="indexchange" method="POST">
                    @csrf
                    <div class="modal-body">
                        <label>Enter Index</label>
                        <input type="text" class="form-control" id="index" placeholder="Enter index" name="index"
                            value="">
                        <input type="hidden" class="userId" name="id" value="">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).on('click', '.index-btn', function() {
            var userId = $(this).data('id');
            var index = $(this).data('value');

            $('#indexchange .userId').val(userId);
            $('#index').val(index);
            $("#myModal").modal("show");

        });

        $('#indexchange').on('submit', function(e) {
            e.preventDefault();

            var userId = $('.userId').val();
            var index = $('#index').val();

            var url = "{{ route('committees.update.index', ':recordId') }}";
            url = url.replace(':recordId', userId);


            $.ajax({
                url: url,
                method: 'post',
                data: {
                    id: userId,
                    index: index,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#myModal').modal('hide');
                    swal({
                        text: response.message,
                        icon: "success",
                        button: "Ok",
                    }).then(function() {
                        location.reload();
                    });
                }
            });
        });
    </script>
@endsection
