@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">Banners ({{ $banners->total() }})</h2>
                                </div>

                                <div class="col-auto mb-2">
                                    <a href="{{ route('banners.create') }}" class="btn btn-outline-primary px-4">+
                                        Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display  mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Image</th>
                    <th>Index</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($banners) > 0)
                        @php $i = $banners->perPage() * ($banners->currentPage() - 1) + 1; @endphp
                        @foreach ($banners as $banner)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>
                                    @if ($banner->image)
                                        <div class=" w-25">
                                            <a class="image-popup-no-margins mr-2"
                                                href="{{ getFilePath($banner->image->path) }}">
                                                <img src="{{ getFilePath($banner->image->path) }}" class="img-responsive"
                                                    style="width:50px;"></a>
                                        </div>
                                    @endif
                                </td>
                                <td>{{ $banner->index }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($banner->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('banners.status', $banner->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('banners.status', $banner->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('banners.edit', $banner->id) }}" class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/edit.png') }}">
                                        </a>
                                        <button class="btn btn-sm-icon me-3"
                                            onclick="sweetAlertAjax('delete','{{ route('banners.destroy', $banner->id) }}', 'Are you sure you want to delete?')">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $banners->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
