@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        Users ({{ $users->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="name" class="form-control" placeholder="Name"
                                        @if ($request->name) value="{{ $request->name }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="email" class="form-control" placeholder="Email"
                                        @if ($request->email) value="{{ $request->email }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="contact" class="form-control" placeholder="Contact"
                                        @if ($request->contact) value="{{ $request->contact }}" @endif>
                                </div>
                                {{-- <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="unique_id" class="form-control" placeholder="member id"
                                        @if ($request->unique_id) value="{{ $request->unique_id }}" @endif>
                                </div> --}}
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    @foreach ($columns as $column)
                        <th>{{ ucwords($column) }}</th>
                    @endforeach
                    <th class="text-center">Status</th>
                </thead>
                <tbody>
                    @if (count($users) > 0)
                        @php $i = $users->perPage() * ($users->currentPage() - 1) + 1; @endphp
                        @foreach ($users as $key => $user)
                            <tr>
                                <td>{{ $i++ }}</td>
                                @foreach ($columns as $column)
                                    <td>{{ is_array($user->$column) ? json_encode($user->$column) : $user->$column ?? '-' }}
                                    </td>
                                @endforeach

                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($user->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $users->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
@endsection
