@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <form method="POST" class="custom-validation" action="{{ route('posts.store') }}" id="crudForm"
            enctype="multipart/form-data">
            @csrf
            <div class="row mb-2 justify-content-between">
                <div class="col-auto mb-4">
                    <h2 class="title-1">Add Posts
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-primary px-4">submit</button>
                        <a href="{{ route('posts.index') }}" type="button" class="btn btn-light px-4">cancel</a>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body px-3">
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Title') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="title" placeholder="Enter Title" id="title"
                                    class="form-control" value="{{ old('title') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Description') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="description" placeholder="Enter Description" id="description"
                                    class="form-control" value="{{ old('description') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Link') }} <span class="text-danger">*</span>
                                </label>
                            </div>
                            <div class="col-sm-8">
                                <input type="text" name="link" placeholder="Enter Link" id="link"
                                    class="form-control" value="{{ old('link') }}" required>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-xl-2">
                                <label>{{ __('Medias') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-xl-8">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <label for="medias" class="btn btn-primary mb-0">choose file</label>
                                        <input type="file" onchange="loadFile(this)" name="medias[]" id="medias"
                                            hidden="" required multiple>
                                    </div>
                                    <div class="col-auto">
                                        <div id="previewLogo"
                                            class="bg-light d-flex align-items-center justify-content-center mx-2 p-2"
                                            style="height:170px;width: 170px;">Image will show here</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="row align-items-center">
                            <div class="col-sm-2">
                                <label>{{ __('Status') }}<span class="text-danger">*</span></label>
                            </div>
                            <div class="col-sm-8">
                                <select class="form-control" id="status" name="status" required>
                                    <option value="{{ App\Enums\StatusEnum::ACTIVE }}">Active</option>
                                    <option value="{{ App\Enums\StatusEnum::INACTIVE }}">Deactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('js')
    <script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
    <script src="{{ asset('assets/js/parsley.min.js') }}"></script>
    <script>
        // $('.fc-datepicker').datepicker({
        //     dateFormat: "dd-mm-yy",
        //     changeYear: true,
        //     changeMonth: true,
        // });

        $(document).ready(function() {
            $(".custom-validation").parsley();
        });

        var loadFile = function(event) {
            $('#previewLogo').css('background-image', 'url()').css('background-position', 'center center').css(
                'background-size', 'cover').css('background-repeat', 'no-repeat').html('');
            var filePath = event.value;
            var allowedExtensions = /(\.jpg|\.jpeg|\.png|\.jfif)$/i;
            if (!allowedExtensions.exec(filePath)) {
                alert('Please upload file having extensions .jpeg, .jpg .png only.');
                event.value = '';
            } else {
                if (event.files && event.files[0]) {
                    $("#image").valid();
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#previewLogo').css('background-image', 'url(' + e.target.result + ')').css(
                            'background-position', 'center center').css('background-size', 'cover').css(
                            'background-repeat', 'no-repeat').html('');
                    };
                    reader.readAsDataURL(event.files[0]);
                }
            }
        };

    </script>
@endsection
