@if ($type == 'no_reply')
    @foreach ($metaChatRooms as $message)
        <a class="users-list-content message-profile service_content service_content-{{ $message->receiver_id }}"
            onclick="message_details('{{ $message->receiver_id }}')">
            <div class="d-flex flex-wrap align-items-center" style="justify-content: space-between; flex=wrap: wrap;">
                <h3 class="headline">
                    {{ $message->receiverUser->name ?? '' }}</h3>
            </div>
            <h3 class="headline">
                {{ $message->receiverUser->full_mobile_number ?? '' }}</h3>
            <p class="footnote"><span>{{ date('d/m/Y', strtotime($message->created_at)) }}</span>
                <span>{{ date('h:i A', strtotime($message->created_at)) }}</span>
            </p>
        </a>
    @endforeach
@else
    @foreach ($metaChatRooms as $message)
        @php
            $latestChat = $message->latestChat($message->user_id);
        @endphp
        <a class="users-list-content message-profile service_content service_content-{{ $message->user_id }}"
            onclick="message_details('{{ $message->user_id }}')">
            <div class="d-flex" style="justify-content: space-between; flex=wrap: wrap;">
                <div>
                    <h3 class="headline">{{ $message->user->name ?? '' }}</h3>
                    {{-- <h3 class="headline">{{ $message->user->userDetails->chapter->name ?? '' }}</h3> --}}
                    <h3 class="headline">{{ $message->user->full_mobile_number ?? '' }}</h3>
                </div>
                <div>
                    <p class="footnote ms-auto">
                        <span>{{ $latestChat ? date('d/m/Y', strtotime($latestChat->created_at)) : '' }}</span>
                        <span>{{ $latestChat ? date('h:i A', strtotime($latestChat->created_at)) : '' }}</span>
                    </p>
                    @if ($message->is_expired == false)
                        <div class="timer-watch ms-auto" style="width: fit-content; font-size: 12px">
                            {{ $message->remaining_expire_time }}</div>
                    @endif
                </div>
            </div>
        </a>
    @endforeach
@endif
