@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="card shadow-none mb-3">
            <div class="card-body px-0">
                <div class="row mb-2 justify-content-between">
                    <div class="col-auto mb-4">
                        <h2 class="title-1">template message</h2>
                    </div>
                    <div class="col-auto">
                        <div class="d-flex gap-3">
                        </div>
                    </div>
                </div>
                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-xxl-8">
                <div class="card mb-2">
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-lg-6">
                                <div class="form-group mb-4">
                                    <label>Template name<span class="danger">*</span></label>
                                    <input class="form-control" readonly value="{{ $messageTemplate->name }}">
                                </div>
                            </div>

                            <div class="col-lg-3 col-sm-6">
                                <div class="form-group mb-4">
                                    <label>Category<span class="danger">*</span></label>
                                    <input class="form-control" readonly value="{{ $messageTemplate->category }}">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="form-group mb-4">
                                    <label>Language<span class="danger">*</span></label>
                                    <input class="form-control" readonly value="{{ $messageTemplate->language_content }}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card mb-2">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label>Header (Optional)</label>
                                    <p class="caption-medium">Add a title or choose which type of media you'll use for this
                                        header. <br> Your title can't include more than one variable.</p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-6">
                                <div class="form-group mb-4">
                                    @if (isset($messageTemplate->headerComponent))
                                        @if ($messageTemplate->headerComponent->format == 'TEXT')
                                            TEXT
                                        @else
                                            Media
                                        @endif
                                    @else
                                        None
                                    @endif
                                </div>
                            </div>
                        </div>
                        {{-- {{ dd($messageTemplate->headerComponent->image->path) }} --}}
                        @if (isset($messageTemplate->headerComponent))
                            <div class="row mb-4 textTypeDiv" style="">
                                @if ($messageTemplate->headerComponent->format == 'TEXT')
                                    <input class="form-control" readonly
                                        value="{{ $messageTemplate->headerComponent->text }}">
                                @elseif($messageTemplate->headerComponent->format == 'IMAGE')
                                    <a class="image-popup-no-margins mr-2"
                                    @if (checkFileExist($messageTemplate->headerComponent->media->path)) href ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif>
                                        <img class="img-fluid"
                                        @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                            height="150px" width="150px">
                                    </a>
                                @elseif($messageTemplate->headerComponent->format == 'VIDEO')
                                    <video height="135px" controls>
                                        <source
                                            @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                            type="video/mp4">
                                    </video>
                                @elseif($messageTemplate->headerComponent->format == 'DOCUMENT')
                                    <iframe
                                        @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                        width="100" height="200" style="width:450px !important"></iframe>
                                @endif
                            </div>
                        @endif

                        @if (isset($messageTemplate->headerComponent->dynamic_variables))
                            <div class="form-group mb-3"><label>Samples for header content</label>
                                <p class="caption-medium">To help us review your content, provide examples of the
                                    variables or
                                    media in
                                    the header. Do not include any customer information. Cloud API hosted by Meta
                                    reviews
                                    templates and
                                    variable parameters to protect the security and integrity of our services.</p>
                            </div>
                            @foreach ($messageTemplate->headerComponent->dynamic_variables as $key => $dynamicVariable)
                                <div class="row">
                                    <div class="col-md-4">{{ $key }}</div>
                                    <div class="col-md-8">
                                        <div class="form-group mb-4"><input type="textbox" readonly class="form-control"
                                                style="width: 100%;" value="{{ $dynamicVariable }}"></div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="card mb-2">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group mb-3">
                                    <label>Body</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group mb-5">
                                    <textarea rows="10" class="form-control"> @if (isset($messageTemplate->bodyComponent)){{ $messageTemplate->bodyComponent->text }}@endif</textarea>
                                </div>
                            </div>
                        </div>

                        @if (isset($messageTemplate->bodyComponent->dynamic_variables))
                            <div class="form-group mb-3"><label>Samples for body content</label>
                                <p class="caption-medium">To help us review your content, provide examples of the
                                    variables or
                                    media in
                                    the body. Do not include any customer information. Cloud API hosted by Meta
                                    reviews
                                    templates and
                                    variable parameters to protect the security and integrity of our services.</p>
                            </div>
                            @foreach ($messageTemplate->bodyComponent->dynamic_variables as $key => $dynamicVariable)
                                <div class="row">
                                    <div class="col-md-4">{{ $key }}</div>
                                    <div class="col-md-8">
                                        <div class="form-group mb-4"><input type="textbox" readonly class="form-control"
                                                style="width: 100%;" value="{{ $dynamicVariable }}"></div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>

                @if (isset($messageTemplate->footerComponents))
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-3">
                                        <label>Footer (Optional)</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group mb-5">
                                        <input class="form-control" readonly
                                            value="{{ $messageTemplate->footerComponents->text }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                @if (isset($messageTemplate->buttonComponents) && count($messageTemplate->buttonComponents) > 0)
                    <div class="card mb-2">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm">
                                    <div class="form-group mb-3">
                                        <label>Buttons (Optional)</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                @foreach ($messageTemplate->buttonComponents as $buttonData)
                                    <div class="col-lg-4 col-sm-6">
                                        @if (isset($buttonData->type))
                                            <div class="form-group mb-4">
                                                <input class="form-control" readonly value="{{ $buttonData->type }}">
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-lg-4">
                                        @if (isset($buttonData->text))
                                            <div class="form-group mb-4">
                                                <input class="form-control" readonly value="{{ $buttonData->text }}">
                                            </div>
                                        @endif
                                    </div>
                                    @if (isset($buttonData->format))
                                        <div class="col-lg-4">
                                            <div class="form-group mb-4">
                                                <input class="form-control" readonly value="{{ $buttonData->format }}">
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="col-xxl-4">
                <div class="preview-wrap">
                    <h3 class="title-1 mb-3">Preview</h3>
                    <div class="card preview-card">
                        @if ($messageTemplate->headerComponent)
                            <div class="card-header">
                                @if ($messageTemplate->headerComponent->format == 'IMAGE')
                                    <img class="img-fluid"
                                        @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                        >
                                @elseif($messageTemplate->headerComponent->format == 'VIDEO')
                                    <video style="width:100% !important" controls>
                                        <source
                                            @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                            type="video/mp4">
                                    </video>
                                @elseif($messageTemplate->headerComponent->format == 'DOCUMENT')
                                    <iframe
                                        @if (checkFileExist($messageTemplate->headerComponent->media->path)) src ="{{ getFilePath($messageTemplate->headerComponent->media->path) }}" @endif
                                        style="width:100% !important"></iframe>
                                @endif
                            </div>
                        @endif
                        <div class="card-body bodyTextPreview">
                            @if (isset($messageTemplate->headerComponent) && $messageTemplate->headerComponent->format == 'TEXT')
                                @php
                                    $text = $messageTemplate->headerComponent->text;
                                    if (isset($messageTemplate->headerComponent->dynamic_variables)) {
                                        foreach (
                                            $messageTemplate->headerComponent->dynamic_variables
                                            as $key => $dynamicVariable
                                        ) {
                                            $text = str_replace('[ ' . $key . ' ]', $dynamicVariable, $text);
                                        }
                                    }
                                @endphp
                                <h2 class="title-1">{{ $text }}</h2>
                            @endif
                            @if (isset($messageTemplate->bodyComponent))
                                @php
                                    $text = $messageTemplate->bodyComponent->text;
                                    if (isset($messageTemplate->bodyComponent->dynamic_variables)) {
                                        foreach (
                                            $messageTemplate->bodyComponent->dynamic_variables
                                            as $key => $dynamicVariable
                                        ) {
                                            $text = str_replace('[ ' . $key . ' ]', $dynamicVariable, $text);
                                        }
                                    }
                                echo htmlspecialchars_decode(nl2br(e($text))); @endphp
                                <textarea rows="10" class="form-control d-none" id="body_text">@php echo htmlspecialchars_decode((e($text))); @endphp</textarea>
                            @endif
                        </div>
                        <div class="card-footer">
                            @if (isset($messageTemplate->footerComponent))
                                <p class="footnote">{{ $messageTemplate->footerComponent->text }}</p>
                            @endif
                        </div>
                    </div>
                    @if (isset($messageTemplate->buttonComponents) && count($messageTemplate->buttonComponents) > 0)
                        <div class="card-button">
                            @foreach ($messageTemplate->buttonComponents as $button)
                                @if ($button->type == 'URL')
                                    <a href="{{ $button->format }}" target="_blank" class="btn btn-white-shadow">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-geo-alt-fill" viewBox="0 0 16 16">
                                            <path
                                                d="M8 16s6-5.686 6-10A6 6 0 0 0 2 6c0 4.314 6 10 6 10zm0-7a3 3 0 1 1 0-6 3 3 0 0 1 0 6z" />
                                        </svg>
                                        {{ $button->text }}</a>
                                @elseif($button->type == 'PHONE_NUMBER')
                                    <a href="tel:{{ $button->format }}" target="_blank" class="btn btn-white-shadow">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                            fill="currentColor" class="bi bi-telephone-fill" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd"
                                                d="M1.885.511a1.745 1.745 0 0 1 2.61.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
                                        </svg>
                                        {{ $button->text }}</a>
                                @else
                                    <button class="btn btn-white-shadow">{{ $button->text }}</button>
                                @endif
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            function bodyDynamicValueChange() {
                bodyTextPreview = $("#body_text").val();
                var bodyTextPreview = bodyTextPreview.replace(/\*(.*?)\*/g, '<strong>$1</strong>');
                var bodyTextPreview = bodyTextPreview.replace(/\_(.*?)\_/g, '<i>$1</i>');
                var bodyTextPreview = bodyTextPreview.replace(/\~(.*?)\~/g, '<s>$1</s>');
                var bodyTextPreview = bodyTextPreview.replace(/ {2,}/g, function(match) {
                    return Array(match.length).fill('&nbsp;').join('');
                });
                bodyTextPreview = bodyTextPreview.replace(/\n/g, '<br>');
                $(".bodyTextPreview").html(bodyTextPreview.replace(/\n/g, "<br>"));
            }
            bodyDynamicValueChange();

        })
    </script>
@endsection
