@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="card shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-auto mb-4">
                    </div>
                    <div class="col-xl">
                        <form action="{{ route('message.templates.index') }}" method="get">
                            @csrf
                            <div class="row justify-content-xl-end">
                                <div class="col-xl-3 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" class="form-control" placeholder="name" name="name"
                                        id="name" value="{{ $request->name }}">
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-2">
                                    <a href="{{ route('message.templates.create') }}"
                                        class="btn btn-outline-primary px-4">+ Add new</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display">
                <thead>
                    <th>No</th>
                    <th>Template name</th>
                    <th>Category</th>
                    <th class="text-center">Status</th>
                    <th class="text-center">Language</th>
                    <th class="text-center">Date</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($messageTemplates) > 0)
                        <?php $i = $messageTemplates->perPage() * ($messageTemplates->currentPage() - 1) + 1; ?>
                        @foreach ($messageTemplates as $template)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $template->name }}</td>
                                <td>{{ $template->category }}</td>
                                <td>
                                    @if ($template->status == 'REJECTED')
                                        <button class="btn btn-sm btn-outline-primary mx-auto">
                                            <div class="status status-danger"><span class="me-1"></span> Rejected</div>
                                        </button>
                                    @elseif ($template->status == 'FAILED')
                                        <div class="d-flex" style="gap: 10px;justify-content: center;">
                                            <button class="btn btn-sm btn-outline-primary">
                                                <div class="status status-danger"><span class="me-1"></span> Failed</div>
                                            </button>
                                            <form method="post"
                                                action="{{ route('message.templates.retry', $template->id) }}">
                                                @csrf
                                                <button type="submit" class="btn btn-primary px-4">Retry</button>
                                            </form>
                                        </div>
                                    @elseif($template->status == 'PENDING')
                                        <button class="btn btn-sm btn-outline-primary mx-auto">
                                            <div class="status status-warning"><span class="me-1"></span> Under review
                                            </div>
                                        </button>
                                    @elseif($template->status == 'APPROVED')
                                        <button class="btn btn-sm btn-outline-primary mx-auto">
                                            <div class="status status-success"><span class="me-1"></span> Approved
                                            </div>
                                        </button>
                                    @endif
                                </td>
                                <td class="text-center">{{ $template->language_content }}</td>
                                <td class="text-center">{{ date('d-m-Y', strtotime($template->created_at)) }}</td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('message.templates.show', $template->id) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/show.png') }}">
                                        </a>
                                        <button
                                            onclick="sweetAlertAjax('delete','{{ route('message.templates.destroy', $template->id) }}', 'Are you sure you want to delete?')"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/delete.png') }}">
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $messageTemplates->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
    <script>
        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
        });

        $('.fc-timepicker').timepicker({
            timeFormat: 'HH:mm',
            interval: 30,
            defaultTime: '11',
            startTime: '08:00',
            dynamic: true,
            dropdown: true,
            scrollbar: true,
            zindex: 9999999
        });
    </script>
@endsection