@extends('layouts.master')
@section('css')
@endsection

@section('content')
    <div class="dashboard-body">
        <div class="card shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xxl">
                        <div class="row justify-content-end">
                            <div class="col-auto mb-2">
                                <a href="{{ route('bulk.messages.index') }}" class="btn btn-outline-primary px-4">send
                                    message</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Message -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display">
                <thead>
                    <th>No</th>
                    <th>Prefix campaign name</th>
                    <th>Template name</th>
                    <th>Scheduled</th>
                    <th>Success User</th>
                    <th>Total</th>
                    <th class="text-center">Sent</th>
                    <th class="text-center">Delivered</th>
                    <th class="text-center">Read</th>
                    <th class="text-center">Status</th>
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($messageCampaigns) > 0)
                        <?php $i = $messageCampaigns->perPage() * ($messageCampaigns->currentPage() - 1) + 1; ?>
                        @foreach ($messageCampaigns as $messageCampaign)
                            @php
                                $successUsersName = $messageCampaign->sent_users
                                    ? $messageCampaign->sent_users->take(2)->pluck('name')->implode(', ')
                                    : '-';
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ isset($messageCampaign->getPrefixCampaignDetail) ? $messageCampaign->getPrefixCampaignDetail->campaign_name : ($messageCampaign->campaign_unique_id ? $messageCampaign->campaign_unique_id : '---') }}
                                </td>
                                <td>{{ $messageCampaign->template_name }}</td>
                                <td>{{ $messageCampaign->scheduled_date }} {{ $messageCampaign->scheduled_time }}</td>
                                <td class="text-center text-nowrap" style="font-size:10px;">{{ $successUsersName ?? '-' }}
                                </td>
                                <td>{{ $messageCampaign->total_users }}</td>
                                <td class="text-center">
                                    <div class="chart-sent pie-title-center"
                                        data-percent="{{ $messageCampaign->sent_percentage }}">
                                        <span
                                            class="pie-value">{{ is_array($messageCampaign->sent_users) ? count($messageCampaign->sent_users) : 0 }}</span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="chart-delivered pie-title-center"
                                        data-percent="{{ $messageCampaign->delivered_percentage }}">
                                        <span
                                            class="pie-value">{{ is_array($messageCampaign->delivered_users) ? count($messageCampaign->delivered_users) : 0 }}</span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="chart-read pie-title-center"
                                        data-percent="{{ $messageCampaign->read_percentage }}">
                                        <span
                                            class="pie-value">{{ is_array($messageCampaign->read_users) ? count($messageCampaign->read_users) : 0 }}</span>
                                    </div>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto">
                                        @if ($messageCampaign->status == App\Enums\MessageCampaignEnum::PENDING)
                                            <div class="status status-danger"><span class="me-1"></span> Pending</div>
                                        @else
                                            <div class="status status-success"><span class="me-1"></span> Success</div>
                                        @endif
                                    </button>
                                </td>
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('bulk.messages.campaign.users', $messageCampaign->id) }}">
                                            <button class="btn btn-sm-icon">
                                                <img src="{{ asset('assets/images/icon/show.png') }}">
                                            </button>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $messageCampaigns->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
    <script>
        $('.chart-sent').pieChart({
            barColor: '#34C759',
            lineWidth: 8,
            size: 46,
            lineCap: 'square',
        });
        $('.chart-delivered').pieChart({
            barColor: '#FF3B30',
            lineWidth: 8,
            size: 46,
            lineCap: 'square',
        });
        $('.chart-read').pieChart({
            barColor: '#0014ff',
            lineWidth: 8,
            size: 46,
            lineCap: 'square',
        });
    </script>
@endsection
