@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        {{ $event->title }} Event Participants ({{ $eventParticipants->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="filter" class="form-control" placeholder="Name & Contact"
                                        @if ($request->filter) value="{{ $request->filter }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="email" class="form-control" placeholder="Email"
                                        @if ($request->email) value="{{ $request->email }}" @endif>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" name="export" value="export"
                                        class="btn btn-outline-primary px-4">
                                        Export
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Contact</th>
                    <th>Date</th>
                    <th>Send Message</th>
                </thead>
                <tbody>
                    @if (count($eventParticipants) > 0)
                        @php $i = $eventParticipants->perPage() * ($eventParticipants->currentPage() - 1) + 1; @endphp
                        @foreach ($eventParticipants as $eventParticipant)
                            @php
                                $user = $eventParticipant->user;
                            @endphp
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $user->name ?? '-' }}</td>
                                <td>{{ $user->email ?? '-' }}</td>
                                <td>{{ $user->contact ?? '-' }}</td>
                                <td>{{ $event->created_at ? getTimezoneDateTime($event->created_at, 'd-m-Y | h:i A') : '-' }}
                                </td>
                                </td>
                                <td><button type="button" class="btn btn-sm btn-outline-primary send-message"
                                        style="width: 120px" data-target="myModal" data-id="{{ $user->id }}"
                                        data-country= "{{ $user->country_code }}"
                                        data-contact= "{{ $user->contact }}">Send
                                        Message</button></td>

                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $eventParticipants->appends(Request::all())->links() }}
        </div>
    </div>

    <div class="modal fade" id="myModal">
        <div class="modal-dialog">
            <div class="modal-content" style="max-width: 500px; width: 100%; margin-left: 130px;">
                <div class="modal-header">
                    <h5 class="modal-title">Select Template</h5>
                    <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
                </div>
                <form id="send-message-btn" method="POST">
                    @csrf
                    <div class="modal-body">
                        <select class="select2" style="width: 100%;">
                            <option value="">Select Template</option>
                            @foreach ($messageTemplates as $messageTemplate)
                                <option value="{{ $messageTemplate->id }}" data-template= "{{ $messageTemplate->id }}">
                                    {{ $messageTemplate->name }}</option>
                            @endforeach
                        </select>
                        <input type="hidden" class="userId">
                        <input type="hidden" class="templateId">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).on('click', '.send-message', function() {
            var userId = $(this).data('id');
            var template = $(this).data('template');

            $('#send-message-btn .userId').val(userId);
            $('#send-message-btn .templateId').val(template);


            $("#myModal").modal("show");
        });

        $('.select2').on('change', function() {
            var selectedTemplate = $(this).val();
            $('#send-message-btn .templateId').val(selectedTemplate);
        });

        $('#send-message-btn').on('submit', function(e) {
            e.preventDefault();
            var userId = $('.userId').val();
            var template = $('.templateId').val();

            var url = "{{ route('bulk.messages.index') }}";

            $.ajax({
                url: url,
                method: 'post',
                data: {
                    users: [userId],
                    template_name: template,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    $('#myModal').modal('hide');
                    swal({
                        text: response.message,
                        icon: "success",
                        button: "Ok",
                    }).then(function() {
                        location.reload();
                    });
                }
            });
        });
    </script>
@endsection
