@extends('layouts.master')
@section('css')
@endsection
@section('content')
    <div class="dashboard-body">
        <div class="cards shadow-none">
            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-xl">
                        <form action="{{ url()->current() }}" method="get">
                            <div class="row justify-content-xl-end">
                                <div class="col mb-4">
                                    <h2 class="title-1">
                                        {{ $association->name }} Events ({{ $events->total() }})
                                    </h2>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-xxl">
                <div class="row">
                    <div class="col-xxl">
                        <form method="get" action="{{ url()->current() }}">
                            <div class="row justify-content-xxl-end">
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input type="text" name="title" class="form-control" placeholder="Title"
                                        @if ($request->title) value="{{ $request->title }}" @endif>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <input class="form-control fc-datepicker" placeholder="Select Date" type="text"
                                        value="{{ old('date', $request->date) }}" name="date" id="date"
                                        autocomplete="off">
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" name="type">
                                        <option value="">Select Type</option>
                                        <option value="{{ App\Models\Event::CONFERENCE }}"
                                            {{ $request->type == App\Models\Event::CONFERENCE ? 'selected' : '' }}>
                                            Conference</option>
                                        <option value="{{ App\Models\Event::WEBINAR }}"
                                            {{ $request->type == App\Models\Event::WEBINAR ? 'selected' : '' }}>Webinar
                                        </option>
                                    </select>
                                </div>
                                <div class="col-xl-2 col-lg-6 col-md-4 col-sm-6 mb-4">
                                    <select class="select2" style="width: 100%;" name="status">
                                        <option value="">Select Status</option>
                                        <option value="{{ App\Enums\StatusEnum::ACTIVE }}"
                                            {{ $request->status == App\Enums\StatusEnum::ACTIVE ? 'selected' : '' }}>Active
                                        </option>
                                        <option value="{{ App\Enums\StatusEnum::INACTIVE }}"
                                            {{ $request->status != false && $request->status == App\Enums\StatusEnum::INACTIVE ? 'selected' : '' }}>
                                            Deactive
                                        </option>
                                    </select>
                                </div>
                                <div class="col-auto mb-4">
                                    <button type="submit" class="btn btn-primary px-4">
                                        search
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                d="M3.85002 10C3.85002 6.60347 6.60347 3.85002 10 3.85002C13.3966 3.85002 16.15 6.60347 16.15 10C16.15 13.3966 13.3966 16.15 10 16.15C6.60347 16.15 3.85002 13.3966 3.85002 10ZM10 2.15002C5.66459 2.15002 2.15002 5.66459 2.15002 10C2.15002 14.3355 5.66459 17.85 10 17.85C11.8615 17.85 13.5717 17.2021 14.9173 16.1194L20.399 21.6011C20.7309 21.933 21.2691 21.933 21.6011 21.6011C21.933 21.2691 21.933 20.7309 21.6011 20.399L16.1194 14.9173C17.2021 13.5717 17.85 11.8615 17.85 10C17.85 5.66459 14.3355 2.15002 10 2.15002Z"
                                                fill="#7C8DB5" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>

        <!-- Massage -->
        <div class="table-design custom-table container-fluid py-2">
            <table class="table display mb-5">
                <thead>
                    <th>Sr. No</th>
                    <th>Title</th>
                    <th>Event Code</th>
                    <th>Date</th>
                    <th>Banner</th>
                    <th>Type</th>
                    <th>Registrations</th>
                    <th class="text-center">Status</th>
                    {{-- <th style="padding-left:24px">Participants</th> --}}
                    <th>Action</th>
                </thead>
                <tbody>
                    @if (count($events) > 0)
                        @php $i = $events->perPage() * ($events->currentPage() - 1) + 1; @endphp
                        @foreach ($events as $event)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $event->title ?? '' }}</td>
                                <td>{{ $event->code ?? '' }}</td>
                                <td>{{ $event->date ? getTimezoneDateTime($event->date, 'd-m-Y') : '-' }}</td>
                                <td>
                                    @if ($event->banner)
                                        <div class=" w-25">
                                            <a class="image-popup-no-margins mr-2"
                                                href="{{ getFilePath($event->banner->path) }}">
                                                <img src="{{ getFilePath($event->banner->path) }}" class="img-responsive"
                                                    style="width:50px;"></a>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    @if ($event->type == App\Models\Event::CONFERENCE)
                                        Conference
                                    @elseif($event->type == App\Models\Event::WEBINAR)
                                        Webinar
                                    @elseif($event->type == App\Models\Event::OTHERS)
                                        Others
                                    @endif
                                </td>
                                <td>{{ $event->eventRegistrations()->count() }}</td>
                                <td>
                                    <button class="btn btn-sm btn-outline-primary mx-auto" disabled>
                                        @if ($event->status == App\Enums\StatusEnum::ACTIVE)
                                            <div class="status status-success"
                                                onclick="sweetAlertAjax('PATCH','{{ route('events.status', $event->id) }}', 'Are You Sure To Inactive')">
                                                <span class="me-1"></span> Active
                                            </div>
                                        @else
                                            <div class="status status-danger"
                                                onclick="sweetAlertAjax('PATCH','{{ route('events.status', $event->id) }}', 'Are You Sure To Active')">
                                                <span class="me-1"></span> Inactive
                                            </div>
                                        @endif
                                    </button>
                                </td>
                                {{-- <td><a href="{{ route('associations.participants', $event->id) }}"
                                    class="btn btn-sm btn-primary" style="width: 145px">View Participants</a></td> --}}
                                <td>
                                    <div class="members-tools-button">
                                        <a href="{{ route('bulk.emails.send.emails', ['association_id' => $event->association_id, 'event_id' => $event->id]) }}"
                                            class="btn btn-sm-icon me-3">
                                            <img src="{{ asset('assets/images/icon/show.png') }}">
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td class="text-center" colspan="10">No Data Found </td>
                        </tr>
                    @endif
                </tbody>
            </table>
            {{ $events->appends(Request::all())->links() }}
        </div>
    </div>
@endsection
@section('js')
    <script>
        $('.fc-datepicker').datepicker({
            dateFormat: "dd-mm-yy",
            changeYear: true,
            changeMonth: true,
        });
    </script>
@endsection
