$(document).ready(function () {
    document.getElementById("options").style.display = "none";
    document.getElementById("nq_display_label_err").style.display = "none";
    document.getElementById("nq_label_err").style.display = "none";
    document.getElementById("nq_name_err").style.display = "none";
    document.getElementById("add_qa_btn").style.display = "none";
    document.getElementById("update_qa_btn").style.display = "none";
    document.getElementById("delete_qa_btn").style.display = "none";
    $("#nq_name").attr(
        "onkeypress",
        "return (event.charCode > 64 && event.charCode < 91) || (event.charCode > 96 && event.charCode < 123) || (event.charCode == 95)"
    );
});
let errors = false;

function processEditQA(dis, id) {
    document.getElementById("nq_display_label_err").style.display = "none";
    document.getElementById("nq_label_err").style.display = "none";
    document.getElementById("nq_name_err").style.display = "none";
    document.getElementById("update_qa_btn").style.display = "block";
    document.getElementById("add_qa_btn").style.display = "none";
    document.getElementById("delete_qa_btn").style.display = "block";

    const question = dis.getElementsByClassName("question_field")[0].value;
    const name = dis.getElementsByClassName("nq_name")[0].value;
    const default_value = dis.getElementsByClassName(
        "question_default_value"
    )[0].value;
    const helper_text = dis.getElementsByClassName("question_helper_text")[0]
        .value;
    const index = dis.getElementsByClassName("question_index")[0].value;
    const type = dis.getElementsByClassName("question_type")[0].value;
    const allow_for = dis.getElementsByClassName("question_allow_for")[0].value;
    const required = dis.getElementsByClassName("question_required")[0].value;

    document.getElementById("nq_label").value = question;
    document.getElementById("nq_name").value = name;
    document.getElementById("nq_default_value").value = default_value;
    document.getElementById("nq_helper_text").value = helper_text;
    document.getElementById("nq_index").value = index;
    document.getElementById("nq_required").checked =
        required == 1 ? true : false;
    document.getElementById("nq_type").value = type;
    document.getElementById("nq_allow_for").value = allow_for;

    $(".event_edit_id").val(id);
    $(".nq_label").html('Field Label<span class="text-danger">*</span>');

    switch (type) {
        case "text":
            document.getElementById("options").style.display = "none";
            break;
        case "textarea":
            document.getElementById("options").style.display = "none";
            break;
        case "radio":
            document.getElementById("options").style.display = "block";
            editOptionsHtml(dis);
            break;
        case "checkbox":
            document.getElementById("options").style.display = "block";
            editOptionsHtml(dis);
            break;
        case "dropdown":
            document.getElementById("options").style.display = "block";
            editOptionsHtml(dis);
            break;
        default:
            break;
    }

    $("#addQuestionsModal").modal("show");

    //
}

function processAddQA(dis) {
    document.getElementById("add_qa_btn").style.display = "block";
    document.getElementById("update_qa_btn").style.display = "none";
    document.getElementById("delete_qa_btn").style.display = "none";
    document.getElementById("options").style.display = "none";
    document.getElementById("nq_required").checked = false;
    document.getElementById("nq_display_label").value = "";
    document.getElementById("nq_label").value = "";
    document.getElementById("nq_name").value = "";
    document.getElementById("nq_default_value").value = "";
    document.getElementById("nq_helper_text").value = "";
    document.getElementById("nq_index").value = "";
    document.getElementById("nq_type").value = "text";

    $(".question_required").html("Field Required");
    $("#addQuestionsModal").modal("show");

    optionsDefaultHtml =
        '<input type="hidden" value="3" id="options_count">\
    <div class="row mt-2 options-row">\
        <div class="col-md-5">\
            <input type="text" class="optionValue form-control" placeholder="Option Value 1" name="options[value][]"/>\
            <span type="text" class="optionValueErr text-danger">can\'t be blank</span>\
        </div>\
        <div class="col-md-5">\
            <input type="text" class="optionTitle form-control" placeholder="Option Title 1" name="options[title][]"/>\
            <span type="text" class="optionTitleErr text-danger">can\'t be blank</span>\
        </div>\
        <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)"><i class="fas fa-trash-alt"></i></div>\
        <input type="hidden" class="ans_pos" value="0">\
    </div>\
    <div class="row mt-2 options-row">\
            <div class="col-md-5">\
                <input type="text" class="optionValue form-control" placeholder="Option Value 2" name="options[value][]"/>\
                <span type="text" class="optionValueErr text-danger">can\'t be blank</span>\
            </div>\
            <div class="col-md-5">\
                <input type="text" class="optionTitle form-control" placeholder="Option Title 2" name="options[title][]"/>\
                <span type="text" class="optionTitleErr text-danger">can\'t be blank</span>\
            </div>\
            <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)"><i class="fas fa-trash-alt"></i></div>\
            <input type="hidden" class="ans_pos" value="1">\
    </div>\
    <div class="row mt-2 options-row">\
        <div class="col-md-5">\
            <input type="text" class="optionValue form-control" placeholder="Option Value 3" name="options[value][]"/>\
            <span type="text" class="optionValueErr text-danger">can\'t be blank</span>\
        </div>\
        <div class="col-md-5">\
            <input type="text" class="optionTitle form-control" placeholder="Option Title 3" name="options[title][]"/>\
            <span type="text" class="optionTitleErr text-danger">can\'t be blank</span>\
        </div>\
        <div class="col-md-2 justify-content-end d-flex remove-option" role="button" onclick="removeOption(this)"><i class="fas fa-trash-alt"></i></div>\
        <input type="hidden" class="ans_pos" value="2">\
    </div>';
    document.getElementById("options-div").innerHTML = optionsDefaultHtml;
    $(".optionValueErr").css("display", "none");
    $(".optionTitleErr").css("display", "none");
}

function validateGroupsAdd() {
    let isValid = true;

    $('.options-row').each(function () {
        const optionValue = $(this).find('.optionValue').val().trim();
        const optionTitle = $(this).find('.optionTitle').val().trim();
        if (!optionValue || !optionTitle) {
            isValid = false;
            return false;
        }
    });

    return isValid;
}

function addQA(type = null) {
    let errors = false;

    // Hide error messages
    $("#nq_display_label_err").hide();
    $("#nq_label_err").hide();
    $("#nq_name_err").hide();
    $(".optionValueErr").hide();
    $(".optionTitleErr").hide();

    if ($("#nq_display_label").val() == "") {
        $("#nq_display_label_err").show();
        return;
    }
    if ($("#nq_label").val() == "") {
        $("#nq_label_err").show();
        return;
    }
    if ($("#nq_name").val() == "") {
        $("#nq_name_err").show();
        return;
    }

    const nq_type = $("#nq_type").val();

    if ((nq_type === 'radio' || nq_type === 'checkbox' || nq_type === 'dropdown') && !validateGroupsAdd()) {
        alert('Please fill all the options before submitting the form.');
        return false;
    }

    const cal_id = Math.floor(Math.random() * 1000);
    let generatedHtml = newOptionsHtml(nq_type, type, cal_id);

    if (generatedHtml === undefined) {
        generatedHtml = ""; // Ensure it's defined
    }

    if (errors) {
        return false;
    } else {
        $("#input_field_form").attr("action", $("#addFieldFormVal").val());
        $("#input_field_form").submit();
    }
}

function updateQA() {
    errors = false;
    var updateDiv = $(".question_box" + $(".event_edit_id").val());

    const nq_display_name = document.getElementById("edit_nq_display_label").value;
    const nq_name = document.getElementById("edit_nq_name").value;
    const nq_type = document.getElementById("edit_nq_type").value;
    document.getElementById("edit_nq_display_label_err").style.display = "none";
    document.getElementById("edit_nq_name_err").style.display = "none";

    if (nq_display_name == "") {
        document.getElementById("edit_nq_display_label_err").style.display = "block";
        return false;
    }

    if (nq_name == "") {
        document.getElementById("edit_nq_name_err").style.display = "block";
        return false;
    }
    let generatedHtml = newOptionsHtml(
        nq_type,
        "edit-form",
        $(".event_edit_id").val()
    );
    console.log(errors);

    if (errors) {
        return false;
    } else {
        $("#input_field_form_update").submit();
        $("#editQuestionsModal").modal("hide");
    }
}

$(document).on(
    "change",
    "#edit_field_accept_value, #nq_field_accept_value",
    function () {
        if ($(this).data("form") == "add") {
            var field_type = $("#nq_type").val();
            if (field_type == "text") {
                $("#nq_default_value").val("");
            }
        } else {
            var field_type = $("#edit_nq_type").val();
            if (field_type == "text") {
                $("#edit_default_value").val("");
            }
        }
    }
);

// Default value validation upon Field Value Accept
function defaultValueValidation(event) {
    var $targetElement = $(event.target);

    var field_type = $("#nq_type").val();
    var formType = $targetElement.data("form");
    var fielId = formType === "edit" ? "edit_field_accept_value" : "nq_field_accept_value";

    var acceptValue = $("#" + fielId).val();

    if (field_type === "text") {

        // Define regex based on acceptValue
        let regex;
        switch (acceptValue) {
            case "1":
                regex = /^[a-zA-Z0-9 ]+$/; // Alphanumeric and spaces
                break;
            case "2":
                regex = /^[a-zA-Z ]+$/; // Alphabetic and spaces
                break;
            case "3":
                regex = /^[0-9]+$/; // Numeric only
                break;
            default:
                return true; // No validation needed
        }

        // Get the character pressed
        var char = String.fromCharCode(event.which);
        if (!regex.test(char)) {
            event.preventDefault();
            return false; // Prevent invalid input
        }
    }
}

// Field Type Change 
function fieldTypeChange(dis) {
    const fieldType = dis.value;

    // Hide the field accept value section and reset default value
    $("#field_default_value").show();
    $("#nq_field_accept_value_section").hide();
    $("#nq_default_value").val("").remove();
    $("#nq_default_value_section").html('<input type="text" name="default_value" class="form-control default_value_field" id="nq_default_value" data-form="add">');

    // Function to show options and clear input values
    const showOptionsAndClearInputs = () => {
        document.getElementById("options").style.display = "block";
        $("#options-div").find(".optionValue, .optionTitle").val('');
    };

    // Switch case for different field types
    switch (fieldType) {
        case "text":
            $("#nq_field_accept_value_section").show();
            document.getElementById("options").style.display = "none";
            break;
        case "date":
            $("#nq_default_value").addClass("fc-datepicker").prop("readonly", true).val("");
            $(".fc-datepicker").datepicker({
                dateFormat: "dd-mm-yy",
                changeYear: true,
                changeMonth: true,
            });
            document.getElementById("options").style.display = "none";
            break;
        case "textarea":
            document.getElementById("options").style.display = "none";
            break;
        case "radio":
        case "checkbox":
        case "dropdown":
            showOptionsAndClearInputs();
            break;
        case "image": // New case for image
            $("#field_default_value").hide();
        default:
            document.getElementById("options").style.display = "none";
            break;
    }
}


function addOptionsInEditField(dis) {
    var optionsCount = parseInt($("#options_count").val());
    var increasedCount = optionsCount + 1;
    if (optionsCount >= 1) {
        $("#edit-options-div")
            .find(".options-row:first .remove-option")
            .addClass("d-flex");
        $("#edit-options-div")
            .find(".options-row:first .remove-option")
            .removeClass("d-none");
    } else {
        $("#edit-options-div")
            .find(".options-row:first .remove-option")
            .removeClass("d-flex");
        $("#edit-options-div")
            .find(".options-row:first .remove-option")
            .addClass("d-none");
    }
    var clonedEle = $("#edit-options-div").find(".options-row:last").clone();
    clonedEle.find(".ans_pos").val(increasedCount);
    clonedEle.find(".optionValue").val("");
    clonedEle.find(".optionTitle").val("");
    clonedEle
        .find(".optionValue")
        .attr("placeholder", "Option Value " + increasedCount);
    clonedEle
        .find(".optionTitle")
        .attr("placeholder", "Option Title " + increasedCount);
    clonedEle.find(".optionValueErr").css("display", "none");
    clonedEle.find(".optionTitleErr").css("display", "none");
    clonedEle.appendTo("#edit-options-div");
    $("#options_count").val(increasedCount);
}

function addOptions(dis) {

    var lastOptionRow = $("#options-div").find(".options-row:last");

    // Get values from the last option
    var lastOptionValue = lastOptionRow.find(".optionValue").val();
    var lastOptionTitle = lastOptionRow.find(".optionTitle").val();

    // Check if both values are empty
    if (lastOptionValue == '' || lastOptionTitle == '') {
        alert("Please fill in the last option before adding a new one.");
        return; // Prevent adding a new option if the last one is empty
    }

    var optionsCount = parseInt($("#options_count").val());
    var increasedCount = optionsCount + 1;
    if (optionsCount >= 1) {
        $("#options-div")
            .find(".options-row:first .remove-option")
            .addClass("d-flex");
        $("#options-div")
            .find(".options-row:first .remove-option")
            .removeClass("d-none");
    } else {
        $("#options-div")
            .find(".options-row:first .remove-option")
            .removeClass("d-flex");
        $("#options-div")
            .find(".options-row:first .remove-option")
            .addClass("d-none");
    }
    var clonedEle = $("#options-div").find(".options-row:last").clone();
    clonedEle.find(".ans_pos").val(increasedCount);
    clonedEle.find(".optionValue").val("");
    clonedEle.find(".optionTitle").val("");
    clonedEle
        .find(".optionValue")
        .attr("placeholder", "Option Value " + increasedCount);
    clonedEle
        .find(".optionTitle")
        .attr("placeholder", "Option Title " + increasedCount);
    clonedEle.find(".optionValueErr").css("display", "none");
    clonedEle.find(".optionTitleErr").css("display", "none");
    clonedEle.appendTo("#options-div");
    $("#options_count").val(increasedCount);
}

function removeOption(dis, idname = "options-div") {
    var optionsCount = parseInt($("#options_count").val());
    var decreasedCount = optionsCount - 1;
    if ($("#" + idname + " .options-row").length <= 2) {
        $("#" + idname)
            .find(".options-row .remove-option")
            .removeClass("d-flex");
        $("#" + idname)
            .find(".options-row .remove-option")
            .addClass("d-none");
    } else {
        $("#" + idname)
            .find(".options-row:first .remove-option")
            .addClass("d-flex");
        $("#" + idname)
            .find(".options-row:first .remove-option")
            .removeClass("d-none");
    }
    $(dis).parents(".options-row").remove();
    $("#options_count").val(decreasedCount);
    $("#" + idname + "  .options-row").each(function (i) {
        let increasedCount = i + 1;
        $(this)
            .find(".optionValue")
            .attr("placeholder", "Option Value " + increasedCount);
        $(this)
            .find(".optionTitle")
            .attr("placeholder", "Option Title " + increasedCount);
        $(this).find(".ans_pos").val(i);
    });
}

function deleteCalQA(dis) {
    let cal_id = $(dis)
        .parents("#addQuestionsModal")
        .find(".event_edit_id")
        .val();
    let cal_db_id = $(".question_box" + cal_id)
        .find(".cal_db_id")
        .val();

    if (cal_db_id !== "") {
        let cal_del_ids = $("#cal_delete_ids").val();
        if (cal_del_ids == "") {
            $("#cal_delete_ids").val(cal_db_id);
        } else {
            $("#cal_delete_ids").val(cal_del_ids + "," + cal_db_id);
        }
        $(".question_box" + cal_id).remove();
    } else {
        $(".question_box" + cal_id).remove();
    }
    updateQuestionsPos();
    $("#addQuestionsModal").modal("hide");
}

function updateQuestionsPos() {
    $(".questions-div").each(function (i) {
        $(this).attr("data-pos", i); // updates the attribute
        $(this).find(".question_pos").val(i);
    });
}

function newOptionsHtml(type, formType = null, incrementId = null) {
    let html = "";
    if (type == "text") {
        html += '<input type="hidden">';
    } else if (type == "textarea") {
        html += '<input type="hidden">';
    } else if (type == "radio" || type == "checkbox" || type == "dropdown") {
        html += "<td>";
        var formOptionId = "options-div";

        if (formType == "edit-form") {
            formOptionId = "edit-options-div";
        }

        $("#" + formOptionId + " .options-row").each(function (i) {
            if ($(this).find(".optionValue").val() == "") {
                $(this).find(".optionValueErr").css("display", "block");
                errors = true;
                return false;
            }
            if ($(this).find(".optionTitle").val() == "") {
                $(this).find(".optionTitleErr").css("display", "block");
                errors = true;
                return false;
            }
            html +=
                '<div class="d-flex options-div">\
                <input type="hidden" class="option_value" name="form_field[' +
                incrementId +
                '][options][value][]"  value="' +
                $(this).find(".optionValue").val() +
                '">\
                <input type="hidden" name="question_option_pos[' +
                incrementId +
                "][" +
                i +
                ']" value="' +
                $(this).find(".ans_pos").val() +
                '">\
                <span class="mr-2">value= ' +
                $(this).find(".optionValue").val() +
                '</span>\
                <input type="hidden" class="option_title" name="form_field[' +
                incrementId +
                '][options][title][]"  value="' +
                $(this).find(".optionTitle").val() +
                '">\
                <input type="hidden" name="question_title_pos[' +
                incrementId +
                "][" +
                i +
                ']" value="' +
                $(this).find(".ans_pos").val() +
                '">\
                <span class="mr-2">, title= ' +
                $(this).find(".optionTitle").val() +
                "</span>\
                </div>";
        });
        html += "</td>";
    }

    if (errors) {
        return false;
    } else {
        return html;
    }
}
